package com.ibiz.wfweb2.r7rt_wf.service;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb2.r7rt_wf.domain.WFIAAction;
import com.ibiz.wfweb2.r7rt_wf.filter.*;
import com.ibiz.wfweb2.r7rt_wf.feign.WFIAActionFeignClient;
import com.ibiz.wfweb2.WFWeb2Application.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.log.IBIZLog;

@Slf4j
@IBIZLog
@Service
public class WFIAActionService {

    WFIAActionFeignClient client;

    @Autowired
    public WFIAActionService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFIAActionFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(WFIAActionFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public boolean remove( String wfiaaction_id) {
        return client.remove( wfiaaction_id);
    }

    public WFIAAction update(String wfiaaction_id, WFIAAction wfiaaction) {
        return client.update(wfiaaction_id, wfiaaction);
    }

    public WFIAAction save(String wfiaaction_id, WFIAAction wfiaaction) {
        return client.save(wfiaaction_id, wfiaaction);
    }

    public WFIAAction get( String wfiaaction_id) {
        return client.get( wfiaaction_id);
    }

    public boolean checkKey(WFIAAction wfiaaction) {
        return client.checkKey(wfiaaction);
    }

    public WFIAAction getDraft(String wfiaaction_id, WFIAAction wfiaaction) {
        return client.getDraft(wfiaaction_id, wfiaaction);
    }

	public WFIAAction create(WFIAAction wfiaaction) {
        return client.create(wfiaaction);
    }

	public Page<WFIAAction> fetchDefault(WFIAActionSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
