package com.ibiz.wfweb2.r7rt_org.controller;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import io.seata.spring.annotation.GlobalTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb2.r7rt_org.service.OrgService;
import com.ibiz.wfweb2.r7rt_org.domain.Org;
import com.ibiz.wfweb2.r7rt_org.filter.*;
import com.ibiz.util.log.IBIZLog;


@Slf4j
@IBIZLog
@RestController
@RequestMapping(value = "")
public class OrgController {
	@Autowired
    OrgService orgservice;


    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgs/getdraft")
    @PreAuthorize("@org_pms.check('CREATE')")
    public ResponseEntity<Org> getDraft() {
        //Org org = orgservice.getDraft( org_id);
        return ResponseEntity.status(HttpStatus.OK).body(new Org());
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgs/{org_id}/getorgprent")
    @PreAuthorize("@org_pms.check(#org_id,'READ')")
    public ResponseEntity<Org> getOrgPrent(@PathVariable("org_id") String org_id, @RequestBody Org org) {
        Org org2 = orgservice.getOrgPrent(org_id, org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.DELETE, value = "/orgs/{org_id}")
    @PreAuthorize("@org_pms.check(#org_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("org_id") String org_id) {
        boolean b = orgservice.remove( org_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.PUT, value = "/orgs/{org_id}")
    @PreAuthorize("@org_pms.check(#org_id,'UPDATE')")
    public ResponseEntity<Org> update(@PathVariable("org_id") String org_id, @RequestBody Org org) {
        Org org2 = orgservice.update(org_id, org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/orgs/{org_id}")
    @PreAuthorize("@org_pms.check(#org_id,'UPDATE')")
    public ResponseEntity<Org> api_update(@PathVariable("org_id") String org_id, @RequestBody Org org) {
        Org org2 = orgservice.update(org_id, org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgs/{org_id}")
    @PreAuthorize("@org_pms.check(#org_id,'READ')")
    public ResponseEntity<Org> get(@PathVariable("org_id") String org_id) {
        Org org = orgservice.get( org_id);
        return ResponseEntity.status(HttpStatus.OK).body(org);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgs")
    @PreAuthorize("@org_pms.check('CREATE')")
    public ResponseEntity<Org> create(@RequestBody Org org) {
        Org org2 = orgservice.create(org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgs/{org_id}/save")
    @PreAuthorize("@org_pms.check(#org_id,'')")
    public ResponseEntity<Org> save(@PathVariable("org_id") String org_id, @RequestBody Org org) {
        Org org2 = orgservice.save(org_id, org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgs/{org_id}/synctousergroup")
    @PreAuthorize("@org_pms.check(#org_id,'')")
    public ResponseEntity<Org> syncToUserGroup(@PathVariable("org_id") String org_id, @RequestBody Org org) {
        Org org2 = orgservice.syncToUserGroup(org_id, org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/orgs/checkkey")
    @PreAuthorize("@org_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody Org org) {
        boolean b = orgservice.checkKey(org);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/orgs/{org_id}/getorgchild")
    @PreAuthorize("@org_pms.check(#org_id,'READ')")
    public ResponseEntity<Org> getOrgChild(@PathVariable("org_id") String org_id, @RequestBody Org org) {
        Org org2 = orgservice.getOrgChild(org_id, org);
        return ResponseEntity.status(HttpStatus.OK).body(org2);
    }

    //@GlobalTransactional
    @RequestMapping(method= RequestMethod.GET , value="/orgs/fetchdefault")
    @PreAuthorize("@org_pms.check('READ')")
	public ResponseEntity<List<Org>> fetchDefault(OrgSearchContext searchContext,Pageable pageable) {
        
        Page<Org> page = orgservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional

}
