package com.ibiz.wfweb2.job;

import java.io.InputStream;
import java.util.List;
import java.util.ArrayList;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.core.io.ClassPathResource;

import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.domain.*;
import com.ibiz.util.log.IBIZLog;

/**
 *
 */
@Slf4j
@IBIZLog
@Component
public class WFAppJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFAppJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        /* ---------- 工作流应用注册内容 ---------- */

        // 注册工作流应用
        registWFApp();

        // 注册业务工作流版本
        registWFVer();

        // 注册流程处理
        registWFProcess();

        // 注册流程连接
        registWFLink();

        // 注册流程处理角色
        registWFProcRole();

        // 注册嵌套流程
        registPSWFProcSubWF();

    }

    /**
     * 注册工作流应用
     */
    private void registWFApp() {
        WFApp wfapp = new WFApp();
        wfapp.setWfappid(sysInfoProperties.getAppid());
        wfapp.setWfappname(sysInfoProperties.getAppname());
        wfapp.setPssystemid(sysInfoProperties.getSystemid());
        wfapp.setWorkflowid(sysInfoProperties.getDomainid());
        wfapp.setServiceid(sysInfoProperties.getServiceid());
        wfapp.setServiceurl(sysInfoProperties.getServiceurl());
        wfapp.setAppurl(sysInfoProperties.getAppurl());
        wfapp.setLogicname(sysInfoProperties.getApplogicname());
        uniWFFeignClient.registWFApp(wfapp);
    }

    /**
     * 注册业务工作流版本
     */
    private void registWFVer() {
        List<PSWFVersion> pswfversions = new ArrayList<PSWFVersion>();
        uniWFFeignClient.registPSWFVersion(pswfversions);
    }

    /**
     * 注册流程处理
     */
    private void registWFProcess() {
        List<PSWFProcess> pswfprocesses = new ArrayList<PSWFProcess>();
        uniWFFeignClient.registPSWFProcess(pswfprocesses);
    }

    /**
     * 注册流程连接
     */
    private void registWFLink() {
        List<PSWFLink> pswflinks = new ArrayList<PSWFLink>();
        uniWFFeignClient.registPSWFLink(pswflinks);
    }

    /**
     * 注册流程处理角色
     */
    private void registWFProcRole() {
        List<PSWFProcRole> pswfprocroles = new ArrayList<PSWFProcRole>();
        uniWFFeignClient.registPSWFProcRole(pswfprocroles);
    }

    /**
     * 注册嵌套流程
     */
    private void registPSWFProcSubWF() {
        List<PSWFProcSubWF> pswfprocsubwfs = new ArrayList<PSWFProcSubWF>();
        uniWFFeignClient.registPSWFProcSubWF(pswfprocsubwfs);
    }
}
