package com.ibiz.wfweb2.htwf.controller;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import io.seata.spring.annotation.GlobalTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb2.htwf.service.WFIMService;
import com.ibiz.wfweb2.htwf.domain.WFIM;
import com.ibiz.wfweb2.htwf.filter.*;
import com.ibiz.util.log.IBIZLog;


@Slf4j
@IBIZLog
@RestController
@RequestMapping(value = "")
public class WFIMController {
	@Autowired
    WFIMService wfimservice;


    //@GlobalTransactional
    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.DELETE, value = "/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfim_id") String wfim_id) {
        boolean b = wfimservice.remove( wfim_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.PUT, value = "/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'UPDATE')")
    public ResponseEntity<WFIM> update(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.update(wfim_id, wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'UPDATE')")
    public ResponseEntity<WFIM> api_update(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.update(wfim_id, wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/wfims/getdraft")
    @PreAuthorize("@wfim_pms.check('CREATE')")
    public ResponseEntity<WFIM> getDraft() {
        //WFIM wfim = wfimservice.getDraft( wfim_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFIM());
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/wfims/{wfim_id}/save")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'')")
    public ResponseEntity<WFIM> save(@PathVariable("wfim_id") String wfim_id, @RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.save(wfim_id, wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/wfims")
    @PreAuthorize("@wfim_pms.check('CREATE')")
    public ResponseEntity<WFIM> create(@RequestBody WFIM wfim) {
        WFIM wfim2 = wfimservice.create(wfim);
        return ResponseEntity.status(HttpStatus.OK).body(wfim2);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.GET, value = "/wfims/{wfim_id}")
    @PreAuthorize("@wfim_pms.check(#wfim_id,'READ')")
    public ResponseEntity<WFIM> get(@PathVariable("wfim_id") String wfim_id) {
        WFIM wfim = wfimservice.get( wfim_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfim);
    }

    //@GlobalTransactional
	@RequestMapping(method = RequestMethod.POST, value = "/wfims/checkkey")
    @PreAuthorize("@wfim_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFIM wfim) {
        boolean b = wfimservice.checkKey(wfim);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    //@GlobalTransactional
    @RequestMapping(method= RequestMethod.GET , value="/wfims/fetchdefault")
    @PreAuthorize("@wfim_pms.check('READ')")
	public ResponseEntity<List<WFIM>> fetchDefault(WFIMSearchContext searchContext,Pageable pageable) {
        
        Page<WFIM> page = wfimservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional
    //@GlobalTransactional

}
