package com.ibiz.wfweb2;

import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.ibiz.util.web.SearchContextHandlerMethodArgumentResolver;
import com.ibiz.util.serialize.DomainSerializerProvider;

@Slf4j
@SpringBootApplication(exclude = {

})
@Import({
    FeignClientsConfiguration.class
})
@ComponentScans({
        @ComponentScan(basePackages = {"com.ibiz.util", "com.ibiz.wfweb2"})
})
@EnableDiscoveryClient
@Configuration
@EnableFeignClients
@EnableConfigurationProperties(com.ibiz.wfweb2.WFWeb2Application.WebClientProperties.class)
public class WFWeb2Application extends WebMvcConfigurerAdapter{

    public static void main(String[] args) {
        SpringApplicationBuilder builder=new SpringApplicationBuilder(WFWeb2Application.class);
        builder.run(args);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter(ObjectMapper objectMapper) {
    	objectMapper.setSerializerProvider(new DomainSerializerProvider()) ;
    	final MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(objectMapper);
        return converter;
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add(new SearchContextHandlerMethodArgumentResolver());
    }

    @ConfigurationProperties(prefix = "app.service.web")
    @Data
    public class WebClientProperties {

    	private String tokenUrl ;

    	private String clientId ;

    	private String clientSecret ;

    	private String serviceUrl ;

    	private String serviceId ;

    }
}
