package com.ibiz.wfweb2.security.userdetail;

import com.ibiz.util.security.userdetail.LoginUser;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;


import java.util.ArrayList;
import java.util.List;

public class LoginUserDetailService implements UserDetailsService {
    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {

        List<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>() ;
        SimpleGrantedAuthority userAuthority = new SimpleGrantedAuthority("USER");
        authorities.add(userAuthority);
        if(username.equals("admin")){
            SimpleGrantedAuthority adminAuthority = new SimpleGrantedAuthority("ADMIN");
            authorities.add(adminAuthority);
        }
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder() ;
        LoginUser user = new LoginUser(username,passwordEncoder.encode("123456"),authorities) ;
        return user;

    }
}
