package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.htwf.valuerule.anno.wfas.*;
import com.ibiz.core.htwf.domain.WFAS;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[WFASDTO]
 */
public class WFASDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @WFASUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @WFASUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [PROXYDATAID]
     *
     */
    @WFASProxydataidDefault(info = "默认规则")
    private String proxydataid;

    @JsonIgnore
    private boolean proxydataidDirtyFlag;

    /**
     * 属性 [WFSTATE]
     *
     */
    @WFASWfstateDefault(info = "默认规则")
    private Integer wfstate;

    @JsonIgnore
    private boolean wfstateDirtyFlag;

    /**
     * 属性 [WFASNAME]
     *
     */
    @WFASWFASNameDefault(info = "默认规则")
    private String wFASName;

    @JsonIgnore
    private boolean wFASNameDirtyFlag;

    /**
     * 属性 [WFASID]
     *
     */
    @WFASWFASIdDefault(info = "默认规则")
    private String wFASId;

    @JsonIgnore
    private boolean wFASIdDirtyFlag;

    /**
     * 属性 [PROXYMODULEID]
     *
     */
    @WFASProxymoduleidDefault(info = "默认规则")
    private String proxymoduleid;

    @JsonIgnore
    private boolean proxymoduleidDirtyFlag;

    /**
     * 属性 [ASWFSTATE]
     *
     */
    @WFASAswfstateDefault(info = "默认规则")
    private String aswfstate;

    @JsonIgnore
    private boolean aswfstateDirtyFlag;

    /**
     * 属性 [WFSTEP]
     *
     */
    @WFASWfstepDefault(info = "默认规则")
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @WFASWfinstanceidDefault(info = "默认规则")
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @WFASCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @WFASCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;


    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public String getProxydataid(){
        return proxydataid ;
    }

    /**
     * 设置 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public void setProxydataid(String  proxydataid){
        this.proxydataid = proxydataid ;
        this.proxydataidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYDATAID]脏标记
     */
    @JsonIgnore
    public boolean getProxydataidDirtyFlag(){
        return proxydataidDirtyFlag ;
    }

    /**
     * 获取 [WFSTATE]
     */
    @JsonProperty("wfstate")
    public Integer getWfstate(){
        return wfstate ;
    }

    /**
     * 设置 [WFSTATE]
     */
    @JsonProperty("wfstate")
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.wfstateDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getWfstateDirtyFlag(){
        return wfstateDirtyFlag ;
    }

    /**
     * 获取 [WFASNAME]
     */
    @JsonProperty("wfasname")
    public String getWFASName(){
        return wFASName ;
    }

    /**
     * 设置 [WFASNAME]
     */
    @JsonProperty("wfasname")
    public void setWFASName(String  wFASName){
        this.wFASName = wFASName ;
        this.wFASNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFASNAME]脏标记
     */
    @JsonIgnore
    public boolean getWFASNameDirtyFlag(){
        return wFASNameDirtyFlag ;
    }

    /**
     * 获取 [WFASID]
     */
    @JsonProperty("wfasid")
    public String getWFASId(){
        return wFASId ;
    }

    /**
     * 设置 [WFASID]
     */
    @JsonProperty("wfasid")
    public void setWFASId(String  wFASId){
        this.wFASId = wFASId ;
        this.wFASIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFASID]脏标记
     */
    @JsonIgnore
    public boolean getWFASIdDirtyFlag(){
        return wFASIdDirtyFlag ;
    }

    /**
     * 获取 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public String getProxymoduleid(){
        return proxymoduleid ;
    }

    /**
     * 设置 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public void setProxymoduleid(String  proxymoduleid){
        this.proxymoduleid = proxymoduleid ;
        this.proxymoduleidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    public boolean getProxymoduleidDirtyFlag(){
        return proxymoduleidDirtyFlag ;
    }

    /**
     * 获取 [ASWFSTATE]
     */
    @JsonProperty("aswfstate")
    public String getAswfstate(){
        return aswfstate ;
    }

    /**
     * 设置 [ASWFSTATE]
     */
    @JsonProperty("aswfstate")
    public void setAswfstate(String  aswfstate){
        this.aswfstate = aswfstate ;
        this.aswfstateDirtyFlag = true ;
    }

    /**
     * 获取 [ASWFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getAswfstateDirtyFlag(){
        return aswfstateDirtyFlag ;
    }

    /**
     * 获取 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return wfstep ;
    }

    /**
     * 设置 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEP]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return wfstepDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }



    public WFAS toDO() {
        WFAS srfdomain = new WFAS();
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getProxydataidDirtyFlag())
            srfdomain.setProxydataid(proxydataid);
        if(getWfstateDirtyFlag())
            srfdomain.setWfstate(wfstate);
        if(getWFASNameDirtyFlag())
            srfdomain.setWFASName(wFASName);
        if(getWFASIdDirtyFlag())
            srfdomain.setWFASId(wFASId);
        if(getProxymoduleidDirtyFlag())
            srfdomain.setProxymoduleid(proxymoduleid);
        if(getAswfstateDirtyFlag())
            srfdomain.setAswfstate(aswfstate);
        if(getWfstepDirtyFlag())
            srfdomain.setWfstep(wfstep);
        if(getWfinstanceidDirtyFlag())
            srfdomain.setWfinstanceid(wfinstanceid);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);

        return srfdomain;
    }

    public void fromDO(WFAS srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getProxydataidDirtyFlag())
            this.setProxydataid(srfdomain.getProxydataid());
        if(srfdomain.getWfstateDirtyFlag())
            this.setWfstate(srfdomain.getWfstate());
        if(srfdomain.getWFASNameDirtyFlag())
            this.setWFASName(srfdomain.getWFASName());
        if(srfdomain.getWFASIdDirtyFlag())
            this.setWFASId(srfdomain.getWFASId());
        if(srfdomain.getProxymoduleidDirtyFlag())
            this.setProxymoduleid(srfdomain.getProxymoduleid());
        if(srfdomain.getAswfstateDirtyFlag())
            this.setAswfstate(srfdomain.getAswfstate());
        if(srfdomain.getWfstepDirtyFlag())
            this.setWfstep(srfdomain.getWfstep());
        if(srfdomain.getWfinstanceidDirtyFlag())
            this.setWfinstanceid(srfdomain.getWfinstanceid());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());

    }

    public List<WFASDTO> fromDOPage(List<WFAS> poPage)   {
        if(poPage == null)
            return null;
        List<WFASDTO> dtos=new ArrayList<WFASDTO>();
        for(WFAS domain : poPage) {
            WFASDTO dto = new WFASDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

