package com.ibiz.web.security.userdetail;

import org.springframework.data.domain.Page;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import com.ibiz.util.helper.SpringContextHolder;
import com.ibiz.util.security.userdetail.LoginUser;
import com.ibiz.util.web.AppContextConstants;
import com.ibiz.web.r7rt_org.domain.OrgDeptUser;
import com.ibiz.web.r7rt_org.domain.OrgUser;
import com.ibiz.web.r7rt_org.filter.OrgDeptUserSearchContext;
import com.ibiz.web.r7rt_org.filter.OrgUserSearchContext;
import com.ibiz.web.r7rt_org.service.OrgDeptUserService;
import com.ibiz.web.r7rt_org.service.OrgUserService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class LoginUserDetailService implements UserDetailsService {
	
	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
		
		OrgUserService orgUserService = SpringContextHolder.getBean(OrgUserService.class);
		OrgUserSearchContext orgUserContext = new OrgUserSearchContext();
		orgUserContext.set("n_usercode_eq", username);
		Page<OrgUser> orgUsers = orgUserService.fetchDefault(orgUserContext);
		if (!orgUsers.hasContent()) {
			throw new RuntimeException("无法获取组织用户");
		}
		
		// 获取组织人员信息
		OrgUser orgUser = orgUsers.getContent().get(0);
		List<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
		BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
		LoginUser user = new LoginUser(username, passwordEncoder.encode("123456"), authorities);
		user.setPersonId(orgUser.getOrgUserId());
		user.setOrgUserId(orgUser.getOrgUserId());
		user.setOrgUserName(orgUser.getOrgUserName());
		user.setOrgId(orgUser.getOrgId());
		user.setOrgName(orgUser.getOrgName());
		user.setUserMode("default");
		user.setTimeZone(TimeZone.getDefault());
		user.setLocale(Locale.CHINESE);
		user.setSuperUser(false);

		// 获取部门信息
		OrgDeptUserService orgDeptUserService = SpringContextHolder.getBean(OrgDeptUserService.class);
		OrgDeptUserSearchContext orgDeptUserContext = new OrgDeptUserSearchContext();
		orgDeptUserContext.set("n_orguserid_eq", orgUser.getOrgUserId());
		Page<OrgDeptUser> orgDeptUsers = orgDeptUserService.fetchDefault(orgDeptUserContext);
		if (orgDeptUsers.hasContent()) {
			user.setOrgDeptId(orgDeptUsers.getContent().get(0).getOrgDeptId());
			user.setOrgDeptName(orgDeptUsers.getContent().get(0).getOrgDeptName());
			
			for (OrgDeptUser orgDeptUser : orgDeptUsers) {
				Map deptInfo = new HashMap<String, String>() ;
				deptInfo.put(AppContextConstants.CONTEXT_ORGSECTORID, orgDeptUser.getOrgDeptId());
				deptInfo.put(AppContextConstants.CONTEXT_ORGSECTORNAME, orgDeptUser.getOrgDeptName());
				user.getOrgDepts().add(deptInfo) ;	
			}
			
		}
		
		return user;

	}
}

