package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.htwf.valuerule.anno.wfbm.*;
import com.ibiz.core.htwf.domain.WFBM;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[WFBMDTO]
 */
public class WFBMDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [BMWFSTATE]
     *
     */
    @WFBMBmwfstateDefault(info = "默认规则")
    private String bmwfstate;

    @JsonIgnore
    private boolean bmwfstateDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @WFBMCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [PROXYDATAID]
     *
     */
    @WFBMProxydataidDefault(info = "默认规则")
    private String proxydataid;

    @JsonIgnore
    private boolean proxydataidDirtyFlag;

    /**
     * 属性 [PROXYMODULEID]
     *
     */
    @WFBMProxymoduleidDefault(info = "默认规则")
    private String proxymoduleid;

    @JsonIgnore
    private boolean proxymoduleidDirtyFlag;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @WFBMWfinstanceidDefault(info = "默认规则")
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @WFBMCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [WFBMID]
     *
     */
    @WFBMWFBMIdDefault(info = "默认规则")
    private String wFBMId;

    @JsonIgnore
    private boolean wFBMIdDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @WFBMUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [WFSTATE]
     *
     */
    @WFBMWfstateDefault(info = "默认规则")
    private Integer wfstate;

    @JsonIgnore
    private boolean wfstateDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @WFBMUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [WFBMNAME]
     *
     */
    @WFBMWFBMNameDefault(info = "默认规则")
    private String wFBMName;

    @JsonIgnore
    private boolean wFBMNameDirtyFlag;

    /**
     * 属性 [WFSTEP]
     *
     */
    @WFBMWfstepDefault(info = "默认规则")
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;


    /**
     * 获取 [BMWFSTATE]
     */
    @JsonProperty("bmwfstate")
    public String getBmwfstate(){
        return bmwfstate ;
    }

    /**
     * 设置 [BMWFSTATE]
     */
    @JsonProperty("bmwfstate")
    public void setBmwfstate(String  bmwfstate){
        this.bmwfstate = bmwfstate ;
        this.bmwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [BMWFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getBmwfstateDirtyFlag(){
        return bmwfstateDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public String getProxydataid(){
        return proxydataid ;
    }

    /**
     * 设置 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public void setProxydataid(String  proxydataid){
        this.proxydataid = proxydataid ;
        this.proxydataidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYDATAID]脏标记
     */
    @JsonIgnore
    public boolean getProxydataidDirtyFlag(){
        return proxydataidDirtyFlag ;
    }

    /**
     * 获取 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public String getProxymoduleid(){
        return proxymoduleid ;
    }

    /**
     * 设置 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public void setProxymoduleid(String  proxymoduleid){
        this.proxymoduleid = proxymoduleid ;
        this.proxymoduleidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    public boolean getProxymoduleidDirtyFlag(){
        return proxymoduleidDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [WFBMID]
     */
    @JsonProperty("wfbmid")
    public String getWFBMId(){
        return wFBMId ;
    }

    /**
     * 设置 [WFBMID]
     */
    @JsonProperty("wfbmid")
    public void setWFBMId(String  wFBMId){
        this.wFBMId = wFBMId ;
        this.wFBMIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFBMID]脏标记
     */
    @JsonIgnore
    public boolean getWFBMIdDirtyFlag(){
        return wFBMIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [WFSTATE]
     */
    @JsonProperty("wfstate")
    public Integer getWfstate(){
        return wfstate ;
    }

    /**
     * 设置 [WFSTATE]
     */
    @JsonProperty("wfstate")
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.wfstateDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getWfstateDirtyFlag(){
        return wfstateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [WFBMNAME]
     */
    @JsonProperty("wfbmname")
    public String getWFBMName(){
        return wFBMName ;
    }

    /**
     * 设置 [WFBMNAME]
     */
    @JsonProperty("wfbmname")
    public void setWFBMName(String  wFBMName){
        this.wFBMName = wFBMName ;
        this.wFBMNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFBMNAME]脏标记
     */
    @JsonIgnore
    public boolean getWFBMNameDirtyFlag(){
        return wFBMNameDirtyFlag ;
    }

    /**
     * 获取 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return wfstep ;
    }

    /**
     * 设置 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEP]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return wfstepDirtyFlag ;
    }



    public WFBM toDO() {
        WFBM srfdomain = new WFBM();
        if(getBmwfstateDirtyFlag())
            srfdomain.setBmwfstate(bmwfstate);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getProxydataidDirtyFlag())
            srfdomain.setProxydataid(proxydataid);
        if(getProxymoduleidDirtyFlag())
            srfdomain.setProxymoduleid(proxymoduleid);
        if(getWfinstanceidDirtyFlag())
            srfdomain.setWfinstanceid(wfinstanceid);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getWFBMIdDirtyFlag())
            srfdomain.setWFBMId(wFBMId);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getWfstateDirtyFlag())
            srfdomain.setWfstate(wfstate);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getWFBMNameDirtyFlag())
            srfdomain.setWFBMName(wFBMName);
        if(getWfstepDirtyFlag())
            srfdomain.setWfstep(wfstep);

        return srfdomain;
    }

    public void fromDO(WFBM srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getBmwfstateDirtyFlag())
            this.setBmwfstate(srfdomain.getBmwfstate());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getProxydataidDirtyFlag())
            this.setProxydataid(srfdomain.getProxydataid());
        if(srfdomain.getProxymoduleidDirtyFlag())
            this.setProxymoduleid(srfdomain.getProxymoduleid());
        if(srfdomain.getWfinstanceidDirtyFlag())
            this.setWfinstanceid(srfdomain.getWfinstanceid());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getWFBMIdDirtyFlag())
            this.setWFBMId(srfdomain.getWFBMId());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getWfstateDirtyFlag())
            this.setWfstate(srfdomain.getWfstate());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getWFBMNameDirtyFlag())
            this.setWFBMName(srfdomain.getWFBMName());
        if(srfdomain.getWfstepDirtyFlag())
            this.setWfstep(srfdomain.getWfstep());

    }

    public List<WFBMDTO> fromDOPage(List<WFBM> poPage)   {
        if(poPage == null)
            return null;
        List<WFBMDTO> dtos=new ArrayList<WFBMDTO>();
        for(WFBM domain : poPage) {
            WFBMDTO dto = new WFBMDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

