package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.WFSTEPDATADTO;
import com.ibiz.core.r7rt_wf.domain.WFSTEPDATA;
import com.ibiz.core.r7rt_wf.service.IWFSTEPDATAService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.r7rt_wf.filter.WFSTEPDATASearchContext;

@Api(tags = {"WFSTEPDATA" })
@RestController
@RequestMapping("")
public class WFSTEPDATAResource {

    @Autowired
    private IWFSTEPDATAService wfstepdataService;

    public IWFSTEPDATAService getWfstepdataService() {
        return this.wfstepdataService;
    }

    @ApiOperation(value = "CheckKey", tags = {"WFSTEPDATA" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfstepdata/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFSTEPDATADTO wfstepdatadto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Get", tags = {"WFSTEPDATA" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfstepdata/{wfstepdata_id}")
    public ResponseEntity<WFSTEPDATADTO> get(@PathVariable("wfstepdata_id") String wfstepdata_id) {
        WFSTEPDATADTO dto = new WFSTEPDATADTO();
        WFSTEPDATA domain = wfstepdataService.get(wfstepdata_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"WFSTEPDATA" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfstepdata/{wfstepdata_id}/getdraft")

    public ResponseEntity<WFSTEPDATADTO> getDraft(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATADTO wfstepdatadto) {
        WFSTEPDATA wfstepdata = wfstepdatadto.toDO();
    	wfstepdata = wfstepdataService.getDraft(wfstepdata) ;
    	wfstepdatadto.fromDO(wfstepdata);
        return ResponseEntity.status(HttpStatus.OK).body(wfstepdatadto);
    }

    @ApiOperation(value = "Create", tags = {"WFSTEPDATA" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfstepdata")

    public ResponseEntity<WFSTEPDATADTO> create(@RequestBody WFSTEPDATADTO wfstepdatadto) {
        WFSTEPDATADTO dto = new WFSTEPDATADTO();
        WFSTEPDATA domain = wfstepdatadto.toDO();
		wfstepdataService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"WFSTEPDATA" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfstepdata/{wfstepdata_id}")

    public ResponseEntity<WFSTEPDATADTO> update(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATADTO wfstepdatadto) {
		WFSTEPDATA domain = wfstepdatadto.toDO();
        domain.setWFSTEPDATAId(wfstepdata_id);
		wfstepdataService.update(domain);
		WFSTEPDATADTO dto = new WFSTEPDATADTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"WFSTEPDATA" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfstepdata/{wfstepdata_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody WFSTEPDATADTO wfstepdatadto) {
        WFSTEPDATA wfstepdata = wfstepdatadto.toDO();
    	Boolean b = wfstepdataService.save(wfstepdata) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Remove", tags = {"WFSTEPDATA" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfstepdata/{wfstepdata_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("wfstepdata_id") String wfstepdata_id) {
        WFSTEPDATADTO wfstepdatadto = new WFSTEPDATADTO();
		WFSTEPDATA domain = new WFSTEPDATA();
		wfstepdatadto.setWFSTEPDATAId(wfstepdata_id);
		domain.setWFSTEPDATAId(wfstepdata_id);
        Boolean rst = wfstepdataService.remove(domain.getWFSTEPDATAId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

	@ApiOperation(value = "获取ByBswfdata", tags = {"WFSTEPDATA" } ,notes = "获取ByBswfdata")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfstepdata/fetchbybswfdata")
	public ResponseEntity<Page<WFSTEPDATADTO>> fetchByBswfdata(WFSTEPDATASearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFSTEPDATADTO> list = new ArrayList<WFSTEPDATADTO>();
        
        Page<WFSTEPDATA> domains = wfstepdataService.searchByBswfdata(context) ;
        for(WFSTEPDATA wfstepdata : domains.getContent()){
            WFSTEPDATADTO dto = new WFSTEPDATADTO();
            dto.fromDO(wfstepdata);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取ByBsdata", tags = {"WFSTEPDATA" } ,notes = "获取ByBsdata")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfstepdata/fetchbybsdata")
	public ResponseEntity<Page<WFSTEPDATADTO>> fetchByBsdata(WFSTEPDATASearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFSTEPDATADTO> list = new ArrayList<WFSTEPDATADTO>();
        
        Page<WFSTEPDATA> domains = wfstepdataService.searchByBsdata(context) ;
        for(WFSTEPDATA wfstepdata : domains.getContent()){
            WFSTEPDATADTO dto = new WFSTEPDATADTO();
            dto.fromDO(wfstepdata);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取DEFAULT", tags = {"WFSTEPDATA" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfstepdata/fetchdefault")
	public ResponseEntity<Page<WFSTEPDATADTO>> fetchDefault(WFSTEPDATASearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFSTEPDATADTO> list = new ArrayList<WFSTEPDATADTO>();
        
        Page<WFSTEPDATA> domains = wfstepdataService.searchDefault(context) ;
        for(WFSTEPDATA wfstepdata : domains.getContent()){
            WFSTEPDATADTO dto = new WFSTEPDATADTO();
            dto.fromDO(wfstepdata);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
