package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.PSDTO;
import com.ibiz.core.ps.domain.PS;
import com.ibiz.core.ps.service.IPSService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.ps.filter.PSSearchContext;

@Api(tags = {"PS" })
@RestController
@RequestMapping("")
public class PSResource {

    @Autowired
    private IPSService psService;

    public IPSService getPsService() {
        return this.psService;
    }

    @ApiOperation(value = "Get", tags = {"PS" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/ps/{ps_id}")
    public ResponseEntity<PSDTO> get(@PathVariable("ps_id") String ps_id) {
        PSDTO dto = new PSDTO();
        PS domain = psService.get(ps_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"PS" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/ps/{ps_id}")

    public ResponseEntity<PSDTO> update(@PathVariable("ps_id") String ps_id, @RequestBody PSDTO psdto) {
		PS domain = psdto.toDO();
        domain.setPSId(ps_id);
		psService.update(domain);
		PSDTO dto = new PSDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Create", tags = {"PS" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ps")

    public ResponseEntity<PSDTO> create(@RequestBody PSDTO psdto) {
        PSDTO dto = new PSDTO();
        PS domain = psdto.toDO();
		psService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"PS" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ps/{ps_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody PSDTO psdto) {
        PS ps = psdto.toDO();
    	Boolean b = psService.save(ps) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "GetDraft", tags = {"PS" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/ps/{ps_id}/getdraft")

    public ResponseEntity<PSDTO> getDraft(@PathVariable("ps_id") String ps_id, @RequestBody PSDTO psdto) {
        PS ps = psdto.toDO();
    	ps = psService.getDraft(ps) ;
    	psdto.fromDO(ps);
        return ResponseEntity.status(HttpStatus.OK).body(psdto);
    }

    @ApiOperation(value = "CheckKey", tags = {"PS" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PSDTO psdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Remove", tags = {"PS" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/ps/{ps_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("ps_id") String ps_id) {
        PSDTO psdto = new PSDTO();
		PS domain = new PS();
		psdto.setPSId(ps_id);
		domain.setPSId(ps_id);
        Boolean rst = psService.remove(domain.getPSId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"PS" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/ps/fetchdefault")
	public ResponseEntity<Page<PSDTO>> fetchDefault(PSSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<PSDTO> list = new ArrayList<PSDTO>();
        
        Page<PS> domains = psService.searchDefault(context) ;
        for(PS ps : domains.getContent()){
            PSDTO dto = new PSDTO();
            dto.fromDO(ps);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
