package com.ibiz.wfweb2.ht.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[重要事项]
 */
public class IM implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 跨公司领导人员清单
     */
    private String kgsldids;

    @JsonIgnore
    private boolean kgsldidsDirtyFlag;
    
    /**
     * 备注
     */
    private String bz;

    @JsonIgnore
    private boolean bzDirtyFlag;
    
    /**
     * 申报类别
     */
    private String sblb;

    @JsonIgnore
    private boolean sblbDirtyFlag;
    
    /**
     * 部门领导人员清单
     */
    private String bmldids;

    @JsonIgnore
    private boolean bmldidsDirtyFlag;
    
    /**
     * 加急原因
     */
    private String jjyy;

    @JsonIgnore
    private boolean jjyyDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 会签部门
     */
    private String hqbm;

    @JsonIgnore
    private boolean hqbmDirtyFlag;
    
    /**
     * 送达方式
     */
    private String sdfs;

    @JsonIgnore
    private boolean sdfsDirtyFlag;
    
    /**
     * 跨公司部门人员清单
     */
    private String kgsbmids;

    @JsonIgnore
    private boolean kgsbmidsDirtyFlag;
    
    /**
     * 上级部门
     */
    private Integer sjbm;

    @JsonIgnore
    private boolean sjbmDirtyFlag;
    
    /**
     * 其他通知阅读对象
     */
    private String qttzyddx;

    @JsonIgnore
    private boolean qttzyddxDirtyFlag;
    
    /**
     * 领导
     */
    private String ld;

    @JsonIgnore
    private boolean ldDirtyFlag;
    
    /**
     * 标题
     */
    private String iMName;

    @JsonIgnore
    private boolean iMNameDirtyFlag;
    
    /**
     * 流程编号
     */
    private String lcbh;

    @JsonIgnore
    private boolean lcbhDirtyFlag;
    
    /**
     * 内部审核人员清单
     */
    private String ngshids;

    @JsonIgnore
    private boolean ngshidsDirtyFlag;
    
    /**
     * 跨公司领导
     */
    private String kgsld;

    @JsonIgnore
    private boolean kgsldDirtyFlag;
    
    /**
     * 审核方式
     */
    private String shfs;

    @JsonIgnore
    private boolean shfsDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 重要事项标识
     */
    private String iMId;

    @JsonIgnore
    private boolean iMIdDirtyFlag;
    
    /**
     * 申报类型
     */
    private String sblx;

    @JsonIgnore
    private boolean sblxDirtyFlag;
    
    /**
     * 通知阅读
     */
    private Integer tzyd;

    @JsonIgnore
    private boolean tzydDirtyFlag;
    
    /**
     * 流程实例
     */
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;
    
    /**
     * 部门领导
     */
    private String bmld;

    @JsonIgnore
    private boolean bmldDirtyFlag;
    
    /**
     * 通知阅读原因
     */
    private String tzydyy;

    @JsonIgnore
    private boolean tzydyyDirtyFlag;
    
    /**
     * 工作流状态
     */
    private String imwfstate;

    @JsonIgnore
    private boolean imwfstateDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * 阅知对象
     */
    private String yzdx;

    @JsonIgnore
    private boolean yzdxDirtyFlag;
    
    /**
     * 内部审核
     */
    private String ngsh;

    @JsonIgnore
    private boolean ngshDirtyFlag;
    
    /**
     * 缓急程度
     */
    private String hjcd;

    @JsonIgnore
    private boolean hjcdDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 领导人员清单
     */
    private String ldids;

    @JsonIgnore
    private boolean ldidsDirtyFlag;
    
    /**
     * 会签部门人员清单
     */
    private String hqbmids;

    @JsonIgnore
    private boolean hqbmidsDirtyFlag;
    
    /**
     * 跨公司部门
     */
    private String kgsbm;

    @JsonIgnore
    private boolean kgsbmDirtyFlag;
    
    /**
     * 重要事项审批步骤
     */
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;
    
    /**
     * 主办部门
     */
    private String zbbm;

    @JsonIgnore
    private boolean zbbmDirtyFlag;
    
    /**
     * 拟稿日期
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    private Timestamp ngrq;

    @JsonIgnore
    private boolean ngrqDirtyFlag;
    
    /**
     * 拟稿人联系方式
     */
    private String ngrlxfs;

    @JsonIgnore
    private boolean ngrlxfsDirtyFlag;
    
    /**
     * 拟稿人所在机构
     */
    private String ngrjg;

    @JsonIgnore
    private boolean ngrjgDirtyFlag;
    
    /**
     * 拟稿人所在部门
     */
    private String ngrbmname;

    @JsonIgnore
    private boolean ngrbmnameDirtyFlag;
    
    /**
     * 拟稿人
     */
    private String ngrname;

    @JsonIgnore
    private boolean ngrnameDirtyFlag;
    
    /**
     * 组织用户标识
     */
    private String ngrid;

    @JsonIgnore
    private boolean ngridDirtyFlag;
    
    /**
     * 部门标识
     */
    private String ngrbmid;

    @JsonIgnore
    private boolean ngrbmidDirtyFlag;
    
    /**
     * PSID
     */
    private String psid;

    @JsonIgnore
    private boolean psidDirtyFlag;
    
    /**
     * REST
     */
    private String rest;

    @JsonIgnore
    private boolean restDirtyFlag;
    

    /**
     * 获取 [跨公司领导人员清单]
     */
    @JsonProperty("kgsldids")
    public String getKgsldids(){
        return this.kgsldids ;
    }

    /**
     * 设置 [跨公司领导人员清单]
     */
    @JsonProperty("kgsldids")
    public void setKgsldids(String  kgsldids){
        this.kgsldids = kgsldids ;
        this.kgsldidsDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司领导人员清单]脏标记
     */
    @JsonIgnore
    public boolean getKgsldidsDirtyFlag(){
        return this.kgsldidsDirtyFlag ;
    }

    /**
     * 获取 [备注]
     */
    @JsonProperty("bz")
    public String getBz(){
        return this.bz ;
    }

    /**
     * 设置 [备注]
     */
    @JsonProperty("bz")
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [备注]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return this.bzDirtyFlag ;
    }

    /**
     * 获取 [申报类别]
     */
    @JsonProperty("sblb")
    public String getSblb(){
        return this.sblb ;
    }

    /**
     * 设置 [申报类别]
     */
    @JsonProperty("sblb")
    public void setSblb(String  sblb){
        this.sblb = sblb ;
        this.sblbDirtyFlag = true ;
    }

    /**
     * 获取 [申报类别]脏标记
     */
    @JsonIgnore
    public boolean getSblbDirtyFlag(){
        return this.sblbDirtyFlag ;
    }

    /**
     * 获取 [部门领导人员清单]
     */
    @JsonProperty("bmldids")
    public String getBmldids(){
        return this.bmldids ;
    }

    /**
     * 设置 [部门领导人员清单]
     */
    @JsonProperty("bmldids")
    public void setBmldids(String  bmldids){
        this.bmldids = bmldids ;
        this.bmldidsDirtyFlag = true ;
    }

    /**
     * 获取 [部门领导人员清单]脏标记
     */
    @JsonIgnore
    public boolean getBmldidsDirtyFlag(){
        return this.bmldidsDirtyFlag ;
    }

    /**
     * 获取 [加急原因]
     */
    @JsonProperty("jjyy")
    public String getJjyy(){
        return this.jjyy ;
    }

    /**
     * 设置 [加急原因]
     */
    @JsonProperty("jjyy")
    public void setJjyy(String  jjyy){
        this.jjyy = jjyy ;
        this.jjyyDirtyFlag = true ;
    }

    /**
     * 获取 [加急原因]脏标记
     */
    @JsonIgnore
    public boolean getJjyyDirtyFlag(){
        return this.jjyyDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [会签部门]
     */
    @JsonProperty("hqbm")
    public String getHqbm(){
        return this.hqbm ;
    }

    /**
     * 设置 [会签部门]
     */
    @JsonProperty("hqbm")
    public void setHqbm(String  hqbm){
        this.hqbm = hqbm ;
        this.hqbmDirtyFlag = true ;
    }

    /**
     * 获取 [会签部门]脏标记
     */
    @JsonIgnore
    public boolean getHqbmDirtyFlag(){
        return this.hqbmDirtyFlag ;
    }

    /**
     * 获取 [送达方式]
     */
    @JsonProperty("sdfs")
    public String getSdfs(){
        return this.sdfs ;
    }

    /**
     * 设置 [送达方式]
     */
    @JsonProperty("sdfs")
    public void setSdfs(String  sdfs){
        this.sdfs = sdfs ;
        this.sdfsDirtyFlag = true ;
    }

    /**
     * 获取 [送达方式]脏标记
     */
    @JsonIgnore
    public boolean getSdfsDirtyFlag(){
        return this.sdfsDirtyFlag ;
    }

    /**
     * 获取 [跨公司部门人员清单]
     */
    @JsonProperty("kgsbmids")
    public String getKgsbmids(){
        return this.kgsbmids ;
    }

    /**
     * 设置 [跨公司部门人员清单]
     */
    @JsonProperty("kgsbmids")
    public void setKgsbmids(String  kgsbmids){
        this.kgsbmids = kgsbmids ;
        this.kgsbmidsDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司部门人员清单]脏标记
     */
    @JsonIgnore
    public boolean getKgsbmidsDirtyFlag(){
        return this.kgsbmidsDirtyFlag ;
    }

    /**
     * 获取 [上级部门]
     */
    @JsonProperty("sjbm")
    public Integer getSjbm(){
        return this.sjbm ;
    }

    /**
     * 设置 [上级部门]
     */
    @JsonProperty("sjbm")
    public void setSjbm(Integer  sjbm){
        this.sjbm = sjbm ;
        this.sjbmDirtyFlag = true ;
    }

    /**
     * 获取 [上级部门]脏标记
     */
    @JsonIgnore
    public boolean getSjbmDirtyFlag(){
        return this.sjbmDirtyFlag ;
    }

    /**
     * 获取 [其他通知阅读对象]
     */
    @JsonProperty("qttzyddx")
    public String getQttzyddx(){
        return this.qttzyddx ;
    }

    /**
     * 设置 [其他通知阅读对象]
     */
    @JsonProperty("qttzyddx")
    public void setQttzyddx(String  qttzyddx){
        this.qttzyddx = qttzyddx ;
        this.qttzyddxDirtyFlag = true ;
    }

    /**
     * 获取 [其他通知阅读对象]脏标记
     */
    @JsonIgnore
    public boolean getQttzyddxDirtyFlag(){
        return this.qttzyddxDirtyFlag ;
    }

    /**
     * 获取 [领导]
     */
    @JsonProperty("ld")
    public String getLd(){
        return this.ld ;
    }

    /**
     * 设置 [领导]
     */
    @JsonProperty("ld")
    public void setLd(String  ld){
        this.ld = ld ;
        this.ldDirtyFlag = true ;
    }

    /**
     * 获取 [领导]脏标记
     */
    @JsonIgnore
    public boolean getLdDirtyFlag(){
        return this.ldDirtyFlag ;
    }

    /**
     * 获取 [标题]
     */
    @JsonProperty("imname")
    public String getIMName(){
        return this.iMName ;
    }

    /**
     * 设置 [标题]
     */
    @JsonProperty("imname")
    public void setIMName(String  iMName){
        this.iMName = iMName ;
        this.iMNameDirtyFlag = true ;
    }

    /**
     * 获取 [标题]脏标记
     */
    @JsonIgnore
    public boolean getIMNameDirtyFlag(){
        return this.iMNameDirtyFlag ;
    }

    /**
     * 获取 [流程编号]
     */
    @JsonProperty("lcbh")
    public String getLcbh(){
        return this.lcbh ;
    }

    /**
     * 设置 [流程编号]
     */
    @JsonProperty("lcbh")
    public void setLcbh(String  lcbh){
        this.lcbh = lcbh ;
        this.lcbhDirtyFlag = true ;
    }

    /**
     * 获取 [流程编号]脏标记
     */
    @JsonIgnore
    public boolean getLcbhDirtyFlag(){
        return this.lcbhDirtyFlag ;
    }

    /**
     * 获取 [内部审核人员清单]
     */
    @JsonProperty("ngshids")
    public String getNgshids(){
        return this.ngshids ;
    }

    /**
     * 设置 [内部审核人员清单]
     */
    @JsonProperty("ngshids")
    public void setNgshids(String  ngshids){
        this.ngshids = ngshids ;
        this.ngshidsDirtyFlag = true ;
    }

    /**
     * 获取 [内部审核人员清单]脏标记
     */
    @JsonIgnore
    public boolean getNgshidsDirtyFlag(){
        return this.ngshidsDirtyFlag ;
    }

    /**
     * 获取 [跨公司领导]
     */
    @JsonProperty("kgsld")
    public String getKgsld(){
        return this.kgsld ;
    }

    /**
     * 设置 [跨公司领导]
     */
    @JsonProperty("kgsld")
    public void setKgsld(String  kgsld){
        this.kgsld = kgsld ;
        this.kgsldDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司领导]脏标记
     */
    @JsonIgnore
    public boolean getKgsldDirtyFlag(){
        return this.kgsldDirtyFlag ;
    }

    /**
     * 获取 [审核方式]
     */
    @JsonProperty("shfs")
    public String getShfs(){
        return this.shfs ;
    }

    /**
     * 设置 [审核方式]
     */
    @JsonProperty("shfs")
    public void setShfs(String  shfs){
        this.shfs = shfs ;
        this.shfsDirtyFlag = true ;
    }

    /**
     * 获取 [审核方式]脏标记
     */
    @JsonIgnore
    public boolean getShfsDirtyFlag(){
        return this.shfsDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [重要事项标识]
     */
    @JsonProperty("imid")
    public String getIMId(){
        return this.iMId ;
    }

    /**
     * 设置 [重要事项标识]
     */
    @JsonProperty("imid")
    public void setIMId(String  iMId){
        this.iMId = iMId ;
        this.iMIdDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项标识]脏标记
     */
    @JsonIgnore
    public boolean getIMIdDirtyFlag(){
        return this.iMIdDirtyFlag ;
    }

    /**
     * 获取 [申报类型]
     */
    @JsonProperty("sblx")
    public String getSblx(){
        return this.sblx ;
    }

    /**
     * 设置 [申报类型]
     */
    @JsonProperty("sblx")
    public void setSblx(String  sblx){
        this.sblx = sblx ;
        this.sblxDirtyFlag = true ;
    }

    /**
     * 获取 [申报类型]脏标记
     */
    @JsonIgnore
    public boolean getSblxDirtyFlag(){
        return this.sblxDirtyFlag ;
    }

    /**
     * 获取 [通知阅读]
     */
    @JsonProperty("tzyd")
    public Integer getTzyd(){
        return this.tzyd ;
    }

    /**
     * 设置 [通知阅读]
     */
    @JsonProperty("tzyd")
    public void setTzyd(Integer  tzyd){
        this.tzyd = tzyd ;
        this.tzydDirtyFlag = true ;
    }

    /**
     * 获取 [通知阅读]脏标记
     */
    @JsonIgnore
    public boolean getTzydDirtyFlag(){
        return this.tzydDirtyFlag ;
    }

    /**
     * 获取 [流程实例]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [流程实例]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [流程实例]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [部门领导]
     */
    @JsonProperty("bmld")
    public String getBmld(){
        return this.bmld ;
    }

    /**
     * 设置 [部门领导]
     */
    @JsonProperty("bmld")
    public void setBmld(String  bmld){
        this.bmld = bmld ;
        this.bmldDirtyFlag = true ;
    }

    /**
     * 获取 [部门领导]脏标记
     */
    @JsonIgnore
    public boolean getBmldDirtyFlag(){
        return this.bmldDirtyFlag ;
    }

    /**
     * 获取 [通知阅读原因]
     */
    @JsonProperty("tzydyy")
    public String getTzydyy(){
        return this.tzydyy ;
    }

    /**
     * 设置 [通知阅读原因]
     */
    @JsonProperty("tzydyy")
    public void setTzydyy(String  tzydyy){
        this.tzydyy = tzydyy ;
        this.tzydyyDirtyFlag = true ;
    }

    /**
     * 获取 [通知阅读原因]脏标记
     */
    @JsonIgnore
    public boolean getTzydyyDirtyFlag(){
        return this.tzydyyDirtyFlag ;
    }

    /**
     * 获取 [工作流状态]
     */
    @JsonProperty("imwfstate")
    public String getImwfstate(){
        return this.imwfstate ;
    }

    /**
     * 设置 [工作流状态]
     */
    @JsonProperty("imwfstate")
    public void setImwfstate(String  imwfstate){
        this.imwfstate = imwfstate ;
        this.imwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [工作流状态]脏标记
     */
    @JsonIgnore
    public boolean getImwfstateDirtyFlag(){
        return this.imwfstateDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [阅知对象]
     */
    @JsonProperty("yzdx")
    public String getYzdx(){
        return this.yzdx ;
    }

    /**
     * 设置 [阅知对象]
     */
    @JsonProperty("yzdx")
    public void setYzdx(String  yzdx){
        this.yzdx = yzdx ;
        this.yzdxDirtyFlag = true ;
    }

    /**
     * 获取 [阅知对象]脏标记
     */
    @JsonIgnore
    public boolean getYzdxDirtyFlag(){
        return this.yzdxDirtyFlag ;
    }

    /**
     * 获取 [内部审核]
     */
    @JsonProperty("ngsh")
    public String getNgsh(){
        return this.ngsh ;
    }

    /**
     * 设置 [内部审核]
     */
    @JsonProperty("ngsh")
    public void setNgsh(String  ngsh){
        this.ngsh = ngsh ;
        this.ngshDirtyFlag = true ;
    }

    /**
     * 获取 [内部审核]脏标记
     */
    @JsonIgnore
    public boolean getNgshDirtyFlag(){
        return this.ngshDirtyFlag ;
    }

    /**
     * 获取 [缓急程度]
     */
    @JsonProperty("hjcd")
    public String getHjcd(){
        return this.hjcd ;
    }

    /**
     * 设置 [缓急程度]
     */
    @JsonProperty("hjcd")
    public void setHjcd(String  hjcd){
        this.hjcd = hjcd ;
        this.hjcdDirtyFlag = true ;
    }

    /**
     * 获取 [缓急程度]脏标记
     */
    @JsonIgnore
    public boolean getHjcdDirtyFlag(){
        return this.hjcdDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [领导人员清单]
     */
    @JsonProperty("ldids")
    public String getLdids(){
        return this.ldids ;
    }

    /**
     * 设置 [领导人员清单]
     */
    @JsonProperty("ldids")
    public void setLdids(String  ldids){
        this.ldids = ldids ;
        this.ldidsDirtyFlag = true ;
    }

    /**
     * 获取 [领导人员清单]脏标记
     */
    @JsonIgnore
    public boolean getLdidsDirtyFlag(){
        return this.ldidsDirtyFlag ;
    }

    /**
     * 获取 [会签部门人员清单]
     */
    @JsonProperty("hqbmids")
    public String getHqbmids(){
        return this.hqbmids ;
    }

    /**
     * 设置 [会签部门人员清单]
     */
    @JsonProperty("hqbmids")
    public void setHqbmids(String  hqbmids){
        this.hqbmids = hqbmids ;
        this.hqbmidsDirtyFlag = true ;
    }

    /**
     * 获取 [会签部门人员清单]脏标记
     */
    @JsonIgnore
    public boolean getHqbmidsDirtyFlag(){
        return this.hqbmidsDirtyFlag ;
    }

    /**
     * 获取 [跨公司部门]
     */
    @JsonProperty("kgsbm")
    public String getKgsbm(){
        return this.kgsbm ;
    }

    /**
     * 设置 [跨公司部门]
     */
    @JsonProperty("kgsbm")
    public void setKgsbm(String  kgsbm){
        this.kgsbm = kgsbm ;
        this.kgsbmDirtyFlag = true ;
    }

    /**
     * 获取 [跨公司部门]脏标记
     */
    @JsonIgnore
    public boolean getKgsbmDirtyFlag(){
        return this.kgsbmDirtyFlag ;
    }

    /**
     * 获取 [重要事项审批步骤]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [重要事项审批步骤]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项审批步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }

    /**
     * 获取 [主办部门]
     */
    @JsonProperty("zbbm")
    public String getZbbm(){
        return this.zbbm ;
    }

    /**
     * 设置 [主办部门]
     */
    @JsonProperty("zbbm")
    public void setZbbm(String  zbbm){
        this.zbbm = zbbm ;
        this.zbbmDirtyFlag = true ;
    }

    /**
     * 获取 [主办部门]脏标记
     */
    @JsonIgnore
    public boolean getZbbmDirtyFlag(){
        return this.zbbmDirtyFlag ;
    }

    /**
     * 获取 [拟稿日期]
     */
    @JsonProperty("ngrq")
    public Timestamp getNgrq(){
        return this.ngrq ;
    }

    /**
     * 设置 [拟稿日期]
     */
    @JsonProperty("ngrq")
    public void setNgrq(Timestamp  ngrq){
        this.ngrq = ngrq ;
        this.ngrqDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿日期]脏标记
     */
    @JsonIgnore
    public boolean getNgrqDirtyFlag(){
        return this.ngrqDirtyFlag ;
    }

    /**
     * 获取 [拟稿人联系方式]
     */
    @JsonProperty("ngrlxfs")
    public String getNgrlxfs(){
        return this.ngrlxfs ;
    }

    /**
     * 设置 [拟稿人联系方式]
     */
    @JsonProperty("ngrlxfs")
    public void setNgrlxfs(String  ngrlxfs){
        this.ngrlxfs = ngrlxfs ;
        this.ngrlxfsDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人联系方式]脏标记
     */
    @JsonIgnore
    public boolean getNgrlxfsDirtyFlag(){
        return this.ngrlxfsDirtyFlag ;
    }

    /**
     * 获取 [拟稿人所在机构]
     */
    @JsonProperty("ngrjg")
    public String getNgrjg(){
        return this.ngrjg ;
    }

    /**
     * 设置 [拟稿人所在机构]
     */
    @JsonProperty("ngrjg")
    public void setNgrjg(String  ngrjg){
        this.ngrjg = ngrjg ;
        this.ngrjgDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人所在机构]脏标记
     */
    @JsonIgnore
    public boolean getNgrjgDirtyFlag(){
        return this.ngrjgDirtyFlag ;
    }

    /**
     * 获取 [拟稿人所在部门]
     */
    @JsonProperty("ngrbmname")
    public String getNgrbmname(){
        return this.ngrbmname ;
    }

    /**
     * 设置 [拟稿人所在部门]
     */
    @JsonProperty("ngrbmname")
    public void setNgrbmname(String  ngrbmname){
        this.ngrbmname = ngrbmname ;
        this.ngrbmnameDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人所在部门]脏标记
     */
    @JsonIgnore
    public boolean getNgrbmnameDirtyFlag(){
        return this.ngrbmnameDirtyFlag ;
    }

    /**
     * 获取 [拟稿人]
     */
    @JsonProperty("ngrname")
    public String getNgrname(){
        return this.ngrname ;
    }

    /**
     * 设置 [拟稿人]
     */
    @JsonProperty("ngrname")
    public void setNgrname(String  ngrname){
        this.ngrname = ngrname ;
        this.ngrnameDirtyFlag = true ;
    }

    /**
     * 获取 [拟稿人]脏标记
     */
    @JsonIgnore
    public boolean getNgrnameDirtyFlag(){
        return this.ngrnameDirtyFlag ;
    }

    /**
     * 获取 [组织用户标识]
     */
    @JsonProperty("ngrid")
    public String getNgrid(){
        return this.ngrid ;
    }

    /**
     * 设置 [组织用户标识]
     */
    @JsonProperty("ngrid")
    public void setNgrid(String  ngrid){
        this.ngrid = ngrid ;
        this.ngridDirtyFlag = true ;
    }

    /**
     * 获取 [组织用户标识]脏标记
     */
    @JsonIgnore
    public boolean getNgridDirtyFlag(){
        return this.ngridDirtyFlag ;
    }

    /**
     * 获取 [部门标识]
     */
    @JsonProperty("ngrbmid")
    public String getNgrbmid(){
        return this.ngrbmid ;
    }

    /**
     * 设置 [部门标识]
     */
    @JsonProperty("ngrbmid")
    public void setNgrbmid(String  ngrbmid){
        this.ngrbmid = ngrbmid ;
        this.ngrbmidDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getNgrbmidDirtyFlag(){
        return this.ngrbmidDirtyFlag ;
    }

    /**
     * 获取 [PSID]
     */
    @JsonProperty("psid")
    public String getPsid(){
        return this.psid ;
    }

    /**
     * 设置 [PSID]
     */
    @JsonProperty("psid")
    public void setPsid(String  psid){
        this.psid = psid ;
        this.psidDirtyFlag = true ;
    }

    /**
     * 获取 [PSID]脏标记
     */
    @JsonIgnore
    public boolean getPsidDirtyFlag(){
        return this.psidDirtyFlag ;
    }

    /**
     * 获取 [REST]
     */
    @JsonProperty("rest")
    public String getRest(){
        return this.rest ;
    }

    /**
     * 设置 [REST]
     */
    @JsonProperty("rest")
    public void setRest(String  rest){
        this.rest = rest ;
        this.restDirtyFlag = true ;
    }

    /**
     * 获取 [REST]脏标记
     */
    @JsonIgnore
    public boolean getRestDirtyFlag(){
        return this.restDirtyFlag ;
    }



}
