package com.ibiz.wfweb.htwf.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[WFBM]
 */
public class WFBM implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 部门流程状态
     */
    private String bmwfstate;

    @JsonIgnore
    private boolean bmwfstateDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * PROXYDATAID
     */
    private String proxydataid;

    @JsonIgnore
    private boolean proxydataidDirtyFlag;
    
    /**
     * PROXYMODULEID
     */
    private String proxymoduleid;

    @JsonIgnore
    private boolean proxymoduleidDirtyFlag;
    
    /**
     * 工作流实例
     */
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * WFBM标识
     */
    private String wFBMId;

    @JsonIgnore
    private boolean wFBMIdDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 工作流状态
     */
    private Integer wfstate;

    @JsonIgnore
    private boolean wfstateDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * WFBM名称
     */
    private String wFBMName;

    @JsonIgnore
    private boolean wFBMNameDirtyFlag;
    
    /**
     * 工作流步骤
     */
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;
    

    /**
     * 获取 [部门流程状态]
     */
    @JsonProperty("bmwfstate")
    public String getBmwfstate(){
        return this.bmwfstate ;
    }

    /**
     * 设置 [部门流程状态]
     */
    @JsonProperty("bmwfstate")
    public void setBmwfstate(String  bmwfstate){
        this.bmwfstate = bmwfstate ;
        this.bmwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [部门流程状态]脏标记
     */
    @JsonIgnore
    public boolean getBmwfstateDirtyFlag(){
        return this.bmwfstateDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public String getProxydataid(){
        return this.proxydataid ;
    }

    /**
     * 设置 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public void setProxydataid(String  proxydataid){
        this.proxydataid = proxydataid ;
        this.proxydataidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYDATAID]脏标记
     */
    @JsonIgnore
    public boolean getProxydataidDirtyFlag(){
        return this.proxydataidDirtyFlag ;
    }

    /**
     * 获取 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public String getProxymoduleid(){
        return this.proxymoduleid ;
    }

    /**
     * 设置 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public void setProxymoduleid(String  proxymoduleid){
        this.proxymoduleid = proxymoduleid ;
        this.proxymoduleidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    public boolean getProxymoduleidDirtyFlag(){
        return this.proxymoduleidDirtyFlag ;
    }

    /**
     * 获取 [工作流实例]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [工作流实例]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [工作流实例]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [WFBM标识]
     */
    @JsonProperty("wfbmid")
    public String getWFBMId(){
        return this.wFBMId ;
    }

    /**
     * 设置 [WFBM标识]
     */
    @JsonProperty("wfbmid")
    public void setWFBMId(String  wFBMId){
        this.wFBMId = wFBMId ;
        this.wFBMIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFBM标识]脏标记
     */
    @JsonIgnore
    public boolean getWFBMIdDirtyFlag(){
        return this.wFBMIdDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [工作流状态]
     */
    @JsonProperty("wfstate")
    public Integer getWfstate(){
        return this.wfstate ;
    }

    /**
     * 设置 [工作流状态]
     */
    @JsonProperty("wfstate")
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.wfstateDirtyFlag = true ;
    }

    /**
     * 获取 [工作流状态]脏标记
     */
    @JsonIgnore
    public boolean getWfstateDirtyFlag(){
        return this.wfstateDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [WFBM名称]
     */
    @JsonProperty("wfbmname")
    public String getWFBMName(){
        return this.wFBMName ;
    }

    /**
     * 设置 [WFBM名称]
     */
    @JsonProperty("wfbmname")
    public void setWFBMName(String  wFBMName){
        this.wFBMName = wFBMName ;
        this.wFBMNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFBM名称]脏标记
     */
    @JsonIgnore
    public boolean getWFBMNameDirtyFlag(){
        return this.wFBMNameDirtyFlag ;
    }

    /**
     * 获取 [工作流步骤]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [工作流步骤]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }



}
