package com.ibiz.wfweb.ht.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.ht.domain.IM;
import com.ibiz.wfweb.ht.filter.*;


public interface IMFeignClient {



	@RequestMapping(method = RequestMethod.PUT, value = "/web/ims/{im_id}")
    public IM update(@PathVariable("im_id") String im_id, @RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/{im_id}/hd")
    public IM hD(@PathVariable("im_id") String im_id, @RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/ims/{im_id}/getdraft")
    public IM getDraft(@PathVariable("im_id") String im_id, @RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ims")
    public IM create(@RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/ims/{im_id}")
    public Boolean remove(@PathVariable("im_id") String im_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/{im_id}/save")
    public IM save(@PathVariable("im_id") String im_id, @RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/ims/{im_id}")
    public IM get(@PathVariable("im_id") String im_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/checkkey")
    public Boolean checkKey(@RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/ims/{im_id}/getmp")
    public IM getMP(@PathVariable("im_id") String im_id, @RequestBody IM im) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/{im_id}/createandstart")
    public IM createAndStart(@PathVariable("im_id") String im_id, @RequestBody IM im) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/ims/fetchdefault")
	public Page<IM> fetchDefault(IMSearchContext searchContext) ;
}
