package com.ibiz.web.r7rt_org.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.web.r7rt_org.service.OrgUserService;
import com.ibiz.web.r7rt_org.domain.OrgUser;
import com.ibiz.web.r7rt_org.filter.*;

@RestController
@RequestMapping(value = "")
public class OrgUserController {
	@Autowired
    OrgUserService orguserservice;


	@RequestMapping(method = RequestMethod.DELETE, value = "/orgusers/{orguser_id}")
    @PreAuthorize("@orguser_pms.check(#orguser_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("orguser_id") String orguser_id) {
        boolean b = orguserservice.remove( orguser_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/orgusers/{orguser_id}/save")
    @PreAuthorize("@orguser_pms.check(#orguser_id,'')")
    public ResponseEntity<OrgUser> save(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUser orguser) {
        OrgUser orguser2 = orguserservice.save(orguser_id, orguser);
        return ResponseEntity.status(HttpStatus.OK).body(orguser2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/orgusers/{orguser_id}")
    @PreAuthorize("@orguser_pms.check(#orguser_id,'UPDATE')")
    public ResponseEntity<OrgUser> update(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUser orguser) {
        OrgUser orguser2 = orguserservice.update(orguser_id, orguser);
        return ResponseEntity.status(HttpStatus.OK).body(orguser2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/orgusers/{orguser_id}")
    @PreAuthorize("@orguser_pms.check(#orguser_id,'UPDATE')")
    public ResponseEntity<OrgUser> api_update(@PathVariable("orguser_id") String orguser_id, @RequestBody OrgUser orguser) {
        OrgUser orguser2 = orguserservice.update(orguser_id, orguser);
        return ResponseEntity.status(HttpStatus.OK).body(orguser2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/orgusers/checkkey")
    @PreAuthorize("@orguser_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgUser orguser) {
        boolean b = orguserservice.checkKey(orguser);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/orgusers/getdraft")
    @PreAuthorize("@orguser_pms.check('CREATE')")
    public ResponseEntity<OrgUser> getDraft() {
        //OrgUser orguser = orguserservice.getDraft( orguser_id);
        return ResponseEntity.status(HttpStatus.OK).body(new OrgUser());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/orgusers")
    @PreAuthorize("@orguser_pms.check('CREATE')")
    public ResponseEntity<OrgUser> create(@RequestBody OrgUser orguser) {
        OrgUser orguser2 = orguserservice.create(orguser);
        return ResponseEntity.status(HttpStatus.OK).body(orguser2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/orgusers/{orguser_id}")
    @PreAuthorize("@orguser_pms.check(#orguser_id,'READ')")
    public ResponseEntity<OrgUser> get(@PathVariable("orguser_id") String orguser_id) {
        OrgUser orguser = orguserservice.get( orguser_id);
        return ResponseEntity.status(HttpStatus.OK).body(orguser);
    }

    @RequestMapping(method= RequestMethod.GET , value="/orgusers/fetchdefault")
    @PreAuthorize("@orguser_pms.check('READ')")
	public ResponseEntity<List<OrgUser>> fetchDefault(OrgUserSearchContext searchContext,Pageable pageable) {
        
        Page<OrgUser> page = orguserservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


}
