package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.htwf.valuerule.anno.wfim.*;
import com.ibiz.core.htwf.domain.WFIM;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[WFIMDTO]
 */
public class WFIMDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @WFIMCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [WFSTEP]
     *
     */
    @WFIMWfstepDefault(info = "默认规则")
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;

    /**
     * 属性 [PROXYDATAID]
     *
     */
    @WFIMProxydataidDefault(info = "默认规则")
    private String proxydataid;

    @JsonIgnore
    private boolean proxydataidDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @WFIMUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [WFIMNAME]
     *
     */
    @WFIMWFIMNameDefault(info = "默认规则")
    private String wFIMName;

    @JsonIgnore
    private boolean wFIMNameDirtyFlag;

    /**
     * 属性 [WFIMID]
     *
     */
    @WFIMWFIMIdDefault(info = "默认规则")
    private String wFIMId;

    @JsonIgnore
    private boolean wFIMIdDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @WFIMCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [WFSTATE]
     *
     */
    @WFIMWfstateDefault(info = "默认规则")
    private Integer wfstate;

    @JsonIgnore
    private boolean wfstateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @WFIMUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [STATE]
     *
     */
    @WFIMStateDefault(info = "默认规则")
    private String state;

    @JsonIgnore
    private boolean stateDirtyFlag;

    /**
     * 属性 [PROXYMODULEID]
     *
     */
    @WFIMProxymoduleidDefault(info = "默认规则")
    private String proxymoduleid;

    @JsonIgnore
    private boolean proxymoduleidDirtyFlag;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @WFIMWfinstanceidDefault(info = "默认规则")
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;


    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return wfstep ;
    }

    /**
     * 设置 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEP]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return wfstepDirtyFlag ;
    }

    /**
     * 获取 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public String getProxydataid(){
        return proxydataid ;
    }

    /**
     * 设置 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public void setProxydataid(String  proxydataid){
        this.proxydataid = proxydataid ;
        this.proxydataidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYDATAID]脏标记
     */
    @JsonIgnore
    public boolean getProxydataidDirtyFlag(){
        return proxydataidDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [WFIMNAME]
     */
    @JsonProperty("wfimname")
    public String getWFIMName(){
        return wFIMName ;
    }

    /**
     * 设置 [WFIMNAME]
     */
    @JsonProperty("wfimname")
    public void setWFIMName(String  wFIMName){
        this.wFIMName = wFIMName ;
        this.wFIMNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFIMNAME]脏标记
     */
    @JsonIgnore
    public boolean getWFIMNameDirtyFlag(){
        return wFIMNameDirtyFlag ;
    }

    /**
     * 获取 [WFIMID]
     */
    @JsonProperty("wfimid")
    public String getWFIMId(){
        return wFIMId ;
    }

    /**
     * 设置 [WFIMID]
     */
    @JsonProperty("wfimid")
    public void setWFIMId(String  wFIMId){
        this.wFIMId = wFIMId ;
        this.wFIMIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFIMID]脏标记
     */
    @JsonIgnore
    public boolean getWFIMIdDirtyFlag(){
        return wFIMIdDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [WFSTATE]
     */
    @JsonProperty("wfstate")
    public Integer getWfstate(){
        return wfstate ;
    }

    /**
     * 设置 [WFSTATE]
     */
    @JsonProperty("wfstate")
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.wfstateDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getWfstateDirtyFlag(){
        return wfstateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [STATE]
     */
    @JsonProperty("state")
    public String getState(){
        return state ;
    }

    /**
     * 设置 [STATE]
     */
    @JsonProperty("state")
    public void setState(String  state){
        this.state = state ;
        this.stateDirtyFlag = true ;
    }

    /**
     * 获取 [STATE]脏标记
     */
    @JsonIgnore
    public boolean getStateDirtyFlag(){
        return stateDirtyFlag ;
    }

    /**
     * 获取 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public String getProxymoduleid(){
        return proxymoduleid ;
    }

    /**
     * 设置 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public void setProxymoduleid(String  proxymoduleid){
        this.proxymoduleid = proxymoduleid ;
        this.proxymoduleidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    public boolean getProxymoduleidDirtyFlag(){
        return proxymoduleidDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return wfinstanceidDirtyFlag ;
    }



    public WFIM toDO() {
        WFIM srfdomain = new WFIM();
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getWfstepDirtyFlag())
            srfdomain.setWfstep(wfstep);
        if(getProxydataidDirtyFlag())
            srfdomain.setProxydataid(proxydataid);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getWFIMNameDirtyFlag())
            srfdomain.setWFIMName(wFIMName);
        if(getWFIMIdDirtyFlag())
            srfdomain.setWFIMId(wFIMId);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getWfstateDirtyFlag())
            srfdomain.setWfstate(wfstate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getStateDirtyFlag())
            srfdomain.setState(state);
        if(getProxymoduleidDirtyFlag())
            srfdomain.setProxymoduleid(proxymoduleid);
        if(getWfinstanceidDirtyFlag())
            srfdomain.setWfinstanceid(wfinstanceid);

        return srfdomain;
    }

    public void fromDO(WFIM srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getWfstepDirtyFlag())
            this.setWfstep(srfdomain.getWfstep());
        if(srfdomain.getProxydataidDirtyFlag())
            this.setProxydataid(srfdomain.getProxydataid());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getWFIMNameDirtyFlag())
            this.setWFIMName(srfdomain.getWFIMName());
        if(srfdomain.getWFIMIdDirtyFlag())
            this.setWFIMId(srfdomain.getWFIMId());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getWfstateDirtyFlag())
            this.setWfstate(srfdomain.getWfstate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getStateDirtyFlag())
            this.setState(srfdomain.getState());
        if(srfdomain.getProxymoduleidDirtyFlag())
            this.setProxymoduleid(srfdomain.getProxymoduleid());
        if(srfdomain.getWfinstanceidDirtyFlag())
            this.setWfinstanceid(srfdomain.getWfinstanceid());

    }

    public List<WFIMDTO> fromDOPage(List<WFIM> poPage)   {
        if(poPage == null)
            return null;
        List<WFIMDTO> dtos=new ArrayList<WFIMDTO>();
        for(WFIM domain : poPage) {
            WFIMDTO dto = new WFIMDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

