package com.ibiz.mybatis.htwf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.WFBMRepository;
import com.ibiz.core.repository.po.WFBM;
import com.ibiz.core.htwf.filter.WFBMSearchContext;
import com.ibiz.mybatis.htwf.mapper.T_WFBMMapper;
import com.ibiz.mybatis.htwf.po.T_WFBMImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_WFBM]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "wfbm", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_WFBMRepositoryImpl extends ServiceImpl<T_WFBMMapper, T_WFBMImpl> implements WFBMRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_WFBM]持久层映射对象
     */
    @Autowired
	T_WFBMMapper t_WFBMMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public WFBM createPO(){
        return new T_WFBMImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public WFBM get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(WFBM po){
        boolean bOk = this.save((T_WFBMImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(WFBM po){
        boolean bOk = this.updateById((T_WFBMImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<WFBM> searchDefault(WFBMSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<WFBM> page_datas=t_WFBMMapper.searchDefault(page,context,qw);
        List<WFBM> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<WFBM>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.htwf.domain.WFBM convert2Domain( WFBM po ,com.ibiz.core.htwf.domain.WFBM domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.htwf.domain.WFBM();
        }
        //if(po.getBmwfstateDirtyFlag())
        domain.setBmwfstate(po.getBmwfstate());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getProxydataidDirtyFlag())
        domain.setProxydataid(po.getProxydataid());
        //if(po.getProxymoduleidDirtyFlag())
        domain.setProxymoduleid(po.getProxymoduleid());
        //if(po.getWfinstanceidDirtyFlag())
        domain.setWfinstanceid(po.getWfinstanceid());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getWFBMIdDirtyFlag())
        domain.setWFBMId(po.getWFBMId());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getWfstateDirtyFlag())
        domain.setWfstate(po.getWfstate());
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getWFBMNameDirtyFlag())
        domain.setWFBMName(po.getWFBMName());
        //if(po.getWfstepDirtyFlag())
        domain.setWfstep(po.getWfstep());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public WFBM convert2PO(com.ibiz.core.htwf.domain.WFBM domain , WFBM po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getBmwfstateDirtyFlag())
            po.setBmwfstate(domain.getBmwfstate());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getProxydataidDirtyFlag())
            po.setProxydataid(domain.getProxydataid());
        if(domain.getProxymoduleidDirtyFlag())
            po.setProxymoduleid(domain.getProxymoduleid());
        if(domain.getWfinstanceidDirtyFlag())
            po.setWfinstanceid(domain.getWfinstanceid());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getWFBMIdDirtyFlag())
            po.setWFBMId(domain.getWFBMId());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getWfstateDirtyFlag())
            po.setWfstate(domain.getWfstate());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getWFBMNameDirtyFlag())
            po.setWFBMName(domain.getWFBMName());
        if(domain.getWfstepDirtyFlag())
            po.setWfstep(domain.getWfstep());

        return po ;
    }
}
