package com.ibiz.mybatis.htwf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.WFASRepository;
import com.ibiz.core.repository.po.WFAS;
import com.ibiz.core.htwf.filter.WFASSearchContext;
import com.ibiz.mybatis.htwf.mapper.T_WFASMapper;
import com.ibiz.mybatis.htwf.po.T_WFASImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_WFAS]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "wfas", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_WFASRepositoryImpl extends ServiceImpl<T_WFASMapper, T_WFASImpl> implements WFASRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_WFAS]持久层映射对象
     */
    @Autowired
	T_WFASMapper t_WFASMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public WFAS createPO(){
        return new T_WFASImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public WFAS get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(WFAS po){
        boolean bOk = this.save((T_WFASImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(WFAS po){
        boolean bOk = this.updateById((T_WFASImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<WFAS> searchDefault(WFASSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<WFAS> page_datas=t_WFASMapper.searchDefault(page,context,qw);
        List<WFAS> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<WFAS>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.htwf.domain.WFAS convert2Domain( WFAS po ,com.ibiz.core.htwf.domain.WFAS domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.htwf.domain.WFAS();
        }
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getProxydataidDirtyFlag())
        domain.setProxydataid(po.getProxydataid());
        //if(po.getWfstateDirtyFlag())
        domain.setWfstate(po.getWfstate());
        //if(po.getWFASNameDirtyFlag())
        domain.setWFASName(po.getWFASName());
        //if(po.getWFASIdDirtyFlag())
        domain.setWFASId(po.getWFASId());
        //if(po.getProxymoduleidDirtyFlag())
        domain.setProxymoduleid(po.getProxymoduleid());
        //if(po.getAswfstateDirtyFlag())
        domain.setAswfstate(po.getAswfstate());
        //if(po.getWfstepDirtyFlag())
        domain.setWfstep(po.getWfstep());
        //if(po.getWfinstanceidDirtyFlag())
        domain.setWfinstanceid(po.getWfinstanceid());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public WFAS convert2PO(com.ibiz.core.htwf.domain.WFAS domain , WFAS po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getProxydataidDirtyFlag())
            po.setProxydataid(domain.getProxydataid());
        if(domain.getWfstateDirtyFlag())
            po.setWfstate(domain.getWfstate());
        if(domain.getWFASNameDirtyFlag())
            po.setWFASName(domain.getWFASName());
        if(domain.getWFASIdDirtyFlag())
            po.setWFASId(domain.getWFASId());
        if(domain.getProxymoduleidDirtyFlag())
            po.setProxymoduleid(domain.getProxymoduleid());
        if(domain.getAswfstateDirtyFlag())
            po.setAswfstate(domain.getAswfstate());
        if(domain.getWfstepDirtyFlag())
            po.setWfstep(domain.getWfstep());
        if(domain.getWfinstanceidDirtyFlag())
            po.setWfinstanceid(domain.getWfinstanceid());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());

        return po ;
    }
}
