package com.ibiz.mybatis.htwf.po;

import com.ibiz.core.repository.po.WFBM;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.ibiz.util.annotation.PreField;
import com.ibiz.util.enums.FillMode;
import com.ibiz.util.enums.PredefinedType;

/**
 * 关系型数据实体表[WFBM] 对象
 */
@TableName(value = "T_WFBM",resultMap = "T_WFBMResultMap")
public class T_WFBMImpl implements WFBM,Serializable {

    /**
     * [部门流程状态]
     */
    private String bmwfstate;
    /**
     * [部门流程状态]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bmwfstateDirtyFlag;

    /**
     * [建立时间]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    private Timestamp createDate;
    /**
     * [建立时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createDateDirtyFlag;

    /**
     * [PROXYDATAID]
     */
    private String proxydataid;
    /**
     * [PROXYDATAID]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean proxydataidDirtyFlag;

    /**
     * [PROXYMODULEID]
     */
    private String proxymoduleid;
    /**
     * [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean proxymoduleidDirtyFlag;

    /**
     * [工作流实例]
     */
    private String wfinstanceid;
    /**
     * [工作流实例]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfinstanceidDirtyFlag;

    /**
     * [建立人]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    private String createMan;
    /**
     * [建立人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createManDirtyFlag;

    /**
     * [WFBM标识]
     */
    @TableId(value= "wfbmid",type=IdType.UUID)
    private String wFBMId;
    /**
     * [WFBM标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wFBMIdDirtyFlag;

    /**
     * [更新人]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    private String updateMan;
    /**
     * [更新人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateManDirtyFlag;

    /**
     * [工作流状态]
     */
    private Integer wfstate;
    /**
     * [工作流状态]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfstateDirtyFlag;

    /**
     * [更新时间]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    private Timestamp updateDate;
    /**
     * [更新时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateDateDirtyFlag;

    /**
     * [WFBM名称]
     */
    private String wFBMName;
    /**
     * [WFBM名称]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wFBMNameDirtyFlag;

    /**
     * [工作流步骤]
     */
    private String wfstep;
    /**
     * [工作流步骤]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfstepDirtyFlag;

    /**
     * 获取 [部门流程状态]
     */
    public String getBmwfstate(){
        return this.bmwfstate ;
    }

    /**
     * 设置 [部门流程状态]
     */
    public void setBmwfstate(String  bmwfstate){
        this.bmwfstate = bmwfstate ;
        this.bmwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [部门流程状态]脏标记
     */
    @JsonIgnore
    public boolean getBmwfstateDirtyFlag(){
        return this.bmwfstateDirtyFlag ;
    }
    /**
     * 获取 [建立时间]
     */
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }
    /**
     * 获取 [PROXYDATAID]
     */
    public String getProxydataid(){
        return this.proxydataid ;
    }

    /**
     * 设置 [PROXYDATAID]
     */
    public void setProxydataid(String  proxydataid){
        this.proxydataid = proxydataid ;
        this.proxydataidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYDATAID]脏标记
     */
    @JsonIgnore
    public boolean getProxydataidDirtyFlag(){
        return this.proxydataidDirtyFlag ;
    }
    /**
     * 获取 [PROXYMODULEID]
     */
    public String getProxymoduleid(){
        return this.proxymoduleid ;
    }

    /**
     * 设置 [PROXYMODULEID]
     */
    public void setProxymoduleid(String  proxymoduleid){
        this.proxymoduleid = proxymoduleid ;
        this.proxymoduleidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    public boolean getProxymoduleidDirtyFlag(){
        return this.proxymoduleidDirtyFlag ;
    }
    /**
     * 获取 [工作流实例]
     */
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [工作流实例]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }
    /**
     * 获取 [建立人]
     */
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }
    /**
     * 获取 [WFBM标识]
     */
    public String getWFBMId(){
        return this.wFBMId ;
    }

    /**
     * 设置 [WFBM标识]
     */
    public void setWFBMId(String  wFBMId){
        this.wFBMId = wFBMId ;
        this.wFBMIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFBM标识]脏标记
     */
    @JsonIgnore
    public boolean getWFBMIdDirtyFlag(){
        return this.wFBMIdDirtyFlag ;
    }
    /**
     * 获取 [更新人]
     */
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }
    /**
     * 获取 [工作流状态]
     */
    public Integer getWfstate(){
        return this.wfstate ;
    }

    /**
     * 设置 [工作流状态]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.wfstateDirtyFlag = true ;
    }

    /**
     * 获取 [工作流状态]脏标记
     */
    @JsonIgnore
    public boolean getWfstateDirtyFlag(){
        return this.wfstateDirtyFlag ;
    }
    /**
     * 获取 [更新时间]
     */
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }
    /**
     * 获取 [WFBM名称]
     */
    public String getWFBMName(){
        return this.wFBMName ;
    }

    /**
     * 设置 [WFBM名称]
     */
    public void setWFBMName(String  wFBMName){
        this.wFBMName = wFBMName ;
        this.wFBMNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFBM名称]脏标记
     */
    @JsonIgnore
    public boolean getWFBMNameDirtyFlag(){
        return this.wFBMNameDirtyFlag ;
    }
    /**
     * 获取 [工作流步骤]
     */
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }
}