package com.ibiz.mybatis.ht;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.FJRepository;
import com.ibiz.core.repository.po.FJ;
import com.ibiz.core.ht.filter.FJSearchContext;
import com.ibiz.mybatis.ht.mapper.T_FJMapper;
import com.ibiz.mybatis.ht.po.T_FJImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_FJ]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "fj", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_FJRepositoryImpl extends ServiceImpl<T_FJMapper, T_FJImpl> implements FJRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_FJ]持久层映射对象
     */
    @Autowired
	T_FJMapper t_FJMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public FJ createPO(){
        return new T_FJImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public FJ get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(FJ po){
        boolean bOk = this.save((T_FJImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(FJ po){
        boolean bOk = this.updateById((T_FJImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[CurFJ]
     * @param context 查询上下文对象
     * @return
     */
    public Page<FJ> searchCurFJ(FJSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<FJ> page_datas=t_FJMapper.searchCurFJ(page,context,qw);
        List<FJ> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<FJ>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<FJ> searchDefault(FJSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<FJ> page_datas=t_FJMapper.searchDefault(page,context,qw);
        List<FJ> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<FJ>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.ht.domain.FJ convert2Domain( FJ po ,com.ibiz.core.ht.domain.FJ domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.ht.domain.FJ();
        }
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getFJIdDirtyFlag())
        domain.setFJId(po.getFJId());
        //if(po.getDjidDirtyFlag())
        domain.setDjid(po.getDjid());
        //if(po.getZtDirtyFlag())
        domain.setZt(po.getZt());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getXhDirtyFlag())
        domain.setXh(po.getXh());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getFJNameDirtyFlag())
        domain.setFJName(po.getFJName());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public FJ convert2PO(com.ibiz.core.ht.domain.FJ domain , FJ po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getFJIdDirtyFlag())
            po.setFJId(domain.getFJId());
        if(domain.getDjidDirtyFlag())
            po.setDjid(domain.getDjid());
        if(domain.getZtDirtyFlag())
            po.setZt(domain.getZt());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getXhDirtyFlag())
            po.setXh(domain.getXh());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getFJNameDirtyFlag())
            po.setFJName(domain.getFJName());

        return po ;
    }
}
