package com.ibiz.wfweb.htwf.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[WFBC]
 */
public class WFBC implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 工作流状态
     */
    private Integer wfstate;

    @JsonIgnore
    private boolean wfstateDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 工作流步骤
     */
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;
    
    /**
     * 流程状态
     */
    private String state;

    @JsonIgnore
    private boolean stateDirtyFlag;
    
    /**
     * PROXYDATAID
     */
    private String proxydataid;

    @JsonIgnore
    private boolean proxydataidDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * WFBC名称
     */
    private String wFBCName;

    @JsonIgnore
    private boolean wFBCNameDirtyFlag;
    
    /**
     * PROXYMODULEID
     */
    private String proxymoduleid;

    @JsonIgnore
    private boolean proxymoduleidDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * WFBC标识
     */
    private String wFBCId;

    @JsonIgnore
    private boolean wFBCIdDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 工作流实例
     */
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;
    

    /**
     * 获取 [工作流状态]
     */
    @JsonProperty("wfstate")
    public Integer getWfstate(){
        return this.wfstate ;
    }

    /**
     * 设置 [工作流状态]
     */
    @JsonProperty("wfstate")
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.wfstateDirtyFlag = true ;
    }

    /**
     * 获取 [工作流状态]脏标记
     */
    @JsonIgnore
    public boolean getWfstateDirtyFlag(){
        return this.wfstateDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [工作流步骤]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [工作流步骤]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }

    /**
     * 获取 [流程状态]
     */
    @JsonProperty("state")
    public String getState(){
        return this.state ;
    }

    /**
     * 设置 [流程状态]
     */
    @JsonProperty("state")
    public void setState(String  state){
        this.state = state ;
        this.stateDirtyFlag = true ;
    }

    /**
     * 获取 [流程状态]脏标记
     */
    @JsonIgnore
    public boolean getStateDirtyFlag(){
        return this.stateDirtyFlag ;
    }

    /**
     * 获取 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public String getProxydataid(){
        return this.proxydataid ;
    }

    /**
     * 设置 [PROXYDATAID]
     */
    @JsonProperty("proxydataid")
    public void setProxydataid(String  proxydataid){
        this.proxydataid = proxydataid ;
        this.proxydataidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYDATAID]脏标记
     */
    @JsonIgnore
    public boolean getProxydataidDirtyFlag(){
        return this.proxydataidDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [WFBC名称]
     */
    @JsonProperty("wfbcname")
    public String getWFBCName(){
        return this.wFBCName ;
    }

    /**
     * 设置 [WFBC名称]
     */
    @JsonProperty("wfbcname")
    public void setWFBCName(String  wFBCName){
        this.wFBCName = wFBCName ;
        this.wFBCNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFBC名称]脏标记
     */
    @JsonIgnore
    public boolean getWFBCNameDirtyFlag(){
        return this.wFBCNameDirtyFlag ;
    }

    /**
     * 获取 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public String getProxymoduleid(){
        return this.proxymoduleid ;
    }

    /**
     * 设置 [PROXYMODULEID]
     */
    @JsonProperty("proxymoduleid")
    public void setProxymoduleid(String  proxymoduleid){
        this.proxymoduleid = proxymoduleid ;
        this.proxymoduleidDirtyFlag = true ;
    }

    /**
     * 获取 [PROXYMODULEID]脏标记
     */
    @JsonIgnore
    public boolean getProxymoduleidDirtyFlag(){
        return this.proxymoduleidDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [WFBC标识]
     */
    @JsonProperty("wfbcid")
    public String getWFBCId(){
        return this.wFBCId ;
    }

    /**
     * 设置 [WFBC标识]
     */
    @JsonProperty("wfbcid")
    public void setWFBCId(String  wFBCId){
        this.wFBCId = wFBCId ;
        this.wFBCIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFBC标识]脏标记
     */
    @JsonIgnore
    public boolean getWFBCIdDirtyFlag(){
        return this.wFBCIdDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [工作流实例]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [工作流实例]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [工作流实例]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }



}
