package com.ibiz.mybatis.ht.po;

import com.ibiz.core.repository.po.FJ;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.ibiz.util.annotation.PreField;
import com.ibiz.util.enums.FillMode;
import com.ibiz.util.enums.PredefinedType;

/**
 * 关系型数据实体表[FJ] 对象
 */
@TableName(value = "T_FJ",resultMap = "T_FJResultMap")
public class T_FJImpl implements FJ,Serializable {

    /**
     * [更新时间]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    private Timestamp updateDate;
    /**
     * [更新时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateDateDirtyFlag;

    /**
     * [建立人]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    private String createMan;
    /**
     * [建立人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createManDirtyFlag;

    /**
     * [附件标识]
     */
    @TableId(value= "fjid",type=IdType.UUID)
    private String fJId;
    /**
     * [附件标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean fJIdDirtyFlag;

    /**
     * [DJID]
     */
    private String djid;
    /**
     * [DJID]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean djidDirtyFlag;

    /**
     * [状态]
     */
    private String zt;
    /**
     * [状态]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean ztDirtyFlag;

    /**
     * [建立时间]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    private Timestamp createDate;
    /**
     * [建立时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createDateDirtyFlag;

    /**
     * [序号]
     */
    private Integer xh;
    /**
     * [序号]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean xhDirtyFlag;

    /**
     * [更新人]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    private String updateMan;
    /**
     * [更新人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateManDirtyFlag;

    /**
     * [附件名称]
     */
    private String fJName;
    /**
     * [附件名称]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean fJNameDirtyFlag;

    /**
     * 获取 [更新时间]
     */
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }
    /**
     * 获取 [建立人]
     */
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }
    /**
     * 获取 [附件标识]
     */
    public String getFJId(){
        return this.fJId ;
    }

    /**
     * 设置 [附件标识]
     */
    public void setFJId(String  fJId){
        this.fJId = fJId ;
        this.fJIdDirtyFlag = true ;
    }

    /**
     * 获取 [附件标识]脏标记
     */
    @JsonIgnore
    public boolean getFJIdDirtyFlag(){
        return this.fJIdDirtyFlag ;
    }
    /**
     * 获取 [DJID]
     */
    public String getDjid(){
        return this.djid ;
    }

    /**
     * 设置 [DJID]
     */
    public void setDjid(String  djid){
        this.djid = djid ;
        this.djidDirtyFlag = true ;
    }

    /**
     * 获取 [DJID]脏标记
     */
    @JsonIgnore
    public boolean getDjidDirtyFlag(){
        return this.djidDirtyFlag ;
    }
    /**
     * 获取 [状态]
     */
    public String getZt(){
        return this.zt ;
    }

    /**
     * 设置 [状态]
     */
    public void setZt(String  zt){
        this.zt = zt ;
        this.ztDirtyFlag = true ;
    }

    /**
     * 获取 [状态]脏标记
     */
    @JsonIgnore
    public boolean getZtDirtyFlag(){
        return this.ztDirtyFlag ;
    }
    /**
     * 获取 [建立时间]
     */
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }
    /**
     * 获取 [序号]
     */
    public Integer getXh(){
        return this.xh ;
    }

    /**
     * 设置 [序号]
     */
    public void setXh(Integer  xh){
        this.xh = xh ;
        this.xhDirtyFlag = true ;
    }

    /**
     * 获取 [序号]脏标记
     */
    @JsonIgnore
    public boolean getXhDirtyFlag(){
        return this.xhDirtyFlag ;
    }
    /**
     * 获取 [更新人]
     */
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }
    /**
     * 获取 [附件名称]
     */
    public String getFJName(){
        return this.fJName ;
    }

    /**
     * 设置 [附件名称]
     */
    public void setFJName(String  fJName){
        this.fJName = fJName ;
        this.fJNameDirtyFlag = true ;
    }

    /**
     * 获取 [附件名称]脏标记
     */
    @JsonIgnore
    public boolean getFJNameDirtyFlag(){
        return this.fJNameDirtyFlag ;
    }
}