package com.ibiz.web.ht.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.web.ht.service.BCService;
import com.ibiz.web.ht.domain.BC;
import com.ibiz.web.ht.filter.*;

@RestController
@RequestMapping(value = "")
public class BCController {
	@Autowired
    BCService bcservice;


	@RequestMapping(method = RequestMethod.GET, value = "/bcs/{bc_id}")
    @PreAuthorize("@bc_pms.check(#bc_id,'READ')")
    public ResponseEntity<BC> get(@PathVariable("bc_id") String bc_id) {
        BC bc = bcservice.get( bc_id);
        return ResponseEntity.status(HttpStatus.OK).body(bc);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/bcs/getdraft")
    @PreAuthorize("@bc_pms.check('CREATE')")
    public ResponseEntity<BC> getDraft() {
        //BC bc = bcservice.getDraft( bc_id);
        return ResponseEntity.status(HttpStatus.OK).body(new BC());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/bcs")
    @PreAuthorize("@bc_pms.check('CREATE')")
    public ResponseEntity<BC> create(@RequestBody BC bc) {
        BC bc2 = bcservice.create(bc);
        return ResponseEntity.status(HttpStatus.OK).body(bc2);
    }

	@RequestMapping(method = RequestMethod.DELETE, value = "/bcs/{bc_id}")
    @PreAuthorize("@bc_pms.check(#bc_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("bc_id") String bc_id) {
        boolean b = bcservice.remove( bc_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/bcs/{bc_id}")
    @PreAuthorize("@bc_pms.check(#bc_id,'UPDATE')")
    public ResponseEntity<BC> update(@PathVariable("bc_id") String bc_id, @RequestBody BC bc) {
        BC bc2 = bcservice.update(bc_id, bc);
        return ResponseEntity.status(HttpStatus.OK).body(bc2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/bcs/{bc_id}")
    @PreAuthorize("@bc_pms.check(#bc_id,'UPDATE')")
    public ResponseEntity<BC> api_update(@PathVariable("bc_id") String bc_id, @RequestBody BC bc) {
        BC bc2 = bcservice.update(bc_id, bc);
        return ResponseEntity.status(HttpStatus.OK).body(bc2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/bcs/checkkey")
    @PreAuthorize("@bc_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody BC bc) {
        boolean b = bcservice.checkKey(bc);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/bcs/{bc_id}/save")
    @PreAuthorize("@bc_pms.check(#bc_id,'')")
    public ResponseEntity<BC> save(@PathVariable("bc_id") String bc_id, @RequestBody BC bc) {
        BC bc2 = bcservice.save(bc_id, bc);
        return ResponseEntity.status(HttpStatus.OK).body(bc2);
    }

    @RequestMapping(method= RequestMethod.GET , value="/bcs/fetchdefault")
    @PreAuthorize("@bc_pms.check('READ')")
	public ResponseEntity<List<BC>> fetchDefault(BCSearchContext searchContext,Pageable pageable) {
        
        Page<BC> page = bcservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    @RequestMapping(method= RequestMethod.POST , value="/bcs/{bc_id}/wfstart")
	public ResponseEntity<JSONObject> wfStart(@PathVariable("bc_id") String bc_id) {
        return ResponseEntity.status(HttpStatus.OK).body(bcservice.wfStart(bc_id));
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    @RequestMapping(method = RequestMethod.POST, value = "api/bcs/{bc_id}/wfaction")
    public ResponseEntity<JSONObject> wfAction(@PathVariable("bc_id") String bc_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(bcservice.wfAction(bc_id, data));
    }

}
