package com.ibiz.util.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.ibiz.util.log.LogMessage.*;

public class LoggerUtil {
    public static ThreadLocal<Long> startSet = new ThreadLocal<>();

    /**
     * 打印日志：开始方法（业务调用）
     *
     * @param params 调用原方法入参
     */
    public static void startLog(Object... params) {
        String loggerName = getClassName();
        Logger log = LoggerFactory.getLogger(loggerName);
        log.info(LogMessage.Function_Start, loggerName);
        log.debug(LogMessage.Params, getStr(params));
        startSet.set(System.currentTimeMillis());
    }

    /**
     * 打印日志：结束方法（业务调用）
     *
     * @param params 调用工具类的原方法返回值。
     */
    public static void endLog(Object... params) {
        Long start = startSet.get();
        String loggerName = getClassName();
        Logger log = LoggerFactory.getLogger(loggerName);
        log.info(Function_End, loggerName);
        log.debug(ReturnedValue, getStr(params));

        if (start != null) {
            startSet.remove();
            log.debug(TimeCost, System.currentTimeMillis() - start);
        }
    }

    public static void error(String msg) {
        LoggerFactory.getLogger(getClassName()).error(msg);
    }

    public static void error(String msg, Object... obj) {
        LoggerFactory.getLogger(getClassName()).error(msg, obj);
    }

    public static void warn(String msg) {
        LoggerFactory.getLogger(getClassName()).error(msg);
    }

    public static void warn(String msg, Object... obj) {
        LoggerFactory.getLogger(getClassName()).error(msg, obj);
    }

    public static void info(String msg) {
        LoggerFactory.getLogger(getClassName()).info(msg);
    }

    public static void info(String msg, Object... obj) {
        LoggerFactory.getLogger(getClassName()).info(msg, obj);
    }

    public static void debug(String msg) {
        LoggerFactory.getLogger(getClassName()).debug(msg);
    }

    public static void debug(String msg, Object... obj) {
        LoggerFactory.getLogger(getClassName()).debug(msg, obj);
    }

    /**
     * 获取调用 LoggerUtil工具静态类的类名
     *
     * @return 长类名.方法名(行数)
     * ps: 获取【行数】影响性能，生产环境中不建议打印行数。
     */
    private static String getClassName() {
        StackTraceElement element = Thread.currentThread().getStackTrace()[3];
        //从程序栈中获取定位信息
        String className = element.getClassName();
        String methodName = element.getMethodName();
        int lineNum = element.getLineNumber();
//        return className + "." + methodName;
        return String.format("%s.%s(%s)",className ,methodName,lineNum);
    }

}