package com.ibiz.wfweb.security.cas;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.ibiz.util.security.userdetail.LoginUser;
import com.ibiz.wfweb.security.userdetail.LoginUserDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
 
/**
 * 用于加载用户信息 实现UserDetailsService接口，或者实现AuthenticationUserDetailsService接口
 */
public class CasUserDetailsService implements AuthenticationUserDetailsService<CasAssertionAuthenticationToken> {

	@Autowired
	UserDetailsService userDetailsService ;

    @Override
    public UserDetails loadUserDetails(CasAssertionAuthenticationToken token) throws UsernameNotFoundException {
		//获取用户信息
		UserDetails userDetails = userDetailsService.loadUserByUsername(token.getName()) ;
		return userDetails;
    }
 
}