package com.ibiz.wfweb.htwf.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.htwf.domain.WFBC;
import com.ibiz.wfweb.htwf.filter.*;


public interface WFBCFeignClient {



	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfbcs/{wfbc_id}")
    public Boolean remove(@PathVariable("wfbc_id") String wfbc_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbcs")
    public WFBC create(@RequestBody WFBC wfbc) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbcs/{wfbc_id}")
    public WFBC get(@PathVariable("wfbc_id") String wfbc_id) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbcs/{wfbc_id}/save")
    public WFBC save(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBC wfbc) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbcs/checkkey")
    public Boolean checkKey(@RequestBody WFBC wfbc) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbcs/{wfbc_id}/getdraft")
    public WFBC getDraft(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBC wfbc) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfbcs/{wfbc_id}")
    public WFBC update(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBC wfbc) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfbcs/fetchdefault")
	public Page<WFBC> fetchDefault(WFBCSearchContext searchContext) ;
}
