package com.ibiz.wfweb.ht.service;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb.ht.domain.FJ;
import com.ibiz.wfweb.ht.filter.*;
import com.ibiz.wfweb.ht.feign.FJFeignClient;
import com.ibiz.wfweb.WFWebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class FJService {

    FJFeignClient client;

    @Autowired
    public FJService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(FJFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(FJFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public FJ save(String fj_id, FJ fj) {
        return client.save(fj_id, fj);
    }

	public FJ create(FJ fj) {
        return client.create(fj);
    }

    public FJ update(String fj_id, FJ fj) {
        return client.update(fj_id, fj);
    }

    public boolean remove( String fj_id) {
        return client.remove( fj_id);
    }

    public FJ get( String fj_id) {
        return client.get( fj_id);
    }

    public FJ getDraft(String fj_id, FJ fj) {
        return client.getDraft(fj_id, fj);
    }

    public boolean checkKey(FJ fj) {
        return client.checkKey(fj);
    }

	public Page<FJ> fetchCurFJ(FJSearchContext searchContext) {
        return client.fetchCurFJ(searchContext);
    }

	public Page<FJ> fetchDefault(FJSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
