package com.ibiz.client.ps.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.ibiz.core.client.model.IPS;
import com.ibiz.client.ps.config.psClientProperties;
import com.ibiz.core.client.service.IPSClientService;
import com.ibiz.client.ps.model.PSImpl;
import com.ibiz.client.ps.feign.PSFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[PS] 服务对象接口
 */
@Service
public class PSClientServiceImpl implements IPSClientService {

    PSFeignClient pSFeignClient;

    @Autowired
    public PSClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,psClientProperties psClientProperties) {
        if (psClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.pSFeignClient = nameBuilder.target(PSFeignClient.class,"http://"+psClientProperties.getServiceId()+"/") ;
		}else if (psClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.pSFeignClient = nameBuilder.target(PSFeignClient.class,psClientProperties.getServiceUrl()) ;
		}
    }
    @Override
    public IPS createModel() {
		return new PSImpl();
	}


    public Page<IPS> select(SearchContext context){
        return null ;
    }


    public void get(IPS ps){
        IPS clientModel = pSFeignClient.get(ps.getPSId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), ps.getClass(), false);
        copier.copy(clientModel, ps, null);
    }


    public void update(IPS ps){
        IPS clientModel = pSFeignClient.update(ps.getPSId(),(PSImpl)ps) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), ps.getClass(), false);
        copier.copy(clientModel, ps, null);
    }


    public void create(IPS ps){
        IPS clientModel = pSFeignClient.create((PSImpl)ps) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), ps.getClass(), false);
        copier.copy(clientModel, ps, null);
    }


    public void save(IPS ps){
        IPS clientModel = pSFeignClient.save(ps.getPSId(),(PSImpl)ps) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), ps.getClass(), false);
        copier.copy(clientModel, ps, null);
    }


    public void getDraft(IPS ps){
        IPS clientModel = pSFeignClient.getDraft(ps.getPSId(),(PSImpl)ps) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), ps.getClass(), false);
        copier.copy(clientModel, ps, null);
    }


    public void checkKey(IPS ps){
        IPS clientModel = pSFeignClient.checkKey(ps.getPSId(),(PSImpl)ps) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), ps.getClass(), false);
        copier.copy(clientModel, ps, null);
    }


    public void remove(IPS ps){
        pSFeignClient.remove(ps.getPSId()) ;
    }


    public Page<IPS> fetchDefault(SearchContext context){
        Page<PSImpl> page = this.pSFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }



}

