package com.ibiz.job;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;

import java.util.List;
import java.util.ArrayList;

import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.domain.*;

/**
 *
 */
@Component
public class WFJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 注册统一工作流（域注册）
        registDomain();

        // 注册工作流引擎
        registWFEngine();

        // 注册业务系统（部署系统）
        registSystem();

        // 注册工作流角色
        registWFRole();

        // 注册业务工作流
        registPSWorkflow();

        // 注册业务实体
        registPSDE();

        // 注册业务实体工作流
        registPSDEWF();

        // 注册业务工作流模式
        registWFMode();
    }

    /**
     * 注册统一工作流（域注册）
     */
    private void registDomain() {
        Workflow workflow = new Workflow();
        workflow.setWorkflowid(sysInfoProperties.getDomainid());
        workflow.setWorkflowname(sysInfoProperties.getDomainname());
        workflow.setLogicname(sysInfoProperties.getDomainlogicname());
        uniWFFeignClient.registDomain(workflow);
    }

    /**
     * 注册工作流引擎
     */
    private void registWFEngine() {
        List<WFEngine> wfengines = new ArrayList<WFEngine>();
        WFEngine wfengine1 = new WFEngine();
        wfengine1.setWfengineid("ACTIVITI");
        wfengine1.setWfenginename("ACTIVITI");
        wfengine1.setWfenginetype("ACTIVITI");
        wfengine1.setLogicname("ACTIVITI");
        wfengine1.setWorkflowid(sysInfoProperties.getDomainid());
        wfengines.add(wfengine1);
        uniWFFeignClient.registWFEngine(wfengines);
    }

    /**
     * 注册业务系统（部署系统）
     */
    private void registSystem() {
        PSSystem pssystem = new PSSystem();
        pssystem.setPssystemid(sysInfoProperties.getSystemid());
        pssystem.setPssystemname(sysInfoProperties.getSystemname());
        pssystem.setWorkflowid(sysInfoProperties.getDomainid());
        pssystem.setServiceid(sysInfoProperties.getServiceid());
        pssystem.setServiceurl(sysInfoProperties.getServiceurl());
        pssystem.setLogicname(sysInfoProperties.getSystemlogicname());
        pssystem.setOrgid(sysInfoProperties.getSysorgid());
        pssystem.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pssystem.setRootpath(sysInfoProperties.getWfrootpath());
        uniWFFeignClient.registPSSystem(pssystem);
    }

    /**
     * 注册工作流角色
     */
    private void registWFRole() {
        List<PSWFRole> pswfroles = new ArrayList<PSWFRole>();
        PSWFRole pswfrole0 = new PSWFRole();
        pswfrole0.setPswfroleid("5d0b93fa52d3ab0d048652b80b67cb6e");
        pswfrole0.setPswfrolename("当前部门");
        pswfrole0.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole0.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole0.setWfroletype("ORGSECTOR");
        pswfroles.add(pswfrole0);
        PSWFRole pswfrole1 = new PSWFRole();
        pswfrole1.setPswfroleid("c24e4bdc1b87ba82187623202a70a603");
        pswfrole1.setPswfrolename("分送人");
        pswfrole1.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole1.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole1.setWfroletype("ORGUSERGROUP");
        pswfroles.add(pswfrole1);
        PSWFRole pswfrole2 = new PSWFRole();
        pswfrole2.setPswfroleid("e6a1cd0b20573e4e7c3185a0307e6740");
        pswfrole2.setPswfrolename("部门员工");
        pswfrole2.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole2.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole2.setWfroletype("ORGSECTORUSERGROUP");
        pswfroles.add(pswfrole2);
        PSWFRole pswfrole3 = new PSWFRole();
        pswfrole3.setPswfroleid("b54aceeaef2df5de5492fe9f091b09b2");
        pswfrole3.setPswfrolename("首席风险官");
        pswfrole3.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole3.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole3.setWfroletype("ORGUSERGROUP");
        pswfroles.add(pswfrole3);
        PSWFRole pswfrole4 = new PSWFRole();
        pswfrole4.setPswfroleid("dab01cbe26008281ee3fd126d1bbe683");
        pswfrole4.setPswfrolename("部门管理员");
        pswfrole4.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole4.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole4.setWfroletype("ORGSECTORADMIN");
        pswfroles.add(pswfrole4);
        PSWFRole pswfrole5 = new PSWFRole();
        pswfrole5.setPswfroleid("23f6b7e0feacdccc687f4df9f2d00b3a");
        pswfrole5.setPswfrolename("部门领导");
        pswfrole5.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole5.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole5.setWfroletype("ORGSECTORUSERGROUP");
        pswfroles.add(pswfrole5);
        PSWFRole pswfrole6 = new PSWFRole();
        pswfrole6.setPswfroleid("431f4105523a30fbf66e1c6a40ce51cc");
        pswfrole6.setPswfrolename("合规总监");
        pswfrole6.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole6.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole6.setWfroletype("ORGUSERGROUP");
        pswfroles.add(pswfrole6);
        PSWFRole pswfrole7 = new PSWFRole();
        pswfrole7.setPswfroleid("af365d7d3bc8e5f87d20a05f625fb593");
        pswfrole7.setPswfrolename("当前父部门");
        pswfrole7.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole7.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole7.setWfroletype("PORGSECTOR");
        pswfroles.add(pswfrole7);
        PSWFRole pswfrole8 = new PSWFRole();
        pswfrole8.setPswfroleid("7edfc53017b3a276081368a3fa614fc3");
        pswfrole8.setPswfrolename("跨公司领导");
        pswfrole8.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole8.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole8.setWfroletype("ORGUSERGROUP");
        pswfroles.add(pswfrole8);
        PSWFRole pswfrole9 = new PSWFRole();
        pswfrole9.setPswfroleid("e5f4d85354010bbd3f50d2b61abdb8dc");
        pswfrole9.setPswfrolename("跨公司部门");
        pswfrole9.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole9.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole9.setWfroletype("ORGUSERGROUP");
        pswfroles.add(pswfrole9);
        PSWFRole pswfrole10 = new PSWFRole();
        pswfrole10.setPswfroleid("1f36236c2cf50704ca43e6a319979957");
        pswfrole10.setPswfrolename("组织管理员");
        pswfrole10.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole10.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole10.setWfroletype("ORGADMIN");
        pswfroles.add(pswfrole10);
        PSWFRole pswfrole11 = new PSWFRole();
        pswfrole11.setPswfroleid("89d81556c6a8f9d3896ea3f9dc21cd04");
        pswfrole11.setPswfrolename("当前组织");
        pswfrole11.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole11.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole11.setWfroletype("ORG");
        pswfroles.add(pswfrole11);
        PSWFRole pswfrole12 = new PSWFRole();
        pswfrole12.setPswfroleid("a8fc35d18f297b74cc2ff3c948833be0");
        pswfrole12.setPswfrolename("当前父组织");
        pswfrole12.setOrgid(sysInfoProperties.getSysorgid());
        pswfrole12.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfrole12.setWfroletype("PORG");
        pswfroles.add(pswfrole12);
        uniWFFeignClient.registPSWFRole(pswfroles);
    }

    /**
     * 注册业务工作流
     */
    private void registPSWorkflow() {
        List<PSWorkflow> psworkflows = new ArrayList<PSWorkflow>();
        PSWorkflow psworkflow0 = new PSWorkflow();
        psworkflow0.setPsworkflowid("7ba93f6994808554d57fd44f804ae8a2");
        psworkflow0.setPsworkflowname("部门内审核");
        psworkflow0.setLogicname("部门内审核");
        psworkflow0.setWorkflowid(sysInfoProperties.getDomainid());
        psworkflow0.setPssystemid(sysInfoProperties.getSystemid());
        psworkflow0.setWfenginetype("ACTIVITI");
        psworkflow0.setOrgid(sysInfoProperties.getSysorgid());
        psworkflow0.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        psworkflow0.setWftype("DEFAULT");
        psworkflows.add(psworkflow0);
        PSWorkflow psworkflow1 = new PSWorkflow();
        psworkflow1.setPsworkflowid("61ba4cc481bd586d0f352ff23f7f1ace");
        psworkflow1.setPsworkflowname("加签");
        psworkflow1.setLogicname("加签");
        psworkflow1.setWorkflowid(sysInfoProperties.getDomainid());
        psworkflow1.setPssystemid(sysInfoProperties.getSystemid());
        psworkflow1.setWfenginetype("ACTIVITI");
        psworkflow1.setOrgid(sysInfoProperties.getSysorgid());
        psworkflow1.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        psworkflow1.setWftype("DEFAULT");
        psworkflows.add(psworkflow1);
        PSWorkflow psworkflow2 = new PSWorkflow();
        psworkflow2.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        psworkflow2.setPsworkflowname("业务协作审批");
        psworkflow2.setLogicname("业务协作审批");
        psworkflow2.setWorkflowid(sysInfoProperties.getDomainid());
        psworkflow2.setPssystemid(sysInfoProperties.getSystemid());
        psworkflow2.setWfenginetype("ACTIVITI");
        psworkflow2.setOrgid(sysInfoProperties.getSysorgid());
        psworkflow2.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        psworkflow2.setWftype("DEFAULT");
        psworkflows.add(psworkflow2);
        PSWorkflow psworkflow3 = new PSWorkflow();
        psworkflow3.setPsworkflowid("49cfb692bde2ae6d258b26681452fb57");
        psworkflow3.setPsworkflowname("重要事项审批");
        psworkflow3.setLogicname("重要事项审批");
        psworkflow3.setWorkflowid(sysInfoProperties.getDomainid());
        psworkflow3.setPssystemid(sysInfoProperties.getSystemid());
        psworkflow3.setWfenginetype("ACTIVITI");
        psworkflow3.setOrgid(sysInfoProperties.getSysorgid());
        psworkflow3.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        psworkflow3.setWftype("DEFAULT");
        psworkflows.add(psworkflow3);
        uniWFFeignClient.registPSWorkflow(psworkflows);
    }

    /**
     * 注册业务实体
     */
    private void registPSDE() {
        List<PSDataEntity> psdataentities = new ArrayList<PSDataEntity>();
        PSDataEntity psdataentity0 = new PSDataEntity();
        psdataentity0.setPsdataentityid("fdcdc6bb1fa44eadd4c5515b28e59a96");
        psdataentity0.setPsdataentityname("WFBC");
        psdataentity0.setLogicname("业务协作");
        psdataentity0.setCodename("WFBC");
        psdataentity0.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity0.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity0);
        PSDataEntity psdataentity1 = new PSDataEntity();
        psdataentity1.setPsdataentityid("05e97b720c9d7501be3ee631c5337d23");
        psdataentity1.setPsdataentityname("WFAS");
        psdataentity1.setLogicname("加签");
        psdataentity1.setCodename("WFAS");
        psdataentity1.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity1.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity1);
        PSDataEntity psdataentity2 = new PSDataEntity();
        psdataentity2.setPsdataentityid("461f5d700bb76c4024802901a3be9231");
        psdataentity2.setPsdataentityname("WFBM");
        psdataentity2.setLogicname("重要事项");
        psdataentity2.setCodename("WFBM");
        psdataentity2.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity2.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity2);
        PSDataEntity psdataentity3 = new PSDataEntity();
        psdataentity3.setPsdataentityid("6ebc01c300b54d50486ccff26162752b");
        psdataentity3.setPsdataentityname("IM");
        psdataentity3.setLogicname("重要事项");
        psdataentity3.setCodename("IM");
        psdataentity3.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity3.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity3);
        PSDataEntity psdataentity4 = new PSDataEntity();
        psdataentity4.setPsdataentityid("c6568ad867530ddf86ef2996d73ede25");
        psdataentity4.setPsdataentityname("WFIM");
        psdataentity4.setLogicname("重要事项");
        psdataentity4.setCodename("WFIM");
        psdataentity4.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity4.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity4);
        PSDataEntity psdataentity5 = new PSDataEntity();
        psdataentity5.setPsdataentityid("d1a54da97f37e5d110b31724de3916ac");
        psdataentity5.setPsdataentityname("BC");
        psdataentity5.setLogicname("业务协作");
        psdataentity5.setCodename("BC");
        psdataentity5.setWorkflowid(sysInfoProperties.getDomainid());
        psdataentity5.setPssystemid(sysInfoProperties.getSystemid());
        psdataentities.add(psdataentity5);
        uniWFFeignClient.registPSDataEntity(psdataentities);
    }

    /**
     * 注册业务实体工作流
     */
    private void registPSDEWF() {
        List<PSDEWF> psdewfs = new ArrayList<PSDEWF>();
        PSDEWF psdewf0 = new PSDEWF();
        psdewf0.setPsdewfid("fbc3b332e4fcfe8d2cc51f82c136a8cc");
        psdewf0.setPsdewfname("WFBM");
        psdewf0.setLogicname("重要事项");
        psdewf0.setWfproxymode(2);
        psdewf0.setPsdataentityid("461f5d700bb76c4024802901a3be9231");
        psdewf0.setPsdecodename("WFBM");
        psdewf0.setPsworkflowid("7ba93f6994808554d57fd44f804ae8a2");
        psdewf0.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf0.setPssystemid(sysInfoProperties.getSystemid());
        psdewf0.setUdstatefield("bmwfstate");
        psdewf0.setWfstatefield("wfstate");
        psdewf0.setWfstepfield("wfstep");
        psdewf0.setErrorvalue("40");
        psdewf0.setFinishvalue("30");
        psdewf0.setProcessvalue("20");

        psdewfs.add(psdewf0);
        PSDEWF psdewf1 = new PSDEWF();
        psdewf1.setPsdewfid("d51523b21f120a92c819fcfb25c37c57");
        psdewf1.setPsdewfname("WFAS");
        psdewf1.setLogicname("加签");
        psdewf1.setWfproxymode(2);
        psdewf1.setPsdataentityid("05e97b720c9d7501be3ee631c5337d23");
        psdewf1.setPsdecodename("WFAS");
        psdewf1.setPsworkflowid("61ba4cc481bd586d0f352ff23f7f1ace");
        psdewf1.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf1.setPssystemid(sysInfoProperties.getSystemid());
        psdewf1.setUdstatefield("aswfstate");
        psdewf1.setWfstatefield("wfstate");
        psdewf1.setWfstepfield("wfstep");
        psdewf1.setErrorvalue("40");
        psdewf1.setFinishvalue("30");
        psdewf1.setProcessvalue("20");

        psdewfs.add(psdewf1);
        PSDEWF psdewf2 = new PSDEWF();
        psdewf2.setPsdewfid("87c62d755e0d9bbfdcad1052f87d585a");
        psdewf2.setPsdewfname("WFBC");
        psdewf2.setLogicname("业务协作");
        psdewf2.setWfproxymode(2);
        psdewf2.setPsdataentityid("fdcdc6bb1fa44eadd4c5515b28e59a96");
        psdewf2.setPsdecodename("WFBC");
        psdewf2.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        psdewf2.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf2.setPssystemid(sysInfoProperties.getSystemid());
        psdewf2.setUdstatefield("state");
        psdewf2.setWfstatefield("wfstate");
        psdewf2.setWfstepfield("wfstep");
        psdewf2.setErrorvalue("40");
        psdewf2.setFinishvalue("30");
        psdewf2.setProcessvalue("20");

        psdewfs.add(psdewf2);
        PSDEWF psdewf3 = new PSDEWF();
        psdewf3.setPsdewfid("c7c9a43340c252127a0c57e5b01f57fc");
        psdewf3.setPsdewfname("BC");
        psdewf3.setLogicname("业务协作");
        psdewf3.setWfproxymode(1);
        psdewf3.setPsdataentityid("d1a54da97f37e5d110b31724de3916ac");
        psdewf3.setPsdecodename("BC");
        psdewf3.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        psdewf3.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf3.setPssystemid(sysInfoProperties.getSystemid());
        psdewf3.setUdstatefield("bcwfstate");
        psdewf3.setErrorvalue("40");
        psdewf3.setFinishvalue("30");
        psdewf3.setProcessvalue("20");

        psdewfs.add(psdewf3);
        PSDEWF psdewf4 = new PSDEWF();
        psdewf4.setPsdewfid("8763b6ec5edfc7af57dc1891d52e05aa");
        psdewf4.setPsdewfname("IM");
        psdewf4.setLogicname("重要事项");
        psdewf4.setWfproxymode(1);
        psdewf4.setPsdataentityid("6ebc01c300b54d50486ccff26162752b");
        psdewf4.setPsdecodename("IM");
        psdewf4.setPsworkflowid("49cfb692bde2ae6d258b26681452fb57");
        psdewf4.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf4.setPssystemid(sysInfoProperties.getSystemid());
        psdewf4.setUdstatefield("imwfstate");
        psdewf4.setErrorvalue("40");
        psdewf4.setFinishvalue("30");
        psdewf4.setProcessvalue("20");

        psdewfs.add(psdewf4);
        PSDEWF psdewf5 = new PSDEWF();
        psdewf5.setPsdewfid("fdd1b47c60937014ad2fb9f99e3562a7");
        psdewf5.setPsdewfname("WFIM");
        psdewf5.setLogicname("重要事项");
        psdewf5.setWfproxymode(2);
        psdewf5.setPsdataentityid("c6568ad867530ddf86ef2996d73ede25");
        psdewf5.setPsdecodename("WFIM");
        psdewf5.setPsworkflowid("49cfb692bde2ae6d258b26681452fb57");
        psdewf5.setWorkflowid(sysInfoProperties.getDomainid());
        psdewf5.setPssystemid(sysInfoProperties.getSystemid());
        psdewf5.setUdstatefield("state");
        psdewf5.setWfstatefield("wfstate");
        psdewf5.setWfstepfield("wfstep");
        psdewf5.setErrorvalue("40");
        psdewf5.setFinishvalue("30");
        psdewf5.setProcessvalue("20");

        psdewfs.add(psdewf5);
        uniWFFeignClient.registPSDEWF(psdewfs);
    }

    /**
     * 注册业务工作流模式
     */
    private void registWFMode() {
    }
}
