package com.ibiz.mybatis.ht.po;

import com.ibiz.core.repository.po.SRFFILE;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.ibiz.util.annotation.PreField;
import com.ibiz.util.enums.FillMode;
import com.ibiz.util.enums.PredefinedType;

/**
 * 关系型数据实体表[SRFFILE] 对象
 */
@TableName(value = "T_SRFFILE",resultMap = "T_SRFFILEResultMap")
public class T_SRFFILEImpl implements SRFFILE,Serializable {

    /**
     * [文件路径]
     */
    private String filepath;
    /**
     * [文件路径]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean filepathDirtyFlag;

    /**
     * [更新人]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    private String updateMan;
    /**
     * [更新人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateManDirtyFlag;

    /**
     * [所属者]
     */
    private String ownerid;
    /**
     * [所属者]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean owneridDirtyFlag;

    /**
     * [摘要数据]
     */
    private String digestcode;
    /**
     * [摘要数据]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean digestcodeDirtyFlag;

    /**
     * [文件夹]
     */
    private String folder;
    /**
     * [文件夹]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean folderDirtyFlag;

    /**
     * [图片高度]
     */
    private Integer picheight;
    /**
     * [图片高度]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean picheightDirtyFlag;

    /**
     * [FILE名称]
     */
    private String sRFFILEName;
    /**
     * [FILE名称]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean sRFFILENameDirtyFlag;

    /**
     * [建立时间]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    private Timestamp createDate;
    /**
     * [建立时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createDateDirtyFlag;

    /**
     * [更新时间]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    private Timestamp updateDate;
    /**
     * [更新时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateDateDirtyFlag;

    /**
     * [图片宽度]
     */
    private Integer picwidth;
    /**
     * [图片宽度]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean picwidthDirtyFlag;

    /**
     * [FILE标识]
     */
    @TableId(value= "srffileid",type=IdType.UUID)
    private String sRFFILEId;
    /**
     * [FILE标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean sRFFILEIdDirtyFlag;

    /**
     * [建立人]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    private String createMan;
    /**
     * [建立人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createManDirtyFlag;

    /**
     * [文件类型]
     */
    private String fileext;
    /**
     * [文件类型]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean fileextDirtyFlag;

    /**
     * [文件大小]
     */
    private Integer filesize;
    /**
     * [文件大小]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean filesizeDirtyFlag;

    /**
     * 获取 [文件路径]
     */
    public String getFilepath(){
        return this.filepath ;
    }

    /**
     * 设置 [文件路径]
     */
    public void setFilepath(String  filepath){
        this.filepath = filepath ;
        this.filepathDirtyFlag = true ;
    }

    /**
     * 获取 [文件路径]脏标记
     */
    @JsonIgnore
    public boolean getFilepathDirtyFlag(){
        return this.filepathDirtyFlag ;
    }
    /**
     * 获取 [更新人]
     */
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }
    /**
     * 获取 [所属者]
     */
    public String getOwnerid(){
        return this.ownerid ;
    }

    /**
     * 设置 [所属者]
     */
    public void setOwnerid(String  ownerid){
        this.ownerid = ownerid ;
        this.owneridDirtyFlag = true ;
    }

    /**
     * 获取 [所属者]脏标记
     */
    @JsonIgnore
    public boolean getOwneridDirtyFlag(){
        return this.owneridDirtyFlag ;
    }
    /**
     * 获取 [摘要数据]
     */
    public String getDigestcode(){
        return this.digestcode ;
    }

    /**
     * 设置 [摘要数据]
     */
    public void setDigestcode(String  digestcode){
        this.digestcode = digestcode ;
        this.digestcodeDirtyFlag = true ;
    }

    /**
     * 获取 [摘要数据]脏标记
     */
    @JsonIgnore
    public boolean getDigestcodeDirtyFlag(){
        return this.digestcodeDirtyFlag ;
    }
    /**
     * 获取 [文件夹]
     */
    public String getFolder(){
        return this.folder ;
    }

    /**
     * 设置 [文件夹]
     */
    public void setFolder(String  folder){
        this.folder = folder ;
        this.folderDirtyFlag = true ;
    }

    /**
     * 获取 [文件夹]脏标记
     */
    @JsonIgnore
    public boolean getFolderDirtyFlag(){
        return this.folderDirtyFlag ;
    }
    /**
     * 获取 [图片高度]
     */
    public Integer getPicheight(){
        return this.picheight ;
    }

    /**
     * 设置 [图片高度]
     */
    public void setPicheight(Integer  picheight){
        this.picheight = picheight ;
        this.picheightDirtyFlag = true ;
    }

    /**
     * 获取 [图片高度]脏标记
     */
    @JsonIgnore
    public boolean getPicheightDirtyFlag(){
        return this.picheightDirtyFlag ;
    }
    /**
     * 获取 [FILE名称]
     */
    public String getSRFFILEName(){
        return this.sRFFILEName ;
    }

    /**
     * 设置 [FILE名称]
     */
    public void setSRFFILEName(String  sRFFILEName){
        this.sRFFILEName = sRFFILEName ;
        this.sRFFILENameDirtyFlag = true ;
    }

    /**
     * 获取 [FILE名称]脏标记
     */
    @JsonIgnore
    public boolean getSRFFILENameDirtyFlag(){
        return this.sRFFILENameDirtyFlag ;
    }
    /**
     * 获取 [建立时间]
     */
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }
    /**
     * 获取 [更新时间]
     */
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }
    /**
     * 获取 [图片宽度]
     */
    public Integer getPicwidth(){
        return this.picwidth ;
    }

    /**
     * 设置 [图片宽度]
     */
    public void setPicwidth(Integer  picwidth){
        this.picwidth = picwidth ;
        this.picwidthDirtyFlag = true ;
    }

    /**
     * 获取 [图片宽度]脏标记
     */
    @JsonIgnore
    public boolean getPicwidthDirtyFlag(){
        return this.picwidthDirtyFlag ;
    }
    /**
     * 获取 [FILE标识]
     */
    public String getSRFFILEId(){
        return this.sRFFILEId ;
    }

    /**
     * 设置 [FILE标识]
     */
    public void setSRFFILEId(String  sRFFILEId){
        this.sRFFILEId = sRFFILEId ;
        this.sRFFILEIdDirtyFlag = true ;
    }

    /**
     * 获取 [FILE标识]脏标记
     */
    @JsonIgnore
    public boolean getSRFFILEIdDirtyFlag(){
        return this.sRFFILEIdDirtyFlag ;
    }
    /**
     * 获取 [建立人]
     */
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }
    /**
     * 获取 [文件类型]
     */
    public String getFileext(){
        return this.fileext ;
    }

    /**
     * 设置 [文件类型]
     */
    public void setFileext(String  fileext){
        this.fileext = fileext ;
        this.fileextDirtyFlag = true ;
    }

    /**
     * 获取 [文件类型]脏标记
     */
    @JsonIgnore
    public boolean getFileextDirtyFlag(){
        return this.fileextDirtyFlag ;
    }
    /**
     * 获取 [文件大小]
     */
    public Integer getFilesize(){
        return this.filesize ;
    }

    /**
     * 设置 [文件大小]
     */
    public void setFilesize(Integer  filesize){
        this.filesize = filesize ;
        this.filesizeDirtyFlag = true ;
    }

    /**
     * 获取 [文件大小]脏标记
     */
    @JsonIgnore
    public boolean getFilesizeDirtyFlag(){
        return this.filesizeDirtyFlag ;
    }
}