package com.ibiz.mybatis.ht;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.SRFFILERepository;
import com.ibiz.core.repository.po.SRFFILE;
import com.ibiz.core.ht.filter.SRFFILESearchContext;
import com.ibiz.mybatis.ht.mapper.T_SRFFILEMapper;
import com.ibiz.mybatis.ht.po.T_SRFFILEImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_SRFFILE]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "srffile", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_SRFFILERepositoryImpl extends ServiceImpl<T_SRFFILEMapper, T_SRFFILEImpl> implements SRFFILERepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_SRFFILE]持久层映射对象
     */
    @Autowired
	T_SRFFILEMapper t_SRFFILEMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public SRFFILE createPO(){
        return new T_SRFFILEImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public SRFFILE get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(SRFFILE po){
        boolean bOk = this.save((T_SRFFILEImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(SRFFILE po){
        boolean bOk = this.updateById((T_SRFFILEImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<SRFFILE> searchDefault(SRFFILESearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SRFFILE> page_datas=t_SRFFILEMapper.searchDefault(page,context,qw);
        List<SRFFILE> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SRFFILE>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.ht.domain.SRFFILE convert2Domain( SRFFILE po ,com.ibiz.core.ht.domain.SRFFILE domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.ht.domain.SRFFILE();
        }
        //if(po.getFilepathDirtyFlag())
        domain.setFilepath(po.getFilepath());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getOwneridDirtyFlag())
        domain.setOwnerid(po.getOwnerid());
        //if(po.getDigestcodeDirtyFlag())
        domain.setDigestcode(po.getDigestcode());
        //if(po.getFolderDirtyFlag())
        domain.setFolder(po.getFolder());
        //if(po.getPicheightDirtyFlag())
        domain.setPicheight(po.getPicheight());
        //if(po.getSRFFILENameDirtyFlag())
        domain.setSRFFILEName(po.getSRFFILEName());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getPicwidthDirtyFlag())
        domain.setPicwidth(po.getPicwidth());
        //if(po.getSRFFILEIdDirtyFlag())
        domain.setSRFFILEId(po.getSRFFILEId());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getFileextDirtyFlag())
        domain.setFileext(po.getFileext());
        //if(po.getFilesizeDirtyFlag())
        domain.setFilesize(po.getFilesize());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public SRFFILE convert2PO(com.ibiz.core.ht.domain.SRFFILE domain , SRFFILE po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getFilepathDirtyFlag())
            po.setFilepath(domain.getFilepath());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getOwneridDirtyFlag())
            po.setOwnerid(domain.getOwnerid());
        if(domain.getDigestcodeDirtyFlag())
            po.setDigestcode(domain.getDigestcode());
        if(domain.getFolderDirtyFlag())
            po.setFolder(domain.getFolder());
        if(domain.getPicheightDirtyFlag())
            po.setPicheight(domain.getPicheight());
        if(domain.getSRFFILENameDirtyFlag())
            po.setSRFFILEName(domain.getSRFFILEName());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getPicwidthDirtyFlag())
            po.setPicwidth(domain.getPicwidth());
        if(domain.getSRFFILEIdDirtyFlag())
            po.setSRFFILEId(domain.getSRFFILEId());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getFileextDirtyFlag())
            po.setFileext(domain.getFileext());
        if(domain.getFilesizeDirtyFlag())
            po.setFilesize(domain.getFilesize());

        return po ;
    }
}
