package com.ibiz.mybatis.ht;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.IMRepository;
import com.ibiz.core.repository.po.IM;
import com.ibiz.core.ht.filter.IMSearchContext;
import com.ibiz.mybatis.ht.mapper.T_IMMapper;
import com.ibiz.mybatis.ht.po.T_IMImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_IM]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "im", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_IMRepositoryImpl extends ServiceImpl<T_IMMapper, T_IMImpl> implements IMRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_IM]持久层映射对象
     */
    @Autowired
	T_IMMapper t_IMMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public IM createPO(){
        return new T_IMImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public IM get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(IM po){
        boolean bOk = this.save((T_IMImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(IM po){
        boolean bOk = this.updateById((T_IMImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<IM> searchDefault(IMSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IM> page_datas=t_IMMapper.searchDefault(page,context,qw);
        List<IM> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<IM>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.ht.domain.IM convert2Domain( IM po ,com.ibiz.core.ht.domain.IM domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.ht.domain.IM();
        }
        //if(po.getKgsldidsDirtyFlag())
        domain.setKgsldids(po.getKgsldids());
        //if(po.getBzDirtyFlag())
        domain.setBz(po.getBz());
        //if(po.getSblbDirtyFlag())
        domain.setSblb(po.getSblb());
        //if(po.getBmldidsDirtyFlag())
        domain.setBmldids(po.getBmldids());
        //if(po.getJjyyDirtyFlag())
        domain.setJjyy(po.getJjyy());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getHqbmDirtyFlag())
        domain.setHqbm(po.getHqbm());
        //if(po.getSdfsDirtyFlag())
        domain.setSdfs(po.getSdfs());
        //if(po.getKgsbmidsDirtyFlag())
        domain.setKgsbmids(po.getKgsbmids());
        //if(po.getSjbmDirtyFlag())
        domain.setSjbm(po.getSjbm());
        //if(po.getQttzyddxDirtyFlag())
        domain.setQttzyddx(po.getQttzyddx());
        //if(po.getLdDirtyFlag())
        domain.setLd(po.getLd());
        //if(po.getIMNameDirtyFlag())
        domain.setIMName(po.getIMName());
        //if(po.getLcbhDirtyFlag())
        domain.setLcbh(po.getLcbh());
        //if(po.getNgshidsDirtyFlag())
        domain.setNgshids(po.getNgshids());
        //if(po.getKgsldDirtyFlag())
        domain.setKgsld(po.getKgsld());
        //if(po.getShfsDirtyFlag())
        domain.setShfs(po.getShfs());
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getIMIdDirtyFlag())
        domain.setIMId(po.getIMId());
        //if(po.getSblxDirtyFlag())
        domain.setSblx(po.getSblx());
        //if(po.getTzydDirtyFlag())
        domain.setTzyd(po.getTzyd());
        //if(po.getWfinstanceidDirtyFlag())
        domain.setWfinstanceid(po.getWfinstanceid());
        //if(po.getBmldDirtyFlag())
        domain.setBmld(po.getBmld());
        //if(po.getTzydyyDirtyFlag())
        domain.setTzydyy(po.getTzydyy());
        //if(po.getImwfstateDirtyFlag())
        domain.setImwfstate(po.getImwfstate());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getYzdxDirtyFlag())
        domain.setYzdx(po.getYzdx());
        //if(po.getNgshDirtyFlag())
        domain.setNgsh(po.getNgsh());
        //if(po.getHjcdDirtyFlag())
        domain.setHjcd(po.getHjcd());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getLdidsDirtyFlag())
        domain.setLdids(po.getLdids());
        //if(po.getHqbmidsDirtyFlag())
        domain.setHqbmids(po.getHqbmids());
        //if(po.getKgsbmDirtyFlag())
        domain.setKgsbm(po.getKgsbm());
        //if(po.getWfstepDirtyFlag())
        domain.setWfstep(po.getWfstep());
        //if(po.getZbbmDirtyFlag())
        domain.setZbbm(po.getZbbm());
        //if(po.getNgrqDirtyFlag())
        domain.setNgrq(po.getNgrq());
        //if(po.getNgrlxfsDirtyFlag())
        domain.setNgrlxfs(po.getNgrlxfs());
        //if(po.getNgrjgDirtyFlag())
        domain.setNgrjg(po.getNgrjg());
        //if(po.getNgrbmnameDirtyFlag())
        domain.setNgrbmname(po.getNgrbmname());
        //if(po.getNgrnameDirtyFlag())
        domain.setNgrname(po.getNgrname());
        //if(po.getNgridDirtyFlag())
        domain.setNgrid(po.getNgrid());
        //if(po.getNgrbmidDirtyFlag())
        domain.setNgrbmid(po.getNgrbmid());
        //if(po.getPsidDirtyFlag())
        domain.setPsid(po.getPsid());
        //if(po.getRestDirtyFlag())
        domain.setRest(po.getRest());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public IM convert2PO(com.ibiz.core.ht.domain.IM domain , IM po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getKgsldidsDirtyFlag())
            po.setKgsldids(domain.getKgsldids());
        if(domain.getBzDirtyFlag())
            po.setBz(domain.getBz());
        if(domain.getSblbDirtyFlag())
            po.setSblb(domain.getSblb());
        if(domain.getBmldidsDirtyFlag())
            po.setBmldids(domain.getBmldids());
        if(domain.getJjyyDirtyFlag())
            po.setJjyy(domain.getJjyy());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getHqbmDirtyFlag())
            po.setHqbm(domain.getHqbm());
        if(domain.getSdfsDirtyFlag())
            po.setSdfs(domain.getSdfs());
        if(domain.getKgsbmidsDirtyFlag())
            po.setKgsbmids(domain.getKgsbmids());
        if(domain.getSjbmDirtyFlag())
            po.setSjbm(domain.getSjbm());
        if(domain.getQttzyddxDirtyFlag())
            po.setQttzyddx(domain.getQttzyddx());
        if(domain.getLdDirtyFlag())
            po.setLd(domain.getLd());
        if(domain.getIMNameDirtyFlag())
            po.setIMName(domain.getIMName());
        if(domain.getLcbhDirtyFlag())
            po.setLcbh(domain.getLcbh());
        if(domain.getNgshidsDirtyFlag())
            po.setNgshids(domain.getNgshids());
        if(domain.getKgsldDirtyFlag())
            po.setKgsld(domain.getKgsld());
        if(domain.getShfsDirtyFlag())
            po.setShfs(domain.getShfs());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getIMIdDirtyFlag())
            po.setIMId(domain.getIMId());
        if(domain.getSblxDirtyFlag())
            po.setSblx(domain.getSblx());
        if(domain.getTzydDirtyFlag())
            po.setTzyd(domain.getTzyd());
        if(domain.getWfinstanceidDirtyFlag())
            po.setWfinstanceid(domain.getWfinstanceid());
        if(domain.getBmldDirtyFlag())
            po.setBmld(domain.getBmld());
        if(domain.getTzydyyDirtyFlag())
            po.setTzydyy(domain.getTzydyy());
        if(domain.getImwfstateDirtyFlag())
            po.setImwfstate(domain.getImwfstate());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getYzdxDirtyFlag())
            po.setYzdx(domain.getYzdx());
        if(domain.getNgshDirtyFlag())
            po.setNgsh(domain.getNgsh());
        if(domain.getHjcdDirtyFlag())
            po.setHjcd(domain.getHjcd());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getLdidsDirtyFlag())
            po.setLdids(domain.getLdids());
        if(domain.getHqbmidsDirtyFlag())
            po.setHqbmids(domain.getHqbmids());
        if(domain.getKgsbmDirtyFlag())
            po.setKgsbm(domain.getKgsbm());
        if(domain.getWfstepDirtyFlag())
            po.setWfstep(domain.getWfstep());
        if(domain.getZbbmDirtyFlag())
            po.setZbbm(domain.getZbbm());
        if(domain.getNgrqDirtyFlag())
            po.setNgrq(domain.getNgrq());
        if(domain.getNgrlxfsDirtyFlag())
            po.setNgrlxfs(domain.getNgrlxfs());
        if(domain.getNgrjgDirtyFlag())
            po.setNgrjg(domain.getNgrjg());
        if(domain.getNgrbmnameDirtyFlag())
            po.setNgrbmname(domain.getNgrbmname());
        if(domain.getNgrnameDirtyFlag())
            po.setNgrname(domain.getNgrname());
        if(domain.getNgridDirtyFlag())
            po.setNgrid(domain.getNgrid());
        if(domain.getNgrbmidDirtyFlag())
            po.setNgrbmid(domain.getNgrbmid());
        if(domain.getPsidDirtyFlag())
            po.setPsid(domain.getPsid());
        if(domain.getRestDirtyFlag())
            po.setRest(domain.getRest());

        return po ;
    }
}
