package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.WFBMDTO;
import com.ibiz.core.htwf.domain.WFBM;
import com.ibiz.core.htwf.service.IWFBMService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.htwf.filter.WFBMSearchContext;

@Api(tags = {"WFBM" })
@RestController
@RequestMapping("")
public class WFBMResource {

    @Autowired
    private IWFBMService wfbmService;

    public IWFBMService getWfbmService() {
        return this.wfbmService;
    }

    @ApiOperation(value = "Remove", tags = {"WFBM" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfbms/{wfbm_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("wfbm_id") String wfbm_id) {
        WFBMDTO wfbmdto = new WFBMDTO();
		WFBM domain = new WFBM();
		wfbmdto.setWFBMId(wfbm_id);
		domain.setWFBMId(wfbm_id);
        Boolean rst = wfbmService.remove(domain.getWFBMId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "CheckKey", tags = {"WFBM" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbms/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFBMDTO wfbmdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraft", tags = {"WFBM" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbms/{wfbm_id}/getdraft")
    @Transactional
    public ResponseEntity<WFBMDTO> getDraft(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBMDTO wfbmdto) {
        WFBM wfbm = wfbmdto.toDO();
    	wfbm = wfbmService.getDraft(wfbm) ;
    	wfbmdto.fromDO(wfbm);
        return ResponseEntity.status(HttpStatus.OK).body(wfbmdto);
    }

    @ApiOperation(value = "Create", tags = {"WFBM" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbms")
    @Transactional
    public ResponseEntity<WFBMDTO> create(@RequestBody WFBMDTO wfbmdto) {
        WFBMDTO dto = new WFBMDTO();
        WFBM domain = wfbmdto.toDO();
		wfbmService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"WFBM" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfbms/{wfbm_id}")
    @Transactional
    public ResponseEntity<WFBMDTO> update(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBMDTO wfbmdto) {
		WFBM domain = wfbmdto.toDO();
        domain.setWFBMId(wfbm_id);
		wfbmService.update(domain);
		WFBMDTO dto = new WFBMDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"WFBM" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbms/{wfbm_id}")
    public ResponseEntity<WFBMDTO> get(@PathVariable("wfbm_id") String wfbm_id) {
        WFBMDTO dto = new WFBMDTO();
        WFBM domain = wfbmService.get(wfbm_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"WFBM" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbms/{wfbm_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody WFBMDTO wfbmdto) {
        WFBM wfbm = wfbmdto.toDO();
    	Boolean b = wfbmService.save(wfbm) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"WFBM" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfbms/fetchdefault")
	public ResponseEntity<Page<WFBMDTO>> fetchDefault(WFBMSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFBMDTO> list = new ArrayList<WFBMDTO>();
        
        Page<WFBM> domains = wfbmService.searchDefault(context) ;
        for(WFBM wfbm : domains.getContent()){
            WFBMDTO dto = new WFBMDTO();
            dto.fromDO(wfbm);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
