package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.IMDTO;
import com.ibiz.core.ht.domain.IM;
import com.ibiz.core.ht.service.IIMService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.ht.filter.IMSearchContext;

@Api(tags = {"IM" })
@RestController
@RequestMapping("")
public class IMResource {

    @Autowired
    private IIMService imService;

    public IIMService getImService() {
        return this.imService;
    }

    @ApiOperation(value = "Update", tags = {"IM" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/ims/{im_id}")
    @Transactional
    public ResponseEntity<IMDTO> update(@PathVariable("im_id") String im_id, @RequestBody IMDTO imdto) {
		IM domain = imdto.toDO();
        domain.setIMId(im_id);
		imService.update(domain);
		IMDTO dto = new IMDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"IM" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/ims/{im_id}/getdraft")
    @Transactional
    public ResponseEntity<IMDTO> getDraft(@PathVariable("im_id") String im_id, @RequestBody IMDTO imdto) {
        IM im = imdto.toDO();
    	im = imService.getDraft(im) ;
    	imdto.fromDO(im);
        return ResponseEntity.status(HttpStatus.OK).body(imdto);
    }

    @ApiOperation(value = "Create", tags = {"IM" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ims")
    @Transactional
    public ResponseEntity<IMDTO> create(@RequestBody IMDTO imdto) {
        IMDTO dto = new IMDTO();
        IM domain = imdto.toDO();
		imService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"IM" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/ims/{im_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("im_id") String im_id) {
        IMDTO imdto = new IMDTO();
		IM domain = new IM();
		imdto.setIMId(im_id);
		domain.setIMId(im_id);
        Boolean rst = imService.remove(domain.getIMId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Save", tags = {"IM" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/{im_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody IMDTO imdto) {
        IM im = imdto.toDO();
    	Boolean b = imService.save(im) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Get", tags = {"IM" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/ims/{im_id}")
    public ResponseEntity<IMDTO> get(@PathVariable("im_id") String im_id) {
        IMDTO dto = new IMDTO();
        IM domain = imService.get(im_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"IM" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IMDTO imdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取多选的部门或人员清单", tags = {"IM" },  notes = "获取多选的部门或人员清单")
	@RequestMapping(method = RequestMethod.GET, value = "/web/ims/{im_id}/getmp")
    @Transactional
    public ResponseEntity<IMDTO> getMP(@PathVariable("im_id") String im_id, @RequestBody IMDTO imdto) {
        IM im = imdto.toDO();
    	im = imService.getMP(im) ;
    	imdto.fromDO(im);
        return ResponseEntity.status(HttpStatus.OK).body(imdto);
    }

    @ApiOperation(value = "", tags = {"IM" },  notes = "")
	@RequestMapping(method = RequestMethod.POST, value = "/web/ims/{im_id}/createandstart")
    @Transactional
    public ResponseEntity<IMDTO> createAndStart(@PathVariable("im_id") String im_id, @RequestBody IMDTO imdto) {
        IM im = imdto.toDO();
    	im = imService.createAndStart(im) ;
    	imdto.fromDO(im);
        return ResponseEntity.status(HttpStatus.OK).body(imdto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"IM" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/ims/fetchdefault")
	public ResponseEntity<Page<IMDTO>> fetchDefault(IMSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<IMDTO> list = new ArrayList<IMDTO>();
        
        Page<IM> domains = imService.searchDefault(context) ;
        for(IM im : domains.getContent()){
            IMDTO dto = new IMDTO();
            dto.fromDO(im);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
