package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.WFBCDTO;
import com.ibiz.core.htwf.domain.WFBC;
import com.ibiz.core.htwf.service.IWFBCService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.htwf.filter.WFBCSearchContext;

@Api(tags = {"WFBC" })
@RestController
@RequestMapping("")
public class WFBCResource {

    @Autowired
    private IWFBCService wfbcService;

    public IWFBCService getWfbcService() {
        return this.wfbcService;
    }

    @ApiOperation(value = "Remove", tags = {"WFBC" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfbcs/{wfbc_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("wfbc_id") String wfbc_id) {
        WFBCDTO wfbcdto = new WFBCDTO();
		WFBC domain = new WFBC();
		wfbcdto.setWFBCId(wfbc_id);
		domain.setWFBCId(wfbc_id);
        Boolean rst = wfbcService.remove(domain.getWFBCId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Create", tags = {"WFBC" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbcs")
    @Transactional
    public ResponseEntity<WFBCDTO> create(@RequestBody WFBCDTO wfbcdto) {
        WFBCDTO dto = new WFBCDTO();
        WFBC domain = wfbcdto.toDO();
		wfbcService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"WFBC" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbcs/{wfbc_id}")
    public ResponseEntity<WFBCDTO> get(@PathVariable("wfbc_id") String wfbc_id) {
        WFBCDTO dto = new WFBCDTO();
        WFBC domain = wfbcService.get(wfbc_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"WFBC" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbcs/{wfbc_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody WFBCDTO wfbcdto) {
        WFBC wfbc = wfbcdto.toDO();
    	Boolean b = wfbcService.save(wfbc) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "CheckKey", tags = {"WFBC" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfbcs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFBCDTO wfbcdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraft", tags = {"WFBC" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfbcs/{wfbc_id}/getdraft")
    @Transactional
    public ResponseEntity<WFBCDTO> getDraft(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBCDTO wfbcdto) {
        WFBC wfbc = wfbcdto.toDO();
    	wfbc = wfbcService.getDraft(wfbc) ;
    	wfbcdto.fromDO(wfbc);
        return ResponseEntity.status(HttpStatus.OK).body(wfbcdto);
    }

    @ApiOperation(value = "Update", tags = {"WFBC" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfbcs/{wfbc_id}")
    @Transactional
    public ResponseEntity<WFBCDTO> update(@PathVariable("wfbc_id") String wfbc_id, @RequestBody WFBCDTO wfbcdto) {
		WFBC domain = wfbcdto.toDO();
        domain.setWFBCId(wfbc_id);
		wfbcService.update(domain);
		WFBCDTO dto = new WFBCDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"WFBC" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfbcs/fetchdefault")
	public ResponseEntity<Page<WFBCDTO>> fetchDefault(WFBCSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFBCDTO> list = new ArrayList<WFBCDTO>();
        
        Page<WFBC> domains = wfbcService.searchDefault(context) ;
        for(WFBC wfbc : domains.getContent()){
            WFBCDTO dto = new WFBCDTO();
            dto.fromDO(wfbc);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
