package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.WFIAActionDTO;
import com.ibiz.core.r7rt_wf.domain.WFIAAction;
import com.ibiz.core.r7rt_wf.service.IWFIAActionService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.r7rt_wf.filter.WFIAActionSearchContext;

@Api(tags = {"WFIAAction" })
@RestController
@RequestMapping("")
public class WFIAActionResource {

    @Autowired
    private IWFIAActionService wfiaactionService;

    public IWFIAActionService getWfiaactionService() {
        return this.wfiaactionService;
    }

    @ApiOperation(value = "Remove", tags = {"WFIAAction" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfiaactions/{wfiaaction_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("wfiaaction_id") String wfiaaction_id) {
        WFIAActionDTO wfiaactiondto = new WFIAActionDTO();
		WFIAAction domain = new WFIAAction();
		wfiaactiondto.setWFIAActionId(wfiaaction_id);
		domain.setWFIAActionId(wfiaaction_id);
        Boolean rst = wfiaactionService.remove(domain.getWFIAActionId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Update", tags = {"WFIAAction" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfiaactions/{wfiaaction_id}")

    public ResponseEntity<WFIAActionDTO> update(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAActionDTO wfiaactiondto) {
		WFIAAction domain = wfiaactiondto.toDO();
        domain.setWFIAActionId(wfiaaction_id);
		wfiaactionService.update(domain);
		WFIAActionDTO dto = new WFIAActionDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"WFIAAction" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfiaactions/{wfiaaction_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody WFIAActionDTO wfiaactiondto) {
        WFIAAction wfiaaction = wfiaactiondto.toDO();
    	Boolean b = wfiaactionService.save(wfiaaction) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Get", tags = {"WFIAAction" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfiaactions/{wfiaaction_id}")
    public ResponseEntity<WFIAActionDTO> get(@PathVariable("wfiaaction_id") String wfiaaction_id) {
        WFIAActionDTO dto = new WFIAActionDTO();
        WFIAAction domain = wfiaactionService.get(wfiaaction_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"WFIAAction" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfiaactions/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFIAActionDTO wfiaactiondto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraft", tags = {"WFIAAction" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/wfiaactions/{wfiaaction_id}/getdraft")

    public ResponseEntity<WFIAActionDTO> getDraft(@PathVariable("wfiaaction_id") String wfiaaction_id, @RequestBody WFIAActionDTO wfiaactiondto) {
        WFIAAction wfiaaction = wfiaactiondto.toDO();
    	wfiaaction = wfiaactionService.getDraft(wfiaaction) ;
    	wfiaactiondto.fromDO(wfiaaction);
        return ResponseEntity.status(HttpStatus.OK).body(wfiaactiondto);
    }

    @ApiOperation(value = "Create", tags = {"WFIAAction" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/wfiaactions")

    public ResponseEntity<WFIAActionDTO> create(@RequestBody WFIAActionDTO wfiaactiondto) {
        WFIAActionDTO dto = new WFIAActionDTO();
        WFIAAction domain = wfiaactiondto.toDO();
		wfiaactionService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"WFIAAction" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/wfiaactions/fetchdefault")
	public ResponseEntity<Page<WFIAActionDTO>> fetchDefault(WFIAActionSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<WFIAActionDTO> list = new ArrayList<WFIAActionDTO>();
        
        Page<WFIAAction> domains = wfiaactionService.searchDefault(context) ;
        for(WFIAAction wfiaaction : domains.getContent()){
            WFIAActionDTO dto = new WFIAActionDTO();
            dto.fromDO(wfiaaction);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
