package com.ibiz.wfweb.r7rt_wf.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb.r7rt_wf.service.WFSTEPDATAService;
import com.ibiz.wfweb.r7rt_wf.domain.WFSTEPDATA;
import com.ibiz.wfweb.r7rt_wf.filter.*;

@RestController
@RequestMapping(value = "")
public class WFSTEPDATAController {
	@Autowired
    WFSTEPDATAService wfstepdataservice;


	@RequestMapping(method = RequestMethod.POST, value = "/wfstepdata/checkkey")
    @PreAuthorize("@wfstepdata_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFSTEPDATA wfstepdata) {
        boolean b = wfstepdataservice.checkKey(wfstepdata);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfstepdata/{wfstepdata_id}")
    @PreAuthorize("@wfstepdata_pms.check(#wfstepdata_id,'READ')")
    public ResponseEntity<WFSTEPDATA> get(@PathVariable("wfstepdata_id") String wfstepdata_id) {
        WFSTEPDATA wfstepdata = wfstepdataservice.get( wfstepdata_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfstepdata);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfstepdata/getdraft")
    @PreAuthorize("@wfstepdata_pms.check('CREATE')")
    public ResponseEntity<WFSTEPDATA> getDraft() {
        //WFSTEPDATA wfstepdata = wfstepdataservice.getDraft( wfstepdata_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFSTEPDATA());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfstepdata")
    @PreAuthorize("@wfstepdata_pms.check('CREATE')")
    public ResponseEntity<WFSTEPDATA> create(@RequestBody WFSTEPDATA wfstepdata) {
        WFSTEPDATA wfstepdata2 = wfstepdataservice.create(wfstepdata);
        return ResponseEntity.status(HttpStatus.OK).body(wfstepdata2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/wfstepdata/{wfstepdata_id}")
    @PreAuthorize("@wfstepdata_pms.check(#wfstepdata_id,'UPDATE')")
    public ResponseEntity<WFSTEPDATA> update(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATA wfstepdata) {
        WFSTEPDATA wfstepdata2 = wfstepdataservice.update(wfstepdata_id, wfstepdata);
        return ResponseEntity.status(HttpStatus.OK).body(wfstepdata2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfstepdata/{wfstepdata_id}")
    @PreAuthorize("@wfstepdata_pms.check(#wfstepdata_id,'UPDATE')")
    public ResponseEntity<WFSTEPDATA> api_update(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATA wfstepdata) {
        WFSTEPDATA wfstepdata2 = wfstepdataservice.update(wfstepdata_id, wfstepdata);
        return ResponseEntity.status(HttpStatus.OK).body(wfstepdata2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfstepdata/{wfstepdata_id}/save")
    @PreAuthorize("@wfstepdata_pms.check(#wfstepdata_id,'')")
    public ResponseEntity<WFSTEPDATA> save(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATA wfstepdata) {
        WFSTEPDATA wfstepdata2 = wfstepdataservice.save(wfstepdata_id, wfstepdata);
        return ResponseEntity.status(HttpStatus.OK).body(wfstepdata2);
    }

	@RequestMapping(method = RequestMethod.DELETE, value = "/wfstepdata/{wfstepdata_id}")
    @PreAuthorize("@wfstepdata_pms.check(#wfstepdata_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfstepdata_id") String wfstepdata_id) {
        boolean b = wfstepdataservice.remove( wfstepdata_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfstepdata/fetchbybswfdata")
    @PreAuthorize("@wfstepdata_pms.check('READ')")
	public ResponseEntity<List<WFSTEPDATA>> fetchByBswfdata(WFSTEPDATASearchContext searchContext,Pageable pageable) {
        
        Page<WFSTEPDATA> page = wfstepdataservice.fetchByBswfdata(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfstepdata/fetchbybsdata")
    @PreAuthorize("@wfstepdata_pms.check('READ')")
	public ResponseEntity<List<WFSTEPDATA>> fetchByBsdata(WFSTEPDATASearchContext searchContext,Pageable pageable) {
        
        Page<WFSTEPDATA> page = wfstepdataservice.fetchByBsdata(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfstepdata/fetchdefault")
    @PreAuthorize("@wfstepdata_pms.check('READ')")
	public ResponseEntity<List<WFSTEPDATA>> fetchDefault(WFSTEPDATASearchContext searchContext,Pageable pageable) {
        
        Page<WFSTEPDATA> page = wfstepdataservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


}
