
package com.ibiz.wfweb.r7rt_org.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.stereotype.Service;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import com.alibaba.fastjson.JSONObject;

import org.springframework.util.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ibiz.util.feign.suport.SearchContextFeignEncode;
import com.ibiz.wfweb.r7rt_org.domain.OrgUser;
import com.ibiz.wfweb.r7rt_org.filter.*;
import com.ibiz.wfweb.r7rt_org.feign.OrgUserFeignClient;
import com.ibiz.wfweb.WFWebApplication.WebClientProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;

@Service
public class OrgUserService {

    OrgUserFeignClient client;

    @Autowired
    public OrgUserService(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor,
                                    WebClientProperties webClientProperties) {
        if (webClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgUserFeignClient.class,"http://" + webClientProperties.getServiceId() + "/") ;
		} else if (webClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.client = nameBuilder.target(OrgUserFeignClient.class, "http://" + webClientProperties.getServiceUrl() + "/") ;
		}
    }

    public boolean remove( String orguser_id) {
        return client.remove( orguser_id);
    }

    public OrgUser save(String orguser_id, OrgUser orguser) {
        return client.save(orguser_id, orguser);
    }

    public OrgUser update(String orguser_id, OrgUser orguser) {
        return client.update(orguser_id, orguser);
    }

    public boolean checkKey(OrgUser orguser) {
        return client.checkKey(orguser);
    }

    public OrgUser getDraft(String orguser_id, OrgUser orguser) {
        return client.getDraft(orguser_id, orguser);
    }

	public OrgUser create(OrgUser orguser) {
        return client.create(orguser);
    }

    public OrgUser get( String orguser_id) {
        return client.get( orguser_id);
    }

	public Page<OrgUser> fetchDefault(OrgUserSearchContext searchContext) {
        return client.fetchDefault(searchContext);
    }

}
