package com.ibiz.wfweb.r7rt_org.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.ArrayList;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应用实体[组织用户]
 */
public class OrgUser implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 性别
     */
    private String sex;

    @JsonIgnore
    private boolean sexDirtyFlag;
    
    /**
     * 组织用户标识
     */
    private String orgUserId;

    @JsonIgnore
    private boolean orgUserIdDirtyFlag;
    
    /**
     * 移动电话
     */
    private String mobilePhone;

    @JsonIgnore
    private boolean mobilePhoneDirtyFlag;
    
    /**
     * 证件类型
     */
    private String certType;

    @JsonIgnore
    private boolean certTypeDirtyFlag;
    
    /**
     * 组织用户名称
     */
    private String orgUserName;

    @JsonIgnore
    private boolean orgUserNameDirtyFlag;
    
    /**
     * 用户编号
     */
    private String userCode;

    @JsonIgnore
    private boolean userCodeDirtyFlag;
    
    /**
     * 建立人
     */
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;
    
    /**
     * 更新人
     */
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;
    
    /**
     * 建立时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;
    
    /**
     * 是否启用
     */
    private Integer enable;

    @JsonIgnore
    private boolean enableDirtyFlag;
    
    /**
     * 登录名
     */
    private String loginName;

    @JsonIgnore
    private boolean loginNameDirtyFlag;
    
    /**
     * 证件号
     */
    private String certNo;

    @JsonIgnore
    private boolean certNoDirtyFlag;
    
    /**
     * 用户标识
     */
    private String userId;

    @JsonIgnore
    private boolean userIdDirtyFlag;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;
    
    /**
     * 备注
     */
    private String memo;

    @JsonIgnore
    private boolean memoDirtyFlag;
    
    /**
     * 组织名称
     */
    private String orgName;

    @JsonIgnore
    private boolean orgNameDirtyFlag;
    
    /**
     * 组织标识
     */
    private String orgId;

    @JsonIgnore
    private boolean orgIdDirtyFlag;
    

    /**
     * 获取 [性别]
     */
    @JsonProperty("sex")
    public String getSex(){
        return this.sex ;
    }

    /**
     * 设置 [性别]
     */
    @JsonProperty("sex")
    public void setSex(String  sex){
        this.sex = sex ;
        this.sexDirtyFlag = true ;
    }

    /**
     * 获取 [性别]脏标记
     */
    @JsonIgnore
    public boolean getSexDirtyFlag(){
        return this.sexDirtyFlag ;
    }

    /**
     * 获取 [组织用户标识]
     */
    @JsonProperty("orguserid")
    public String getOrgUserId(){
        return this.orgUserId ;
    }

    /**
     * 设置 [组织用户标识]
     */
    @JsonProperty("orguserid")
    public void setOrgUserId(String  orgUserId){
        this.orgUserId = orgUserId ;
        this.orgUserIdDirtyFlag = true ;
    }

    /**
     * 获取 [组织用户标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserIdDirtyFlag(){
        return this.orgUserIdDirtyFlag ;
    }

    /**
     * 获取 [移动电话]
     */
    @JsonProperty("mobilephone")
    public String getMobilePhone(){
        return this.mobilePhone ;
    }

    /**
     * 设置 [移动电话]
     */
    @JsonProperty("mobilephone")
    public void setMobilePhone(String  mobilePhone){
        this.mobilePhone = mobilePhone ;
        this.mobilePhoneDirtyFlag = true ;
    }

    /**
     * 获取 [移动电话]脏标记
     */
    @JsonIgnore
    public boolean getMobilePhoneDirtyFlag(){
        return this.mobilePhoneDirtyFlag ;
    }

    /**
     * 获取 [证件类型]
     */
    @JsonProperty("certtype")
    public String getCertType(){
        return this.certType ;
    }

    /**
     * 设置 [证件类型]
     */
    @JsonProperty("certtype")
    public void setCertType(String  certType){
        this.certType = certType ;
        this.certTypeDirtyFlag = true ;
    }

    /**
     * 获取 [证件类型]脏标记
     */
    @JsonIgnore
    public boolean getCertTypeDirtyFlag(){
        return this.certTypeDirtyFlag ;
    }

    /**
     * 获取 [组织用户名称]
     */
    @JsonProperty("orgusername")
    public String getOrgUserName(){
        return this.orgUserName ;
    }

    /**
     * 设置 [组织用户名称]
     */
    @JsonProperty("orgusername")
    public void setOrgUserName(String  orgUserName){
        this.orgUserName = orgUserName ;
        this.orgUserNameDirtyFlag = true ;
    }

    /**
     * 获取 [组织用户名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgUserNameDirtyFlag(){
        return this.orgUserNameDirtyFlag ;
    }

    /**
     * 获取 [用户编号]
     */
    @JsonProperty("usercode")
    public String getUserCode(){
        return this.userCode ;
    }

    /**
     * 设置 [用户编号]
     */
    @JsonProperty("usercode")
    public void setUserCode(String  userCode){
        this.userCode = userCode ;
        this.userCodeDirtyFlag = true ;
    }

    /**
     * 获取 [用户编号]脏标记
     */
    @JsonIgnore
    public boolean getUserCodeDirtyFlag(){
        return this.userCodeDirtyFlag ;
    }

    /**
     * 获取 [建立人]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }

    /**
     * 获取 [更新人]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }

    /**
     * 获取 [建立时间]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }

    /**
     * 获取 [是否启用]
     */
    @JsonProperty("enable")
    public Integer getEnable(){
        return this.enable ;
    }

    /**
     * 设置 [是否启用]
     */
    @JsonProperty("enable")
    public void setEnable(Integer  enable){
        this.enable = enable ;
        this.enableDirtyFlag = true ;
    }

    /**
     * 获取 [是否启用]脏标记
     */
    @JsonIgnore
    public boolean getEnableDirtyFlag(){
        return this.enableDirtyFlag ;
    }

    /**
     * 获取 [登录名]
     */
    @JsonProperty("loginname")
    public String getLoginName(){
        return this.loginName ;
    }

    /**
     * 设置 [登录名]
     */
    @JsonProperty("loginname")
    public void setLoginName(String  loginName){
        this.loginName = loginName ;
        this.loginNameDirtyFlag = true ;
    }

    /**
     * 获取 [登录名]脏标记
     */
    @JsonIgnore
    public boolean getLoginNameDirtyFlag(){
        return this.loginNameDirtyFlag ;
    }

    /**
     * 获取 [证件号]
     */
    @JsonProperty("certno")
    public String getCertNo(){
        return this.certNo ;
    }

    /**
     * 设置 [证件号]
     */
    @JsonProperty("certno")
    public void setCertNo(String  certNo){
        this.certNo = certNo ;
        this.certNoDirtyFlag = true ;
    }

    /**
     * 获取 [证件号]脏标记
     */
    @JsonIgnore
    public boolean getCertNoDirtyFlag(){
        return this.certNoDirtyFlag ;
    }

    /**
     * 获取 [用户标识]
     */
    @JsonProperty("userid")
    public String getUserId(){
        return this.userId ;
    }

    /**
     * 设置 [用户标识]
     */
    @JsonProperty("userid")
    public void setUserId(String  userId){
        this.userId = userId ;
        this.userIdDirtyFlag = true ;
    }

    /**
     * 获取 [用户标识]脏标记
     */
    @JsonIgnore
    public boolean getUserIdDirtyFlag(){
        return this.userIdDirtyFlag ;
    }

    /**
     * 获取 [更新时间]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }

    /**
     * 获取 [备注]
     */
    @JsonProperty("memo")
    public String getMemo(){
        return this.memo ;
    }

    /**
     * 设置 [备注]
     */
    @JsonProperty("memo")
    public void setMemo(String  memo){
        this.memo = memo ;
        this.memoDirtyFlag = true ;
    }

    /**
     * 获取 [备注]脏标记
     */
    @JsonIgnore
    public boolean getMemoDirtyFlag(){
        return this.memoDirtyFlag ;
    }

    /**
     * 获取 [组织名称]
     */
    @JsonProperty("orgname")
    public String getOrgName(){
        return this.orgName ;
    }

    /**
     * 设置 [组织名称]
     */
    @JsonProperty("orgname")
    public void setOrgName(String  orgName){
        this.orgName = orgName ;
        this.orgNameDirtyFlag = true ;
    }

    /**
     * 获取 [组织名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgNameDirtyFlag(){
        return this.orgNameDirtyFlag ;
    }

    /**
     * 获取 [组织标识]
     */
    @JsonProperty("orgid")
    public String getOrgId(){
        return this.orgId ;
    }

    /**
     * 设置 [组织标识]
     */
    @JsonProperty("orgid")
    public void setOrgId(String  orgId){
        this.orgId = orgId ;
        this.orgIdDirtyFlag = true ;
    }

    /**
     * 获取 [组织标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgIdDirtyFlag(){
        return this.orgIdDirtyFlag ;
    }



}
