package com.ibiz.wfweb.htwf.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb.htwf.service.WFBMService;
import com.ibiz.wfweb.htwf.domain.WFBM;
import com.ibiz.wfweb.htwf.filter.*;

@RestController
@RequestMapping(value = "")
public class WFBMController {
	@Autowired
    WFBMService wfbmservice;


	@RequestMapping(method = RequestMethod.DELETE, value = "/wfbms/{wfbm_id}")
    @PreAuthorize("@wfbm_pms.check(#wfbm_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("wfbm_id") String wfbm_id) {
        boolean b = wfbmservice.remove( wfbm_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfbms/checkkey")
    @PreAuthorize("@wfbm_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody WFBM wfbm) {
        boolean b = wfbmservice.checkKey(wfbm);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfbms/getdraft")
    @PreAuthorize("@wfbm_pms.check('CREATE')")
    public ResponseEntity<WFBM> getDraft() {
        //WFBM wfbm = wfbmservice.getDraft( wfbm_id);
        return ResponseEntity.status(HttpStatus.OK).body(new WFBM());
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfbms")
    @PreAuthorize("@wfbm_pms.check('CREATE')")
    public ResponseEntity<WFBM> create(@RequestBody WFBM wfbm) {
        WFBM wfbm2 = wfbmservice.create(wfbm);
        return ResponseEntity.status(HttpStatus.OK).body(wfbm2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/wfbms/{wfbm_id}")
    @PreAuthorize("@wfbm_pms.check(#wfbm_id,'UPDATE')")
    public ResponseEntity<WFBM> update(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBM wfbm) {
        WFBM wfbm2 = wfbmservice.update(wfbm_id, wfbm);
        return ResponseEntity.status(HttpStatus.OK).body(wfbm2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/wfbms/{wfbm_id}")
    @PreAuthorize("@wfbm_pms.check(#wfbm_id,'UPDATE')")
    public ResponseEntity<WFBM> api_update(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBM wfbm) {
        WFBM wfbm2 = wfbmservice.update(wfbm_id, wfbm);
        return ResponseEntity.status(HttpStatus.OK).body(wfbm2);
    }

	@RequestMapping(method = RequestMethod.GET, value = "/wfbms/{wfbm_id}")
    @PreAuthorize("@wfbm_pms.check(#wfbm_id,'READ')")
    public ResponseEntity<WFBM> get(@PathVariable("wfbm_id") String wfbm_id) {
        WFBM wfbm = wfbmservice.get( wfbm_id);
        return ResponseEntity.status(HttpStatus.OK).body(wfbm);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/save")
    @PreAuthorize("@wfbm_pms.check(#wfbm_id,'')")
    public ResponseEntity<WFBM> save(@PathVariable("wfbm_id") String wfbm_id, @RequestBody WFBM wfbm) {
        WFBM wfbm2 = wfbmservice.save(wfbm_id, wfbm);
        return ResponseEntity.status(HttpStatus.OK).body(wfbm2);
    }

    @RequestMapping(method= RequestMethod.GET , value="/wfbms/fetchdefault")
    @PreAuthorize("@wfbm_pms.check('READ')")
	public ResponseEntity<List<WFBM>> fetchDefault(WFBMSearchContext searchContext,Pageable pageable) {
        
        Page<WFBM> page = wfbmservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


    /** 工作流行为 **/

    /**
     * 开始流程【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfstart")
    public ResponseEntity<JSONObject> wfStart(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", false);
        if (wfbmservice.wfStart(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 开始流程2【WFStart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/api/wfbms/wfstart")
    public ResponseEntity<JSONObject> wfStart(@RequestBody JSONObject data) {
        if (data == null) {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
        data.put("noET", true);
        if (wfbmservice.wfStart(null, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程处理【WFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfsubmit")
    public ResponseEntity<JSONObject> wfSubmit(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfSubmit(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 测试当前用户是否提交过工作流【testUserWFSubmit】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/testuserwfsubmit")
    public ResponseEntity<Boolean> testUserWFSubmit(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbmservice.testUserWFSubmit(wfbm_id, data));
    }

    /**
     * 测试当前用户是否存在工作任务【testUserExistWorklist】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/testuserexistworklist")
    public ResponseEntity<Boolean> testUserExistWorklist(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbmservice.testUserExistWorklist(wfbm_id, data));
    }

    /**
     * 流程结束【WFClose】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfclose")
    public ResponseEntity<JSONObject> wfClose(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfClose(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程跳转【WFGoto】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfgoto")
    public ResponseEntity<JSONObject> wfGoto(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfGoto(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重启【WFRestart】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfrestart")
    public ResponseEntity<JSONObject> wfRestart(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfRestart(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程撤回【WFRollback】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfrollback")
    public ResponseEntity<JSONObject> wfRollback(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfRollback(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程退回【WFSendBack】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfsendback")
    public ResponseEntity<JSONObject> wfSendBack(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfSendBack(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程重新分配【WFReassign】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfreassign")
    public ResponseEntity<JSONObject> wfReassign(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        if (wfbmservice.wfReassign(wfbm_id, data)) {
            return ResponseEntity.status(HttpStatus.OK).body(data);
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(data);
        }
    }

    /**
     * 流程标记已读【WFMarkRead】
     */
    @RequestMapping(method = RequestMethod.POST, value = "/wfbms/{wfbm_id}/wfmarkread")
    public ResponseEntity<Boolean> wfMarkRead(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbmservice.wfMarkRead(wfbm_id, data));
    }

    /**
     * 流程业务数据行为【WFAction】
     */
    @RequestMapping(method = RequestMethod.POST, value = "api/wfbms/{wfbm_id}/wfaction")
    public ResponseEntity<JSONObject> wfAction(@PathVariable("wfbm_id") String wfbm_id, @RequestBody JSONObject data) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbmservice.wfAction(wfbm_id, data));
    }

    /**
     * 获取代理数据【WFGetProxyData】
     */
    @RequestMapping(method = RequestMethod.GET, value = "/wfbms/{wfbm_id}/wfgetproxydata")
    public ResponseEntity<JSONObject> wfGetProxyData(@PathVariable("wfbm_id") String wfbm_id) {
        return ResponseEntity.status(HttpStatus.OK).body(wfbmservice.wfGetProxyData(wfbm_id));
    }


}
