package com.ibiz.web.r7rt_wf.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.web.r7rt_wf.domain.WFSTEPDATA;
import com.ibiz.web.r7rt_wf.filter.*;


public interface WFSTEPDATAFeignClient {



	@RequestMapping(method = RequestMethod.POST, value = "/web/wfstepdata/checkkey")
    public Boolean checkKey(@RequestBody WFSTEPDATA wfstepdata) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfstepdata/{wfstepdata_id}")
    public WFSTEPDATA get(@PathVariable("wfstepdata_id") String wfstepdata_id) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/wfstepdata/{wfstepdata_id}/getdraft")
    public WFSTEPDATA getDraft(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATA wfstepdata) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfstepdata")
    public WFSTEPDATA create(@RequestBody WFSTEPDATA wfstepdata) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/wfstepdata/{wfstepdata_id}")
    public WFSTEPDATA update(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATA wfstepdata) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/wfstepdata/{wfstepdata_id}/save")
    public WFSTEPDATA save(@PathVariable("wfstepdata_id") String wfstepdata_id, @RequestBody WFSTEPDATA wfstepdata) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/wfstepdata/{wfstepdata_id}")
    public Boolean remove(@PathVariable("wfstepdata_id") String wfstepdata_id) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfstepdata/fetchbybswfdata")
	public Page<WFSTEPDATA> fetchByBswfdata(WFSTEPDATASearchContext searchContext) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfstepdata/fetchbybsdata")
	public Page<WFSTEPDATA> fetchByBsdata(WFSTEPDATASearchContext searchContext) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/wfstepdata/fetchdefault")
	public Page<WFSTEPDATA> fetchDefault(WFSTEPDATASearchContext searchContext) ;
}
