package com.ibiz.web.ht.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.web.ht.domain.BC;
import com.ibiz.web.ht.filter.*;


public interface BCFeignClient {



	@RequestMapping(method = RequestMethod.GET, value = "/web/bcs/{bc_id}")
    public BC get(@PathVariable("bc_id") String bc_id) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/bcs/{bc_id}/getdraft")
    public BC getDraft(@PathVariable("bc_id") String bc_id, @RequestBody BC bc) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/bcs")
    public BC create(@RequestBody BC bc) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/bcs/{bc_id}")
    public Boolean remove(@PathVariable("bc_id") String bc_id) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/bcs/{bc_id}")
    public BC update(@PathVariable("bc_id") String bc_id, @RequestBody BC bc) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/bcs/checkkey")
    public Boolean checkKey(@RequestBody BC bc) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/bcs/{bc_id}/save")
    public BC save(@PathVariable("bc_id") String bc_id, @RequestBody BC bc) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/bcs/fetchdefault")
	public Page<BC> fetchDefault(BCSearchContext searchContext) ;
}
