package com.ibiz.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.ibiz.service.web.dto.SRFFILEDTO;
import com.ibiz.core.ht.domain.SRFFILE;
import com.ibiz.core.ht.service.ISRFFILEService;
import com.ibiz.util.SearchContext;
import com.ibiz.core.ht.filter.SRFFILESearchContext;

@Api(tags = {"SRFFILE" })
@RestController
@RequestMapping("")
public class SRFFILEResource {

    @Autowired
    private ISRFFILEService srffileService;

    public ISRFFILEService getSrffileService() {
        return this.srffileService;
    }

    @ApiOperation(value = "CheckKey", tags = {"SRFFILE" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/srffiles/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody SRFFILEDTO srffiledto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Get", tags = {"SRFFILE" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/srffiles/{srffile_id}")
    public ResponseEntity<SRFFILEDTO> get(@PathVariable("srffile_id") String srffile_id) {
        SRFFILEDTO dto = new SRFFILEDTO();
        SRFFILE domain = srffileService.get(srffile_id);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"SRFFILE" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/srffiles/{srffile_id}/getdraft")
    @Transactional
    public ResponseEntity<SRFFILEDTO> getDraft(@PathVariable("srffile_id") String srffile_id, @RequestBody SRFFILEDTO srffiledto) {
        SRFFILE srffile = srffiledto.toDO();
    	srffile = srffileService.getDraft(srffile) ;
    	srffiledto.fromDO(srffile);
        return ResponseEntity.status(HttpStatus.OK).body(srffiledto);
    }

    @ApiOperation(value = "Update", tags = {"SRFFILE" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/srffiles/{srffile_id}")
    @Transactional
    public ResponseEntity<SRFFILEDTO> update(@PathVariable("srffile_id") String srffile_id, @RequestBody SRFFILEDTO srffiledto) {
		SRFFILE domain = srffiledto.toDO();
        domain.setSRFFILEId(srffile_id);
		srffileService.update(domain);
		SRFFILEDTO dto = new SRFFILEDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"SRFFILE" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/srffiles/{srffile_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("srffile_id") String srffile_id) {
        SRFFILEDTO srffiledto = new SRFFILEDTO();
		SRFFILE domain = new SRFFILE();
		srffiledto.setSRFFILEId(srffile_id);
		domain.setSRFFILEId(srffile_id);
        Boolean rst = srffileService.remove(domain.getSRFFILEId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Create", tags = {"SRFFILE" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/srffiles")
    @Transactional
    public ResponseEntity<SRFFILEDTO> create(@RequestBody SRFFILEDTO srffiledto) {
        SRFFILEDTO dto = new SRFFILEDTO();
        SRFFILE domain = srffiledto.toDO();
		srffileService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"SRFFILE" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/srffiles/{srffile_id}/save")
    public ResponseEntity<Boolean> save(@RequestBody SRFFILEDTO srffiledto) {
        SRFFILE srffile = srffiledto.toDO();
    	Boolean b = srffileService.save(srffile) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"SRFFILE" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/srffiles/fetchdefault")
	public ResponseEntity<Page<SRFFILEDTO>> fetchDefault(SRFFILESearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SRFFILEDTO> list = new ArrayList<SRFFILEDTO>();
        
        Page<SRFFILE> domains = srffileService.searchDefault(context) ;
        for(SRFFILE srffile : domains.getContent()){
            SRFFILEDTO dto = new SRFFILEDTO();
            dto.fromDO(srffile);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
