package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.r7rt_wf.valuerule.anno.wfstepdata.*;
import com.ibiz.core.r7rt_wf.domain.WFSTEPDATA;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[WFSTEPDATADTO]
 */
public class WFSTEPDATADTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @WFSTEPDATACreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [WFSTEPDATAID]
     *
     */
    @WFSTEPDATAWFSTEPDATAIdDefault(info = "默认规则")
    private String wFSTEPDATAId;

    @JsonIgnore
    private boolean wFSTEPDATAIdDirtyFlag;

    /**
     * 属性 [ACTIONTIME]
     *
     */
    @WFSTEPDATAActionTimeDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp actionTime;

    @JsonIgnore
    private boolean actionTimeDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @WFSTEPDATAUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [ACTIONINFO]
     *
     */
    @WFSTEPDATAActionInfoDefault(info = "默认规则")
    private String actionInfo;

    @JsonIgnore
    private boolean actionInfoDirtyFlag;

    /**
     * 属性 [WFSTEPID]
     *
     */
    @WFSTEPDATAWFStepIdDefault(info = "默认规则")
    private String wFStepId;

    @JsonIgnore
    private boolean wFStepIdDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @WFSTEPDATAUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [ACTION]
     *
     */
    @WFSTEPDATAActionDefault(info = "默认规则")
    private String action;

    @JsonIgnore
    private boolean actionDirtyFlag;

    /**
     * 属性 [WFSTEPDATANAME]
     *
     */
    @WFSTEPDATAWFSTEPDATANameDefault(info = "默认规则")
    private String wFSTEPDATAName;

    @JsonIgnore
    private boolean wFSTEPDATANameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @WFSTEPDATACreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [WFSTEPNAME]
     *
     */
    @WFSTEPDATAWFStepNameDefault(info = "默认规则")
    private String wFStepName;

    @JsonIgnore
    private boolean wFStepNameDirtyFlag;


    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [WFSTEPDATAID]
     */
    @JsonProperty("wfstepdataid")
    public String getWFSTEPDATAId(){
        return wFSTEPDATAId ;
    }

    /**
     * 设置 [WFSTEPDATAID]
     */
    @JsonProperty("wfstepdataid")
    public void setWFSTEPDATAId(String  wFSTEPDATAId){
        this.wFSTEPDATAId = wFSTEPDATAId ;
        this.wFSTEPDATAIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEPDATAID]脏标记
     */
    @JsonIgnore
    public boolean getWFSTEPDATAIdDirtyFlag(){
        return wFSTEPDATAIdDirtyFlag ;
    }

    /**
     * 获取 [ACTIONTIME]
     */
    @JsonProperty("actiontime")
    public Timestamp getActionTime(){
        return actionTime ;
    }

    /**
     * 设置 [ACTIONTIME]
     */
    @JsonProperty("actiontime")
    public void setActionTime(Timestamp  actionTime){
        this.actionTime = actionTime ;
        this.actionTimeDirtyFlag = true ;
    }

    /**
     * 获取 [ACTIONTIME]脏标记
     */
    @JsonIgnore
    public boolean getActionTimeDirtyFlag(){
        return actionTimeDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [ACTIONINFO]
     */
    @JsonProperty("actioninfo")
    public String getActionInfo(){
        return actionInfo ;
    }

    /**
     * 设置 [ACTIONINFO]
     */
    @JsonProperty("actioninfo")
    public void setActionInfo(String  actionInfo){
        this.actionInfo = actionInfo ;
        this.actionInfoDirtyFlag = true ;
    }

    /**
     * 获取 [ACTIONINFO]脏标记
     */
    @JsonIgnore
    public boolean getActionInfoDirtyFlag(){
        return actionInfoDirtyFlag ;
    }

    /**
     * 获取 [WFSTEPID]
     */
    @JsonProperty("wfstepid")
    public String getWFStepId(){
        return wFStepId ;
    }

    /**
     * 设置 [WFSTEPID]
     */
    @JsonProperty("wfstepid")
    public void setWFStepId(String  wFStepId){
        this.wFStepId = wFStepId ;
        this.wFStepIdDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEPID]脏标记
     */
    @JsonIgnore
    public boolean getWFStepIdDirtyFlag(){
        return wFStepIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [ACTION]
     */
    @JsonProperty("action")
    public String getAction(){
        return action ;
    }

    /**
     * 设置 [ACTION]
     */
    @JsonProperty("action")
    public void setAction(String  action){
        this.action = action ;
        this.actionDirtyFlag = true ;
    }

    /**
     * 获取 [ACTION]脏标记
     */
    @JsonIgnore
    public boolean getActionDirtyFlag(){
        return actionDirtyFlag ;
    }

    /**
     * 获取 [WFSTEPDATANAME]
     */
    @JsonProperty("wfstepdataname")
    public String getWFSTEPDATAName(){
        return wFSTEPDATAName ;
    }

    /**
     * 设置 [WFSTEPDATANAME]
     */
    @JsonProperty("wfstepdataname")
    public void setWFSTEPDATAName(String  wFSTEPDATAName){
        this.wFSTEPDATAName = wFSTEPDATAName ;
        this.wFSTEPDATANameDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEPDATANAME]脏标记
     */
    @JsonIgnore
    public boolean getWFSTEPDATANameDirtyFlag(){
        return wFSTEPDATANameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [WFSTEPNAME]
     */
    @JsonProperty("wfstepname")
    public String getWFStepName(){
        return wFStepName ;
    }

    /**
     * 设置 [WFSTEPNAME]
     */
    @JsonProperty("wfstepname")
    public void setWFStepName(String  wFStepName){
        this.wFStepName = wFStepName ;
        this.wFStepNameDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEPNAME]脏标记
     */
    @JsonIgnore
    public boolean getWFStepNameDirtyFlag(){
        return wFStepNameDirtyFlag ;
    }



    public WFSTEPDATA toDO() {
        WFSTEPDATA srfdomain = new WFSTEPDATA();
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getWFSTEPDATAIdDirtyFlag())
            srfdomain.setWFSTEPDATAId(wFSTEPDATAId);
        if(getActionTimeDirtyFlag())
            srfdomain.setActionTime(actionTime);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getActionInfoDirtyFlag())
            srfdomain.setActionInfo(actionInfo);
        if(getWFStepIdDirtyFlag())
            srfdomain.setWFStepId(wFStepId);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getActionDirtyFlag())
            srfdomain.setAction(action);
        if(getWFSTEPDATANameDirtyFlag())
            srfdomain.setWFSTEPDATAName(wFSTEPDATAName);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getWFStepNameDirtyFlag())
            srfdomain.setWFStepName(wFStepName);

        return srfdomain;
    }

    public void fromDO(WFSTEPDATA srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getWFSTEPDATAIdDirtyFlag())
            this.setWFSTEPDATAId(srfdomain.getWFSTEPDATAId());
        if(srfdomain.getActionTimeDirtyFlag())
            this.setActionTime(srfdomain.getActionTime());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getActionInfoDirtyFlag())
            this.setActionInfo(srfdomain.getActionInfo());
        if(srfdomain.getWFStepIdDirtyFlag())
            this.setWFStepId(srfdomain.getWFStepId());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getActionDirtyFlag())
            this.setAction(srfdomain.getAction());
        if(srfdomain.getWFSTEPDATANameDirtyFlag())
            this.setWFSTEPDATAName(srfdomain.getWFSTEPDATAName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getWFStepNameDirtyFlag())
            this.setWFStepName(srfdomain.getWFStepName());

    }

    public List<WFSTEPDATADTO> fromDOPage(List<WFSTEPDATA> poPage)   {
        if(poPage == null)
            return null;
        List<WFSTEPDATADTO> dtos=new ArrayList<WFSTEPDATADTO>();
        for(WFSTEPDATA domain : poPage) {
            WFSTEPDATADTO dto = new WFSTEPDATADTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

