package com.ibiz.wfweb2.r7rt_org.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.PageRequest;
import com.ibiz.wfweb2.r7rt_org.service.OrgDeptUserService;
import com.ibiz.wfweb2.r7rt_org.domain.OrgDeptUser;
import com.ibiz.wfweb2.r7rt_org.filter.*;

@RestController
@RequestMapping(value = "")
public class OrgDeptUserController {
	@Autowired
    OrgDeptUserService orgdeptuserservice;


	@RequestMapping(method = RequestMethod.GET, value = "/orgdeptusers/getdraft")
    @PreAuthorize("@orgdeptuser_pms.check('CREATE')")
    public ResponseEntity<OrgDeptUser> getDraft() {
        //OrgDeptUser orgdeptuser = orgdeptuserservice.getDraft( orgdeptuser_id);
        return ResponseEntity.status(HttpStatus.OK).body(new OrgDeptUser());
    }

	@RequestMapping(method = RequestMethod.GET, value = "/orgdeptusers/{orgdeptuser_id}")
    @PreAuthorize("@orgdeptuser_pms.check(#orgdeptuser_id,'READ')")
    public ResponseEntity<OrgDeptUser> get(@PathVariable("orgdeptuser_id") String orgdeptuser_id) {
        OrgDeptUser orgdeptuser = orgdeptuserservice.get( orgdeptuser_id);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptuser);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/orgdeptusers/{orgdeptuser_id}/save")
    @PreAuthorize("@orgdeptuser_pms.check(#orgdeptuser_id,'')")
    public ResponseEntity<OrgDeptUser> save(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUser orgdeptuser) {
        OrgDeptUser orgdeptuser2 = orgdeptuserservice.save(orgdeptuser_id, orgdeptuser);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptuser2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/orgdeptusers")
    @PreAuthorize("@orgdeptuser_pms.check('CREATE')")
    public ResponseEntity<OrgDeptUser> create(@RequestBody OrgDeptUser orgdeptuser) {
        OrgDeptUser orgdeptuser2 = orgdeptuserservice.create(orgdeptuser);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptuser2);
    }

	@RequestMapping(method = RequestMethod.DELETE, value = "/orgdeptusers/{orgdeptuser_id}")
    @PreAuthorize("@orgdeptuser_pms.check(#orgdeptuser_id,'DELETE')")
    public ResponseEntity<Boolean> remove(@PathVariable("orgdeptuser_id") String orgdeptuser_id) {
        boolean b = orgdeptuserservice.remove( orgdeptuser_id);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/orgdeptusers/{orgdeptuser_id}")
    @PreAuthorize("@orgdeptuser_pms.check(#orgdeptuser_id,'UPDATE')")
    public ResponseEntity<OrgDeptUser> update(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUser orgdeptuser) {
        OrgDeptUser orgdeptuser2 = orgdeptuserservice.update(orgdeptuser_id, orgdeptuser);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptuser2);
    }

	@RequestMapping(method = RequestMethod.PUT, value = "/api/orgdeptusers/{orgdeptuser_id}")
    @PreAuthorize("@orgdeptuser_pms.check(#orgdeptuser_id,'UPDATE')")
    public ResponseEntity<OrgDeptUser> api_update(@PathVariable("orgdeptuser_id") String orgdeptuser_id, @RequestBody OrgDeptUser orgdeptuser) {
        OrgDeptUser orgdeptuser2 = orgdeptuserservice.update(orgdeptuser_id, orgdeptuser);
        return ResponseEntity.status(HttpStatus.OK).body(orgdeptuser2);
    }

	@RequestMapping(method = RequestMethod.POST, value = "/orgdeptusers/checkkey")
    @PreAuthorize("@orgdeptuser_pms.check('')")
    public ResponseEntity<Boolean> checkKey(@RequestBody OrgDeptUser orgdeptuser) {
        boolean b = orgdeptuserservice.checkKey(orgdeptuser);
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @RequestMapping(method= RequestMethod.GET , value="/orgdeptusers/fetchgetorgdeptuser")
    @PreAuthorize("@orgdeptuser_pms.check('READ')")
	public ResponseEntity<List<OrgDeptUser>> fetchGetorgdeptuser(OrgDeptUserSearchContext searchContext,Pageable pageable) {
        
        Page<OrgDeptUser> page = orgdeptuserservice.fetchGetorgdeptuser(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }

    @RequestMapping(method= RequestMethod.GET , value="/orgdeptusers/fetchdefault")
    @PreAuthorize("@orgdeptuser_pms.check('READ')")
	public ResponseEntity<List<OrgDeptUser>> fetchDefault(OrgDeptUserSearchContext searchContext,Pageable pageable) {
        
        Page<OrgDeptUser> page = orgdeptuserservice.fetchDefault(searchContext);
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(pageable.getPageNumber()))
        		.header("x-per-page", String.valueOf(pageable.getPageSize()))
        		.header("x-total", String.valueOf(page.getTotalElements()))
        		.body(page.getContent());
    }


}
