package com.ibiz.wfweb.job;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.core.io.ClassPathResource;
import com.alibaba.fastjson.JSONObject;

import java.io.InputStream;
import java.util.List;
import java.util.ArrayList;

import com.ibiz.util.config.SysInfoProperties;
import com.ibiz.util.feign.FeignRequestInterceptor;
import com.ibiz.util.config.UniWFClientProperties;
import com.ibiz.util.feign.UniWFFeignClient;
import com.ibiz.util.domain.*;

/**
 *
 */
@Component
public class WFAppJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFAppJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        /* ---------- 工作流应用注册内容 ---------- */

        // 注册工作流应用
        registWFApp();

        // 注册业务工作流版本
        registWFVer();

        // 注册流程处理
        registWFProcess();

        // 注册流程连接
        registWFLink();

        // 注册流程处理角色
        registWFProcRole();

        // 注册嵌套流程
        registPSWFProcSubWF();

    }

    /**
     * 注册工作流应用
     */
    private void registWFApp() {
        WFApp wfapp = new WFApp();
        wfapp.setWfappid(sysInfoProperties.getAppid());
        wfapp.setWfappname(sysInfoProperties.getAppname());
        wfapp.setPssystemid(sysInfoProperties.getSystemid());
        wfapp.setWorkflowid(sysInfoProperties.getDomainid());
        wfapp.setServiceid(sysInfoProperties.getServiceid());
        wfapp.setServiceurl(sysInfoProperties.getServiceurl());
        wfapp.setAppurl(sysInfoProperties.getAppurl());
        wfapp.setLogicname(sysInfoProperties.getApplogicname());
        uniWFFeignClient.registWFApp(wfapp);
    }

    /**
     * 注册业务工作流版本
     */
    private void registWFVer() {
        List<PSWFVersion> pswfversions = new ArrayList<PSWFVersion>();
        PSWFVersion pswfversion0 = new PSWFVersion();
        pswfversion0.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswfversion0.setPswfversionname("部门内审核 v1");
        pswfversion0.setLogicname("部门内审核 v1");
        pswfversion0.setPsworkflowid("7ba93f6994808554d57fd44f804ae8a2");
        pswfversion0.setPsworkflowname("部门内审核");
        pswfversion0.setWfappid(sysInfoProperties.getAppid());
        pswfversion0.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion0.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion0.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion0.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion0.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfbms"));
        pswfversion0.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion0.setModuleid("WFBM");
        pswfversion0.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion0DesignFile = new ClassPathResource("workflow/BMWFv1.bpmn");
        InputStream pswfversion0Is = null;
        try {
            pswfversion0Is = pswfversion0DesignFile.getInputStream();
            byte[] pswfversion0Content = new byte[pswfversion0Is.available()];
            pswfversion0Is.read(pswfversion0Content);
            pswfversion0.setFilename(pswfversion0.getPswfversionid() + "BMWFv1.bpmn");
            pswfversion0.setFilecontent(pswfversion0Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion0Is != null) {
                try {
                    pswfversion0Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion0Is = null;
        }
        pswfversions.add(pswfversion0);
        PSWFVersion pswfversion1 = new PSWFVersion();
        pswfversion1.setPswfversionid("7cb5ff1c6ffec1fb14676f401e2f7a1c");
        pswfversion1.setPswfversionname("加签 v1");
        pswfversion1.setLogicname("加签 v1");
        pswfversion1.setPsworkflowid("61ba4cc481bd586d0f352ff23f7f1ace");
        pswfversion1.setPsworkflowname("加签");
        pswfversion1.setWfappid(sysInfoProperties.getAppid());
        pswfversion1.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion1.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion1.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion1.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion1.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfas"));
        pswfversion1.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion1.setModuleid("WFAS");
        pswfversion1.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion1DesignFile = new ClassPathResource("workflow/ASWFv1.bpmn");
        InputStream pswfversion1Is = null;
        try {
            pswfversion1Is = pswfversion1DesignFile.getInputStream();
            byte[] pswfversion1Content = new byte[pswfversion1Is.available()];
            pswfversion1Is.read(pswfversion1Content);
            pswfversion1.setFilename(pswfversion1.getPswfversionid() + "ASWFv1.bpmn");
            pswfversion1.setFilecontent(pswfversion1Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion1Is != null) {
                try {
                    pswfversion1Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion1Is = null;
        }
        pswfversions.add(pswfversion1);
        PSWFVersion pswfversion2 = new PSWFVersion();
        pswfversion2.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswfversion2.setPswfversionname("业务协作审批 v1");
        pswfversion2.setLogicname("业务协作审批 v1");
        pswfversion2.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        pswfversion2.setPsworkflowname("业务协作审批");
        pswfversion2.setWfappid(sysInfoProperties.getAppid());
        pswfversion2.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion2.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion2.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion2.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion2.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfbcs"));
        pswfversion2.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion2.setModuleid("WFBC");
        pswfversion2.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion2DesignFile = new ClassPathResource("workflow/PSWFv1.bpmn");
        InputStream pswfversion2Is = null;
        try {
            pswfversion2Is = pswfversion2DesignFile.getInputStream();
            byte[] pswfversion2Content = new byte[pswfversion2Is.available()];
            pswfversion2Is.read(pswfversion2Content);
            pswfversion2.setFilename(pswfversion2.getPswfversionid() + "PSWFv1.bpmn");
            pswfversion2.setFilecontent(pswfversion2Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion2Is != null) {
                try {
                    pswfversion2Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion2Is = null;
        }
        pswfversions.add(pswfversion2);
        PSWFVersion pswfversion3 = new PSWFVersion();
        pswfversion3.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfversion3.setPswfversionname("重要事项审批 v1");
        pswfversion3.setLogicname("重要事项审批 v1");
        pswfversion3.setPsworkflowid("49cfb692bde2ae6d258b26681452fb57");
        pswfversion3.setPsworkflowname("重要事项审批");
        pswfversion3.setWfappid(sysInfoProperties.getAppid());
        pswfversion3.setPssystemid(sysInfoProperties.getSystemid());
        pswfversion3.setWorkflowid(sysInfoProperties.getDomainid());
        pswfversion3.setOrgid(sysInfoProperties.getSysorgid());
        pswfversion3.setOrgdeptid(sysInfoProperties.getSysorgdeptid());
        pswfversion3.setStarturl(sysInfoProperties.getAppurl() + String.format(sysInfoProperties.getWfstarturl(), "wfims"));
        pswfversion3.setViewurl(sysInfoProperties.getAppurl() + sysInfoProperties.getWfviewurl());
        pswfversion3.setModuleid("WFIM");
        pswfversion3.setVersion(1);
        // 文件传入
        ClassPathResource pswfversion3DesignFile = new ClassPathResource("workflow/IMWFv1.bpmn");
        InputStream pswfversion3Is = null;
        try {
            pswfversion3Is = pswfversion3DesignFile.getInputStream();
            byte[] pswfversion3Content = new byte[pswfversion3Is.available()];
            pswfversion3Is.read(pswfversion3Content);
            pswfversion3.setFilename(pswfversion3.getPswfversionid() + "IMWFv1.bpmn");
            pswfversion3.setFilecontent(pswfversion3Content);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pswfversion3Is != null) {
                try {
                    pswfversion3Is.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            pswfversion3Is = null;
        }
        pswfversions.add(pswfversion3);
        uniWFFeignClient.registPSWFVersion(pswfversions);
    }

    /**
     * 注册流程处理
     */
    private void registWFProcess() {
        List<PSWFProcess> pswfprocesses = new ArrayList<PSWFProcess>();
        PSWFProcess pswfprocess0 = new PSWFProcess();
        pswfprocess0.setPswfprocessid("7cb2ca3fd56e8fee8125c0e9e369b7a3");
        pswfprocess0.setPswfprocessname("结束");
        pswfprocess0.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswfprocess0.setPswfversionname("部门内审核 v1");
        pswfprocess0.setWfprocesstype("END");
        pswfprocess0.setWfstepvalue("");
        pswfprocesses.add(pswfprocess0);
        PSWFProcess pswfprocess1 = new PSWFProcess();
        pswfprocess1.setPswfprocessid("faa0d473568865a83c34043f1afe3b06");
        pswfprocess1.setPswfprocessname("相关人员审批");
        pswfprocess1.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswfprocess1.setPswfversionname("部门内审核 v1");
        pswfprocess1.setWfprocesstype("INTERACTIVE");
        pswfprocess1.setWfstepvalue("10");
        pswfprocess1.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess1);
        PSWFProcess pswfprocess2 = new PSWFProcess();
        pswfprocess2.setPswfprocessid("626e605d4265abf5b90545145c38e4db");
        pswfprocess2.setPswfprocessname("部门领导审批");
        pswfprocess2.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswfprocess2.setPswfversionname("部门内审核 v1");
        pswfprocess2.setWfprocesstype("INTERACTIVE");
        pswfprocess2.setWfstepvalue("20");
        pswfprocess2.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess2);
        PSWFProcess pswfprocess3 = new PSWFProcess();
        pswfprocess3.setPswfprocessid("8394fc97d0d7883d3df753dd546a38b8");
        pswfprocess3.setPswfprocessname("开始");
        pswfprocess3.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswfprocess3.setPswfversionname("部门内审核 v1");
        pswfprocess3.setWfprocesstype("START");
        pswfprocess3.setWfstepvalue("");
        pswfprocesses.add(pswfprocess3);
        PSWFProcess pswfprocess4 = new PSWFProcess();
        pswfprocess4.setPswfprocessid("e7125087e3fd766cceb41328e438f926");
        pswfprocess4.setPswfprocessname("处理");
        pswfprocess4.setPswfversionid("7cb5ff1c6ffec1fb14676f401e2f7a1c");
        pswfprocess4.setPswfversionname("加签 v1");
        pswfprocess4.setWfprocesstype("START");
        pswfprocess4.setWfstepvalue("");
        pswfprocesses.add(pswfprocess4);
        PSWFProcess pswfprocess5 = new PSWFProcess();
        pswfprocess5.setPswfprocessid("f2bb7333a85535de39f454d8c83639e8");
        pswfprocess5.setPswfprocessname("加签");
        pswfprocess5.setPswfversionid("7cb5ff1c6ffec1fb14676f401e2f7a1c");
        pswfprocess5.setPswfversionname("加签 v1");
        pswfprocess5.setWfprocesstype("INTERACTIVE");
        pswfprocess5.setWfstepvalue("10");
        pswfprocess5.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess5);
        PSWFProcess pswfprocess6 = new PSWFProcess();
        pswfprocess6.setPswfprocessid("429f731a4cd78d18bb9d46d61fafc968");
        pswfprocess6.setPswfprocessname("处理");
        pswfprocess6.setPswfversionid("7cb5ff1c6ffec1fb14676f401e2f7a1c");
        pswfprocess6.setPswfversionname("加签 v1");
        pswfprocess6.setWfprocesstype("END");
        pswfprocess6.setWfstepvalue("");
        pswfprocesses.add(pswfprocess6);
        PSWFProcess pswfprocess7 = new PSWFProcess();
        pswfprocess7.setPswfprocessid("53671e9137733840de33a3b8a8e827bf");
        pswfprocess7.setPswfprocessname("结束");
        pswfprocess7.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswfprocess7.setPswfversionname("业务协作审批 v1");
        pswfprocess7.setWfprocesstype("END");
        pswfprocess7.setWfstepvalue("");
        pswfprocesses.add(pswfprocess7);
        PSWFProcess pswfprocess8 = new PSWFProcess();
        pswfprocess8.setPswfprocessid("bfc315a29db03bb42757dfd165bd87d2");
        pswfprocess8.setPswfprocessname("开始");
        pswfprocess8.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswfprocess8.setPswfversionname("业务协作审批 v1");
        pswfprocess8.setWfprocesstype("START");
        pswfprocess8.setWfstepvalue("");
        pswfprocesses.add(pswfprocess8);
        PSWFProcess pswfprocess9 = new PSWFProcess();
        pswfprocess9.setPswfprocessid("27c5fff27740ac4dad2b1a4cbde33914");
        pswfprocess9.setPswfprocessname("部门领导审批");
        pswfprocess9.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswfprocess9.setPswfversionname("业务协作审批 v1");
        pswfprocess9.setWfprocesstype("INTERACTIVE");
        pswfprocess9.setWfstepvalue("10");
        pswfprocess9.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess9);
        PSWFProcess pswfprocess10 = new PSWFProcess();
        pswfprocess10.setPswfprocessid("db39850edeee4d79fb61614b5b75606d");
        pswfprocess10.setPswfprocessname("判断是否需要上级");
        pswfprocess10.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess10.setPswfversionname("重要事项审批 v1");
        pswfprocess10.setWfprocesstype("EXCLUSIVEGATEWAY");
        pswfprocess10.setWfstepvalue("");
        pswfprocesses.add(pswfprocess10);
        PSWFProcess pswfprocess11 = new PSWFProcess();
        pswfprocess11.setPswfprocessid("f47e429fc513fffc79b1caf20d6ef7ad");
        pswfprocess11.setPswfprocessname("首席风险官审核");
        pswfprocess11.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess11.setPswfversionname("重要事项审批 v1");
        pswfprocess11.setWfprocesstype("INTERACTIVE");
        pswfprocess11.setWfstepvalue("80");
        pswfprocess11.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess11);
        PSWFProcess pswfprocess12 = new PSWFProcess();
        pswfprocess12.setPswfprocessid("d5f765501a013a592aa135ce4766d737");
        pswfprocess12.setPswfprocessname("开始");
        pswfprocess12.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess12.setPswfversionname("重要事项审批 v1");
        pswfprocess12.setWfprocesstype("START");
        pswfprocess12.setWfstepvalue("");
        pswfprocesses.add(pswfprocess12);
        PSWFProcess pswfprocess13 = new PSWFProcess();
        pswfprocess13.setPswfprocessid("a88ebec7623cc36784da0ec60cda816b");
        pswfprocess13.setPswfprocessname("合规总监审批");
        pswfprocess13.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess13.setPswfversionname("重要事项审批 v1");
        pswfprocess13.setWfprocesstype("INTERACTIVE");
        pswfprocess13.setWfstepvalue("90");
        pswfprocess13.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess13);
        PSWFProcess pswfprocess14 = new PSWFProcess();
        pswfprocess14.setPswfprocessid("5280cfb1272ea3ca74d0f15f905c5338");
        pswfprocess14.setPswfprocessname("部门会签");
        pswfprocess14.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess14.setPswfversionname("重要事项审批 v1");
        pswfprocess14.setWfprocesstype("INTERACTIVE");
        pswfprocess14.setWfstepvalue("40");
        pswfprocess14.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess14);
        PSWFProcess pswfprocess15 = new PSWFProcess();
        pswfprocess15.setPswfprocessid("e963575c5312fb4930dea6ae1e2b6bb9");
        pswfprocess15.setPswfprocessname("上级部门审核");
        pswfprocess15.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess15.setPswfversionname("重要事项审批 v1");
        pswfprocess15.setTargetpswfid("7ba93f6994808554d57fd44f804ae8a2");
        pswfprocess15.setTargetpswfname("部门内审核");
        pswfprocess15.setWfprocesstype("CALLORGACTIVITY");
        pswfprocess15.setWfstepvalue("20");
        pswfprocesses.add(pswfprocess15);
        PSWFProcess pswfprocess16 = new PSWFProcess();
        pswfprocess16.setPswfprocessid("a4d4ea296341ac21641e511aa7d471ad");
        pswfprocess16.setPswfprocessname("部门内审核");
        pswfprocess16.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess16.setPswfversionname("重要事项审批 v1");
        pswfprocess16.setTargetpswfid("7ba93f6994808554d57fd44f804ae8a2");
        pswfprocess16.setTargetpswfname("部门内审核");
        pswfprocess16.setWfprocesstype("CALLORGACTIVITY");
        pswfprocess16.setWfstepvalue("10");
        pswfprocesses.add(pswfprocess16);
        PSWFProcess pswfprocess17 = new PSWFProcess();
        pswfprocess17.setPswfprocessid("583c39267cbe29044a5d02ba2a3cddec");
        pswfprocess17.setPswfprocessname("跨公司会签");
        pswfprocess17.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess17.setPswfversionname("重要事项审批 v1");
        pswfprocess17.setWfprocesstype("INTERACTIVE");
        pswfprocess17.setWfstepvalue("50");
        pswfprocess17.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess17);
        PSWFProcess pswfprocess18 = new PSWFProcess();
        pswfprocess18.setPswfprocessid("9aff4583879afcd30b1d92756dd761ce");
        pswfprocess18.setPswfprocessname("分送");
        pswfprocess18.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess18.setPswfversionname("重要事项审批 v1");
        pswfprocess18.setWfprocesstype("INTERACTIVE");
        pswfprocess18.setWfstepvalue("30");
        pswfprocess18.setMultiinstmode("NONE");
        pswfprocesses.add(pswfprocess18);
        PSWFProcess pswfprocess19 = new PSWFProcess();
        pswfprocess19.setPswfprocessid("c7e3eef0e8176097a985aa3165859bf3");
        pswfprocess19.setPswfprocessname("结束");
        pswfprocess19.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess19.setPswfversionname("重要事项审批 v1");
        pswfprocess19.setWfprocesstype("END");
        pswfprocess19.setWfstepvalue("");
        pswfprocesses.add(pswfprocess19);
        PSWFProcess pswfprocess20 = new PSWFProcess();
        pswfprocess20.setPswfprocessid("c7604e39a26952019015f4b128c9bee3");
        pswfprocess20.setPswfprocessname("业务协作");
        pswfprocess20.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswfprocess20.setPswfversionname("重要事项审批 v1");
        pswfprocess20.setWfprocesstype("EMBED");
        pswfprocess20.setWfstepvalue("70");
        pswfprocesses.add(pswfprocess20);
        uniWFFeignClient.registPSWFProcess(pswfprocesses);
    }

    /**
     * 注册流程连接
     */
    private void registWFLink() {
        List<PSWFLink> pswflinks = new ArrayList<PSWFLink>();
        PSWFLink pswflink0 = new PSWFLink();
        pswflink0.setPswflinkid("7e5e05eb70aece70c5a725c52d64cdb9");
        pswflink0.setPswflinkname("C73");
        pswflink0.setLogicname("审核通过");
        pswflink0.setFrompswfprocid("faa0d473568865a83c34043f1afe3b06");
        pswflink0.setTopswfprocid("626e605d4265abf5b90545145c38e4db");
        pswflink0.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswflink0.setPswfversionname("部门内审核 v1");
        pswflinks.add(pswflink0);
        PSWFLink pswflink1 = new PSWFLink();
        pswflink1.setPswflinkid("c22292124ded31c89f1ad5701886c974");
        pswflink1.setPswflinkname("C63");
        pswflink1.setLogicname("审核通过");
        pswflink1.setFrompswfprocid("626e605d4265abf5b90545145c38e4db");
        pswflink1.setTopswfprocid("7cb2ca3fd56e8fee8125c0e9e369b7a3");
        pswflink1.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswflink1.setPswfversionname("部门内审核 v1");
        pswflinks.add(pswflink1);
        PSWFLink pswflink2 = new PSWFLink();
        pswflink2.setPswflinkid("34d1be18044d5e8e0038e57539f67aaf");
        pswflink2.setPswflinkname("连接65");
        pswflink2.setLogicname("");
        pswflink2.setFrompswfprocid("8394fc97d0d7883d3df753dd546a38b8");
        pswflink2.setTopswfprocid("faa0d473568865a83c34043f1afe3b06");
        pswflink2.setPswfversionid("8630508b011b5fb34be85ee2258e332d");
        pswflink2.setPswfversionname("部门内审核 v1");
        pswflinks.add(pswflink2);
        PSWFLink pswflink3 = new PSWFLink();
        pswflink3.setPswflinkid("6f78be728a5d3dde443776af6d4920fc");
        pswflink3.setPswflinkname("连接75");
        pswflink3.setLogicname("");
        pswflink3.setFrompswfprocid("e7125087e3fd766cceb41328e438f926");
        pswflink3.setTopswfprocid("f2bb7333a85535de39f454d8c83639e8");
        pswflink3.setPswfversionid("7cb5ff1c6ffec1fb14676f401e2f7a1c");
        pswflink3.setPswfversionname("加签 v1");
        pswflinks.add(pswflink3);
        PSWFLink pswflink4 = new PSWFLink();
        pswflink4.setPswflinkid("911dcd19966ec5c1ff800a09667221ae");
        pswflink4.setPswflinkname("C3598");
        pswflink4.setLogicname("提交");
        pswflink4.setFrompswfprocid("f2bb7333a85535de39f454d8c83639e8");
        pswflink4.setTopswfprocid("429f731a4cd78d18bb9d46d61fafc968");
        pswflink4.setPswfversionid("7cb5ff1c6ffec1fb14676f401e2f7a1c");
        pswflink4.setPswfversionname("加签 v1");
        pswflinks.add(pswflink4);
        PSWFLink pswflink5 = new PSWFLink();
        pswflink5.setPswflinkid("315b70473434258a9d3b5322a05aa112");
        pswflink5.setPswflinkname("C43");
        pswflink5.setLogicname("操作43");
        pswflink5.setFrompswfprocid("27c5fff27740ac4dad2b1a4cbde33914");
        pswflink5.setTopswfprocid("53671e9137733840de33a3b8a8e827bf");
        pswflink5.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswflink5.setPswfversionname("业务协作审批 v1");
        pswflinks.add(pswflink5);
        PSWFLink pswflink6 = new PSWFLink();
        pswflink6.setPswflinkid("234c870c827621ebc030cbebb1e46f79");
        pswflink6.setPswflinkname("连接5");
        pswflink6.setLogicname("");
        pswflink6.setFrompswfprocid("bfc315a29db03bb42757dfd165bd87d2");
        pswflink6.setTopswfprocid("27c5fff27740ac4dad2b1a4cbde33914");
        pswflink6.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswflink6.setPswfversionname("业务协作审批 v1");
        pswflinks.add(pswflink6);
        PSWFLink pswflink7 = new PSWFLink();
        pswflink7.setPswflinkid("171d75acc68962a0b8a686df95415e3a");
        pswflink7.setPswflinkname("C35");
        pswflink7.setLogicname("提交");
        pswflink7.setFrompswfprocid("5280cfb1272ea3ca74d0f15f905c5338");
        pswflink7.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink7.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink7.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink7);
        PSWFLink pswflink8 = new PSWFLink();
        pswflink8.setPswflinkid("2e6214e11c50b7d2064652f801b95a5c");
        pswflink8.setPswflinkname("C4158");
        pswflink8.setLogicname("提交");
        pswflink8.setFrompswfprocid("583c39267cbe29044a5d02ba2a3cddec");
        pswflink8.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink8.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink8.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink8);
        PSWFLink pswflink9 = new PSWFLink();
        pswflink9.setPswflinkid("0c6f462de112d1de32cf2b59faeddab8");
        pswflink9.setPswflinkname("C34");
        pswflink9.setLogicname("操作34");
        pswflink9.setFrompswfprocid("c7604e39a26952019015f4b128c9bee3");
        pswflink9.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink9.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink9.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink9);
        PSWFLink pswflink10 = new PSWFLink();
        pswflink10.setPswflinkid("73ccca80be99b1787e0279db0833c2cb");
        pswflink10.setPswflinkname("连接2");
        pswflink10.setLogicname("");
        pswflink10.setFrompswfprocid("d5f765501a013a592aa135ce4766d737");
        pswflink10.setTopswfprocid("a4d4ea296341ac21641e511aa7d471ad");
        pswflink10.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink10.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink10);
        PSWFLink pswflink11 = new PSWFLink();
        pswflink11.setPswflinkid("ad6bd431b1ad30a3c38ff0a028122d9a");
        pswflink11.setPswflinkname("C59");
        pswflink11.setLogicname("操作59");
        pswflink11.setFrompswfprocid("a4d4ea296341ac21641e511aa7d471ad");
        pswflink11.setTopswfprocid("db39850edeee4d79fb61614b5b75606d");
        pswflink11.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink11.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink11);
        PSWFLink pswflink12 = new PSWFLink();
        pswflink12.setPswflinkid("074e02c43d8e5bf7f84f1300fcbbd4ac");
        pswflink12.setPswflinkname("C84");
        pswflink12.setLogicname("操作84");
        pswflink12.setFrompswfprocid("e963575c5312fb4930dea6ae1e2b6bb9");
        pswflink12.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink12.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink12.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink12);
        PSWFLink pswflink13 = new PSWFLink();
        pswflink13.setPswflinkid("fa522f5d2e070273a453da039824110c");
        pswflink13.setPswflinkname("C66");
        pswflink13.setLogicname("送会签");
        pswflink13.setFrompswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink13.setTopswfprocid("5280cfb1272ea3ca74d0f15f905c5338");
        pswflink13.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink13.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink13);
        PSWFLink pswflink14 = new PSWFLink();
        pswflink14.setPswflinkid("a7cdc3432482e1f8ee57a111c6936312");
        pswflink14.setPswflinkname("C47");
        pswflink14.setLogicname("送首席风险官审核");
        pswflink14.setFrompswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink14.setTopswfprocid("f47e429fc513fffc79b1caf20d6ef7ad");
        pswflink14.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink14.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink14);
        PSWFLink pswflink15 = new PSWFLink();
        pswflink15.setPswflinkid("837fa640d0838fea7b716707ada7747b");
        pswflink15.setPswflinkname("C37");
        pswflink15.setLogicname("送跨公司会签");
        pswflink15.setFrompswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink15.setTopswfprocid("583c39267cbe29044a5d02ba2a3cddec");
        pswflink15.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink15.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink15);
        PSWFLink pswflink16 = new PSWFLink();
        pswflink16.setPswflinkid("bdb1413ecc263eab90d2f44ccc00fd30");
        pswflink16.setPswflinkname("C44");
        pswflink16.setLogicname("送合规总监审批");
        pswflink16.setFrompswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink16.setTopswfprocid("a88ebec7623cc36784da0ec60cda816b");
        pswflink16.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink16.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink16);
        PSWFLink pswflink17 = new PSWFLink();
        pswflink17.setPswflinkid("f87be994111de1d019524fe3bea65a62");
        pswflink17.setPswflinkname("C85");
        pswflink17.setLogicname("送业务协作");
        pswflink17.setFrompswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink17.setTopswfprocid("c7604e39a26952019015f4b128c9bee3");
        pswflink17.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink17.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink17);
        PSWFLink pswflink18 = new PSWFLink();
        pswflink18.setPswflinkid("3eb5bc6acd7a350c0e140e1af150b6de");
        pswflink18.setPswflinkname("C8501");
        pswflink18.setLogicname("送办结");
        pswflink18.setFrompswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink18.setTopswfprocid("c7e3eef0e8176097a985aa3165859bf3");
        pswflink18.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink18.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink18);
        PSWFLink pswflink19 = new PSWFLink();
        pswflink19.setPswflinkid("4a17643b048a6e223e6c087e77f7c26f");
        pswflink19.setPswflinkname("C893");
        pswflink19.setLogicname("");
        pswflink19.setFrompswfprocid("db39850edeee4d79fb61614b5b75606d");
        pswflink19.setTopswfprocid("e963575c5312fb4930dea6ae1e2b6bb9");
        pswflink19.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink19.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink19);
        PSWFLink pswflink20 = new PSWFLink();
        pswflink20.setPswflinkid("92905d998183da7c8195cee302b62e38");
        pswflink20.setPswflinkname("C7118");
        pswflink20.setLogicname("");
        pswflink20.setFrompswfprocid("db39850edeee4d79fb61614b5b75606d");
        pswflink20.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink20.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink20.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink20);
        PSWFLink pswflink21 = new PSWFLink();
        pswflink21.setPswflinkid("55f2c38b41ee5bc424eff67b18d9eb60");
        pswflink21.setPswflinkname("C297");
        pswflink21.setLogicname("提交");
        pswflink21.setFrompswfprocid("a88ebec7623cc36784da0ec60cda816b");
        pswflink21.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink21.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink21.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink21);
        PSWFLink pswflink22 = new PSWFLink();
        pswflink22.setPswflinkid("e86a4364e382a42f500e016d22b4cae7");
        pswflink22.setPswflinkname("C9391");
        pswflink22.setLogicname("提交");
        pswflink22.setFrompswfprocid("f47e429fc513fffc79b1caf20d6ef7ad");
        pswflink22.setTopswfprocid("9aff4583879afcd30b1d92756dd761ce");
        pswflink22.setPswfversionid("da7f829788488a2ce89ad820a1635ded");
        pswflink22.setPswfversionname("重要事项审批 v1");
        pswflinks.add(pswflink22);
        uniWFFeignClient.registPSWFLink(pswflinks);
    }

    /**
     * 注册流程处理角色
     */
    private void registWFProcRole() {
        List<PSWFProcRole> pswfprocroles = new ArrayList<PSWFProcRole>();
        JSONObject data0 = new JSONObject();
        data0.put("pswfprocessid", "7cb2ca3fd56e8fee8125c0e9e369b7a3");
        uniWFFeignClient.clearPSWFProcRole(data0);
        JSONObject data1 = new JSONObject();
        data1.put("pswfprocessid", "faa0d473568865a83c34043f1afe3b06");
        uniWFFeignClient.clearPSWFProcRole(data1);
        PSWFProcRole pswfprocrole0 = new PSWFProcRole();
        pswfprocrole0.setPswfprocessid("faa0d473568865a83c34043f1afe3b06");
        pswfprocrole0.setPswfprocessname("相关人员审批");
        pswfprocrole0.setPswfprocroleid("947de6ba946e71269dce86fb8e5bee3c");
        pswfprocrole0.setPswfprocrolename("[当前数据属性]");
        pswfprocrole0.setPswfprocrolename("[当前数据属性]NGSHIDS");
        pswfprocrole0.setUdfield("NGSHIDS");
        pswfprocrole0.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole0);
        JSONObject data2 = new JSONObject();
        data2.put("pswfprocessid", "626e605d4265abf5b90545145c38e4db");
        uniWFFeignClient.clearPSWFProcRole(data2);
        PSWFProcRole pswfprocrole1 = new PSWFProcRole();
        pswfprocrole1.setPswfprocessid("626e605d4265abf5b90545145c38e4db");
        pswfprocrole1.setPswfprocessname("部门领导审批");
        pswfprocrole1.setPswfprocroleid("f25f91c31535bdbc13cabb08023d5049");
        pswfprocrole1.setPswfprocrolename("[当前数据属性]");
        pswfprocrole1.setPswfprocrolename("[当前数据属性]BMLDIDS");
        pswfprocrole1.setUdfield("BMLDIDS");
        pswfprocrole1.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole1);
        JSONObject data3 = new JSONObject();
        data3.put("pswfprocessid", "8394fc97d0d7883d3df753dd546a38b8");
        uniWFFeignClient.clearPSWFProcRole(data3);
        JSONObject data4 = new JSONObject();
        data4.put("pswfprocessid", "e7125087e3fd766cceb41328e438f926");
        uniWFFeignClient.clearPSWFProcRole(data4);
        JSONObject data5 = new JSONObject();
        data5.put("pswfprocessid", "f2bb7333a85535de39f454d8c83639e8");
        uniWFFeignClient.clearPSWFProcRole(data5);
        JSONObject data6 = new JSONObject();
        data6.put("pswfprocessid", "429f731a4cd78d18bb9d46d61fafc968");
        uniWFFeignClient.clearPSWFProcRole(data6);
        JSONObject data7 = new JSONObject();
        data7.put("pswfprocessid", "53671e9137733840de33a3b8a8e827bf");
        uniWFFeignClient.clearPSWFProcRole(data7);
        JSONObject data8 = new JSONObject();
        data8.put("pswfprocessid", "bfc315a29db03bb42757dfd165bd87d2");
        uniWFFeignClient.clearPSWFProcRole(data8);
        JSONObject data9 = new JSONObject();
        data9.put("pswfprocessid", "27c5fff27740ac4dad2b1a4cbde33914");
        uniWFFeignClient.clearPSWFProcRole(data9);
        PSWFProcRole pswfprocrole2 = new PSWFProcRole();
        pswfprocrole2.setPswfprocessid("27c5fff27740ac4dad2b1a4cbde33914");
        pswfprocrole2.setPswfprocessname("部门领导审批");
        pswfprocrole2.setPswfprocroleid("d768104ff2f96a08aa778cc041e22c65");
        pswfprocrole2.setPswfprocrolename("[当前数据属性]");
        pswfprocrole2.setPswfprocrolename("[当前数据属性]BMLDIDS");
        pswfprocrole2.setUdfield("BMLDIDS");
        pswfprocrole2.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole2);
        JSONObject data10 = new JSONObject();
        data10.put("pswfprocessid", "db39850edeee4d79fb61614b5b75606d");
        uniWFFeignClient.clearPSWFProcRole(data10);
        JSONObject data11 = new JSONObject();
        data11.put("pswfprocessid", "f47e429fc513fffc79b1caf20d6ef7ad");
        uniWFFeignClient.clearPSWFProcRole(data11);
        PSWFProcRole pswfprocrole3 = new PSWFProcRole();
        pswfprocrole3.setPswfprocessid("f47e429fc513fffc79b1caf20d6ef7ad");
        pswfprocrole3.setPswfprocessname("首席风险官审核");
        pswfprocrole3.setPswfprocroleid("e4a48f24863e7264d8fb59e04c408d77");
        pswfprocrole3.setPswfprocrolename("首席风险官");
        pswfprocrole3.setPswfroleid("55e8a8d907bcbe8d120a8d1a59d3f4da");
        pswfprocrole3.setPswfrolename("首席风险官");
        pswfprocrole3.setPswfprocrolename("首席风险官");
        pswfprocrole3.setUdfield("");
        pswfprocrole3.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole3);
        JSONObject data12 = new JSONObject();
        data12.put("pswfprocessid", "d5f765501a013a592aa135ce4766d737");
        uniWFFeignClient.clearPSWFProcRole(data12);
        JSONObject data13 = new JSONObject();
        data13.put("pswfprocessid", "a88ebec7623cc36784da0ec60cda816b");
        uniWFFeignClient.clearPSWFProcRole(data13);
        PSWFProcRole pswfprocrole4 = new PSWFProcRole();
        pswfprocrole4.setPswfprocessid("a88ebec7623cc36784da0ec60cda816b");
        pswfprocrole4.setPswfprocessname("合规总监审批");
        pswfprocrole4.setPswfprocroleid("82fd1c172eb51c7759c50e93bf788619");
        pswfprocrole4.setPswfprocrolename("合规总监");
        pswfprocrole4.setPswfroleid("936c95f22b04074d465da056021e812e");
        pswfprocrole4.setPswfrolename("合规总监");
        pswfprocrole4.setPswfprocrolename("合规总监");
        pswfprocrole4.setUdfield("");
        pswfprocrole4.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole4);
        JSONObject data14 = new JSONObject();
        data14.put("pswfprocessid", "5280cfb1272ea3ca74d0f15f905c5338");
        uniWFFeignClient.clearPSWFProcRole(data14);
        PSWFProcRole pswfprocrole5 = new PSWFProcRole();
        pswfprocrole5.setPswfprocessid("5280cfb1272ea3ca74d0f15f905c5338");
        pswfprocrole5.setPswfprocessname("部门会签");
        pswfprocrole5.setPswfprocroleid("bc084d11f204cb1417e0f21052059014");
        pswfprocrole5.setPswfprocrolename("[当前数据属性]");
        pswfprocrole5.setPswfprocrolename("[当前数据属性]HQBMIDS");
        pswfprocrole5.setUdfield("HQBMIDS");
        pswfprocrole5.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole5);
        JSONObject data15 = new JSONObject();
        data15.put("pswfprocessid", "e963575c5312fb4930dea6ae1e2b6bb9");
        uniWFFeignClient.clearPSWFProcRole(data15);
        PSWFProcRole pswfprocrole6 = new PSWFProcRole();
        pswfprocrole6.setPswfprocessid("e963575c5312fb4930dea6ae1e2b6bb9");
        pswfprocrole6.setPswfprocessname("上级部门审核");
        pswfprocrole6.setPswfprocroleid("af6d5063d16144a06c311b3e07fca2a2");
        pswfprocrole6.setPswfprocrolename("当前父部门");
        pswfprocrole6.setPswfroleid("af365d7d3bc8e5f87d20a05f625fb593");
        pswfprocrole6.setPswfrolename("当前父部门");
        pswfprocrole6.setPswfprocrolename("当前父部门");
        pswfprocrole6.setUdfield("");
        pswfprocrole6.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole6);
        JSONObject data16 = new JSONObject();
        data16.put("pswfprocessid", "a4d4ea296341ac21641e511aa7d471ad");
        uniWFFeignClient.clearPSWFProcRole(data16);
        PSWFProcRole pswfprocrole7 = new PSWFProcRole();
        pswfprocrole7.setPswfprocessid("a4d4ea296341ac21641e511aa7d471ad");
        pswfprocrole7.setPswfprocessname("部门内审核");
        pswfprocrole7.setPswfprocroleid("4af28d146c7e49096ecae0557e44e7e7");
        pswfprocrole7.setPswfprocrolename("当前部门");
        pswfprocrole7.setPswfroleid("5d0b93fa52d3ab0d048652b80b67cb6e");
        pswfprocrole7.setPswfrolename("当前部门");
        pswfprocrole7.setPswfprocrolename("当前部门");
        pswfprocrole7.setUdfield("");
        pswfprocrole7.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole7);
        JSONObject data17 = new JSONObject();
        data17.put("pswfprocessid", "583c39267cbe29044a5d02ba2a3cddec");
        uniWFFeignClient.clearPSWFProcRole(data17);
        PSWFProcRole pswfprocrole8 = new PSWFProcRole();
        pswfprocrole8.setPswfprocessid("583c39267cbe29044a5d02ba2a3cddec");
        pswfprocrole8.setPswfprocessname("跨公司会签");
        pswfprocrole8.setPswfprocroleid("d62f9cc4ee3e364a335b682d5f9ce385");
        pswfprocrole8.setPswfprocrolename("[当前数据属性]");
        pswfprocrole8.setPswfprocrolename("[当前数据属性]KGSBMIDS");
        pswfprocrole8.setUdfield("KGSBMIDS");
        pswfprocrole8.setRoletype("UDACTOR");
        pswfprocroles.add(pswfprocrole8);
        JSONObject data18 = new JSONObject();
        data18.put("pswfprocessid", "9aff4583879afcd30b1d92756dd761ce");
        uniWFFeignClient.clearPSWFProcRole(data18);
        PSWFProcRole pswfprocrole9 = new PSWFProcRole();
        pswfprocrole9.setPswfprocessid("9aff4583879afcd30b1d92756dd761ce");
        pswfprocrole9.setPswfprocessname("分送");
        pswfprocrole9.setPswfprocroleid("69de0e9ea050fa3abc9ee69e324d8150");
        pswfprocrole9.setPswfprocrolename("分送人");
        pswfprocrole9.setPswfroleid("1d3ee34582ecb3b3903d9a35ebef9dab");
        pswfprocrole9.setPswfrolename("分送人");
        pswfprocrole9.setPswfprocrolename("分送人");
        pswfprocrole9.setUdfield("");
        pswfprocrole9.setRoletype("WFROLE");
        pswfprocroles.add(pswfprocrole9);
        JSONObject data19 = new JSONObject();
        data19.put("pswfprocessid", "c7e3eef0e8176097a985aa3165859bf3");
        uniWFFeignClient.clearPSWFProcRole(data19);
        JSONObject data20 = new JSONObject();
        data20.put("pswfprocessid", "c7604e39a26952019015f4b128c9bee3");
        uniWFFeignClient.clearPSWFProcRole(data20);
        uniWFFeignClient.registPSWFProcRole(pswfprocroles);
    }

    /**
     * 注册嵌套流程
     */
    private void registPSWFProcSubWF() {
        List<PSWFProcSubWF> pswfprocsubwfs = new ArrayList<PSWFProcSubWF>();
        JSONObject data0 = new JSONObject();
        data0.put("pswfprocessid", "7cb2ca3fd56e8fee8125c0e9e369b7a3");
        uniWFFeignClient.clearPSWFProcSubWF(data0);
        JSONObject data1 = new JSONObject();
        data1.put("pswfprocessid", "faa0d473568865a83c34043f1afe3b06");
        uniWFFeignClient.clearPSWFProcSubWF(data1);
        JSONObject data2 = new JSONObject();
        data2.put("pswfprocessid", "626e605d4265abf5b90545145c38e4db");
        uniWFFeignClient.clearPSWFProcSubWF(data2);
        JSONObject data3 = new JSONObject();
        data3.put("pswfprocessid", "8394fc97d0d7883d3df753dd546a38b8");
        uniWFFeignClient.clearPSWFProcSubWF(data3);
        JSONObject data4 = new JSONObject();
        data4.put("pswfprocessid", "e7125087e3fd766cceb41328e438f926");
        uniWFFeignClient.clearPSWFProcSubWF(data4);
        JSONObject data5 = new JSONObject();
        data5.put("pswfprocessid", "f2bb7333a85535de39f454d8c83639e8");
        uniWFFeignClient.clearPSWFProcSubWF(data5);
        JSONObject data6 = new JSONObject();
        data6.put("pswfprocessid", "429f731a4cd78d18bb9d46d61fafc968");
        uniWFFeignClient.clearPSWFProcSubWF(data6);
        JSONObject data7 = new JSONObject();
        data7.put("pswfprocessid", "53671e9137733840de33a3b8a8e827bf");
        uniWFFeignClient.clearPSWFProcSubWF(data7);
        JSONObject data8 = new JSONObject();
        data8.put("pswfprocessid", "bfc315a29db03bb42757dfd165bd87d2");
        uniWFFeignClient.clearPSWFProcSubWF(data8);
        JSONObject data9 = new JSONObject();
        data9.put("pswfprocessid", "27c5fff27740ac4dad2b1a4cbde33914");
        uniWFFeignClient.clearPSWFProcSubWF(data9);
        JSONObject data10 = new JSONObject();
        data10.put("pswfprocessid", "db39850edeee4d79fb61614b5b75606d");
        uniWFFeignClient.clearPSWFProcSubWF(data10);
        JSONObject data11 = new JSONObject();
        data11.put("pswfprocessid", "f47e429fc513fffc79b1caf20d6ef7ad");
        uniWFFeignClient.clearPSWFProcSubWF(data11);
        JSONObject data12 = new JSONObject();
        data12.put("pswfprocessid", "d5f765501a013a592aa135ce4766d737");
        uniWFFeignClient.clearPSWFProcSubWF(data12);
        JSONObject data13 = new JSONObject();
        data13.put("pswfprocessid", "a88ebec7623cc36784da0ec60cda816b");
        uniWFFeignClient.clearPSWFProcSubWF(data13);
        JSONObject data14 = new JSONObject();
        data14.put("pswfprocessid", "5280cfb1272ea3ca74d0f15f905c5338");
        uniWFFeignClient.clearPSWFProcSubWF(data14);
        JSONObject data15 = new JSONObject();
        data15.put("pswfprocessid", "e963575c5312fb4930dea6ae1e2b6bb9");
        uniWFFeignClient.clearPSWFProcSubWF(data15);
        JSONObject data16 = new JSONObject();
        data16.put("pswfprocessid", "a4d4ea296341ac21641e511aa7d471ad");
        uniWFFeignClient.clearPSWFProcSubWF(data16);
        JSONObject data17 = new JSONObject();
        data17.put("pswfprocessid", "583c39267cbe29044a5d02ba2a3cddec");
        uniWFFeignClient.clearPSWFProcSubWF(data17);
        JSONObject data18 = new JSONObject();
        data18.put("pswfprocessid", "9aff4583879afcd30b1d92756dd761ce");
        uniWFFeignClient.clearPSWFProcSubWF(data18);
        JSONObject data19 = new JSONObject();
        data19.put("pswfprocessid", "c7e3eef0e8176097a985aa3165859bf3");
        uniWFFeignClient.clearPSWFProcSubWF(data19);
        JSONObject data20 = new JSONObject();
        data20.put("pswfprocessid", "c7604e39a26952019015f4b128c9bee3");
        uniWFFeignClient.clearPSWFProcSubWF(data20);
        PSWFProcSubWF pswfprocsubwf0 = new PSWFProcSubWF();
        pswfprocsubwf0.setPswfprocsubwfname("业务协作");
        pswfprocsubwf0.setPswfprocsubwfid("12090b2bc775540fe817d8cf222137c9");
        pswfprocsubwf0.setPswfversionid("5053c4ea3d081c5166f11ac30a7ed12e");
        pswfprocsubwf0.setPswfprocessid("c7604e39a26952019015f4b128c9bee3");
        pswfprocsubwf0.setPsworkflowid("d95fe2a1d9f0fffd81b11a864f2fc7a7");
        pswfprocsubwf0.setSubwfdeid("d1a54da97f37e5d110b31724de3916ac");
        pswfprocsubwf0.setSubwfdedataset("Default");
        pswfprocsubwfs.add(pswfprocsubwf0);
        uniWFFeignClient.registPSWFProcSubWF(pswfprocsubwfs);
    }
}
