package com.ibiz.wfweb.ht.feign;

import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.cloud.openfeign.FeignClient;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ibiz.wfweb.ht.domain.FJ;
import com.ibiz.wfweb.ht.filter.*;


public interface FJFeignClient {



	@RequestMapping(method = RequestMethod.POST, value = "/web/fjs/{fj_id}/save")
    public FJ save(@PathVariable("fj_id") String fj_id, @RequestBody FJ fj) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/fjs")
    public FJ create(@RequestBody FJ fj) ;

	@RequestMapping(method = RequestMethod.PUT, value = "/web/fjs/{fj_id}")
    public FJ update(@PathVariable("fj_id") String fj_id, @RequestBody FJ fj) ;

	@RequestMapping(method = RequestMethod.DELETE, value = "/web/fjs/{fj_id}")
    public Boolean remove(@PathVariable("fj_id") String fj_id) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/fjs/{fj_id}")
    public FJ get(@PathVariable("fj_id") String fj_id) ;

	@RequestMapping(method = RequestMethod.GET, value = "/web/fjs/{fj_id}/getdraft")
    public FJ getDraft(@PathVariable("fj_id") String fj_id, @RequestBody FJ fj) ;

	@RequestMapping(method = RequestMethod.POST, value = "/web/fjs/checkkey")
    public Boolean checkKey(@RequestBody FJ fj) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/fjs/fetchcurfj")
	public Page<FJ> fetchCurFJ(FJSearchContext searchContext) ;

    @RequestMapping(method= RequestMethod.GET , value="/web/fjs/fetchdefault")
	public Page<FJ> fetchDefault(FJSearchContext searchContext) ;
}
