package com.ibiz.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.ibiz.core.ht.valuerule.anno.bc.*;
import com.ibiz.core.ht.domain.BC;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 服务DTO对象[BCDTO]
 */
public class BCDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @BCCreateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp createDate;

    @JsonIgnore
    private boolean createDateDirtyFlag;

    /**
     * 属性 [BZ]
     *
     */
    @BCBzDefault(info = "默认规则")
    private String bz;

    @JsonIgnore
    private boolean bzDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @BCUpdateDateDefault(info = "默认规则")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp updateDate;

    @JsonIgnore
    private boolean updateDateDirtyFlag;

    /**
     * 属性 [BMLDIDS]
     *
     */
    @BCBmldidsDefault(info = "默认规则")
    private String bmldids;

    @JsonIgnore
    private boolean bmldidsDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @BCUpdateManDefault(info = "默认规则")
    private String updateMan;

    @JsonIgnore
    private boolean updateManDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @BCCreateManDefault(info = "默认规则")
    private String createMan;

    @JsonIgnore
    private boolean createManDirtyFlag;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @BCWfinstanceidDefault(info = "默认规则")
    private String wfinstanceid;

    @JsonIgnore
    private boolean wfinstanceidDirtyFlag;

    /**
     * 属性 [WFSTEP]
     *
     */
    @BCWfstepDefault(info = "默认规则")
    private String wfstep;

    @JsonIgnore
    private boolean wfstepDirtyFlag;

    /**
     * 属性 [BCNAME]
     *
     */
    @BCBCNameDefault(info = "默认规则")
    private String bCName;

    @JsonIgnore
    private boolean bCNameDirtyFlag;

    /**
     * 属性 [BCWFSTATE]
     *
     */
    @BCBcwfstateDefault(info = "默认规则")
    private String bcwfstate;

    @JsonIgnore
    private boolean bcwfstateDirtyFlag;

    /**
     * 属性 [BCID]
     *
     */
    @BCBCIdDefault(info = "默认规则")
    private String bCId;

    @JsonIgnore
    private boolean bCIdDirtyFlag;

    /**
     * 属性 [ORGDEPTNAME]
     *
     */
    @BCOrgDeptNameDefault(info = "默认规则")
    private String orgDeptName;

    @JsonIgnore
    private boolean orgDeptNameDirtyFlag;

    /**
     * 属性 [IMID]
     *
     */
    @BCIMIdDefault(info = "默认规则")
    private String iMId;

    @JsonIgnore
    private boolean iMIdDirtyFlag;

    /**
     * 属性 [ORGDEPTID]
     *
     */
    @BCOrgDeptIdDefault(info = "默认规则")
    private String orgDeptId;

    @JsonIgnore
    private boolean orgDeptIdDirtyFlag;


    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return createDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return createDateDirtyFlag ;
    }

    /**
     * 获取 [BZ]
     */
    @JsonProperty("bz")
    public String getBz(){
        return bz ;
    }

    /**
     * 设置 [BZ]
     */
    @JsonProperty("bz")
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [BZ]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return bzDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return updateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return updateDateDirtyFlag ;
    }

    /**
     * 获取 [BMLDIDS]
     */
    @JsonProperty("bmldids")
    public String getBmldids(){
        return bmldids ;
    }

    /**
     * 设置 [BMLDIDS]
     */
    @JsonProperty("bmldids")
    public void setBmldids(String  bmldids){
        this.bmldids = bmldids ;
        this.bmldidsDirtyFlag = true ;
    }

    /**
     * 获取 [BMLDIDS]脏标记
     */
    @JsonIgnore
    public boolean getBmldidsDirtyFlag(){
        return bmldidsDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return updateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return updateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return createMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return createManDirtyFlag ;
    }

    /**
     * 获取 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public String getWfinstanceid(){
        return wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    @JsonProperty("wfinstanceid")
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return wfinstanceidDirtyFlag ;
    }

    /**
     * 获取 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public String getWfstep(){
        return wfstep ;
    }

    /**
     * 设置 [WFSTEP]
     */
    @JsonProperty("wfstep")
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [WFSTEP]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return wfstepDirtyFlag ;
    }

    /**
     * 获取 [BCNAME]
     */
    @JsonProperty("bcname")
    public String getBCName(){
        return bCName ;
    }

    /**
     * 设置 [BCNAME]
     */
    @JsonProperty("bcname")
    public void setBCName(String  bCName){
        this.bCName = bCName ;
        this.bCNameDirtyFlag = true ;
    }

    /**
     * 获取 [BCNAME]脏标记
     */
    @JsonIgnore
    public boolean getBCNameDirtyFlag(){
        return bCNameDirtyFlag ;
    }

    /**
     * 获取 [BCWFSTATE]
     */
    @JsonProperty("bcwfstate")
    public String getBcwfstate(){
        return bcwfstate ;
    }

    /**
     * 设置 [BCWFSTATE]
     */
    @JsonProperty("bcwfstate")
    public void setBcwfstate(String  bcwfstate){
        this.bcwfstate = bcwfstate ;
        this.bcwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [BCWFSTATE]脏标记
     */
    @JsonIgnore
    public boolean getBcwfstateDirtyFlag(){
        return bcwfstateDirtyFlag ;
    }

    /**
     * 获取 [BCID]
     */
    @JsonProperty("bcid")
    public String getBCId(){
        return bCId ;
    }

    /**
     * 设置 [BCID]
     */
    @JsonProperty("bcid")
    public void setBCId(String  bCId){
        this.bCId = bCId ;
        this.bCIdDirtyFlag = true ;
    }

    /**
     * 获取 [BCID]脏标记
     */
    @JsonIgnore
    public boolean getBCIdDirtyFlag(){
        return bCIdDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTNAME]
     */
    @JsonProperty("orgdeptname")
    public String getOrgDeptName(){
        return orgDeptName ;
    }

    /**
     * 设置 [ORGDEPTNAME]
     */
    @JsonProperty("orgdeptname")
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTNAME]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return orgDeptNameDirtyFlag ;
    }

    /**
     * 获取 [IMID]
     */
    @JsonProperty("imid")
    public String getIMId(){
        return iMId ;
    }

    /**
     * 设置 [IMID]
     */
    @JsonProperty("imid")
    public void setIMId(String  iMId){
        this.iMId = iMId ;
        this.iMIdDirtyFlag = true ;
    }

    /**
     * 获取 [IMID]脏标记
     */
    @JsonIgnore
    public boolean getIMIdDirtyFlag(){
        return iMIdDirtyFlag ;
    }

    /**
     * 获取 [ORGDEPTID]
     */
    @JsonProperty("orgdeptid")
    public String getOrgDeptId(){
        return orgDeptId ;
    }

    /**
     * 设置 [ORGDEPTID]
     */
    @JsonProperty("orgdeptid")
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGDEPTID]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return orgDeptIdDirtyFlag ;
    }



    public BC toDO() {
        BC srfdomain = new BC();
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(createDate);
        if(getBzDirtyFlag())
            srfdomain.setBz(bz);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(updateDate);
        if(getBmldidsDirtyFlag())
            srfdomain.setBmldids(bmldids);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(updateMan);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(createMan);
        if(getWfinstanceidDirtyFlag())
            srfdomain.setWfinstanceid(wfinstanceid);
        if(getWfstepDirtyFlag())
            srfdomain.setWfstep(wfstep);
        if(getBCNameDirtyFlag())
            srfdomain.setBCName(bCName);
        if(getBcwfstateDirtyFlag())
            srfdomain.setBcwfstate(bcwfstate);
        if(getBCIdDirtyFlag())
            srfdomain.setBCId(bCId);
        if(getOrgDeptNameDirtyFlag())
            srfdomain.setOrgDeptName(orgDeptName);
        if(getIMIdDirtyFlag())
            srfdomain.setIMId(iMId);
        if(getOrgDeptIdDirtyFlag())
            srfdomain.setOrgDeptId(orgDeptId);

        return srfdomain;
    }

    public void fromDO(BC srfdomain) {
        if(srfdomain == null )
          return ;
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getBzDirtyFlag())
            this.setBz(srfdomain.getBz());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getBmldidsDirtyFlag())
            this.setBmldids(srfdomain.getBmldids());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getWfinstanceidDirtyFlag())
            this.setWfinstanceid(srfdomain.getWfinstanceid());
        if(srfdomain.getWfstepDirtyFlag())
            this.setWfstep(srfdomain.getWfstep());
        if(srfdomain.getBCNameDirtyFlag())
            this.setBCName(srfdomain.getBCName());
        if(srfdomain.getBcwfstateDirtyFlag())
            this.setBcwfstate(srfdomain.getBcwfstate());
        if(srfdomain.getBCIdDirtyFlag())
            this.setBCId(srfdomain.getBCId());
        if(srfdomain.getOrgDeptNameDirtyFlag())
            this.setOrgDeptName(srfdomain.getOrgDeptName());
        if(srfdomain.getIMIdDirtyFlag())
            this.setIMId(srfdomain.getIMId());
        if(srfdomain.getOrgDeptIdDirtyFlag())
            this.setOrgDeptId(srfdomain.getOrgDeptId());

    }

    public List<BCDTO> fromDOPage(List<BC> poPage)   {
        if(poPage == null)
            return null;
        List<BCDTO> dtos=new ArrayList<BCDTO>();
        for(BC domain : poPage) {
            BCDTO dto = new BCDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

