package com.ibiz.mybatis.htwf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import com.ibiz.core.repository.WFBCRepository;
import com.ibiz.core.repository.po.WFBC;
import com.ibiz.core.htwf.filter.WFBCSearchContext;
import com.ibiz.mybatis.htwf.mapper.T_WFBCMapper;
import com.ibiz.mybatis.htwf.po.T_WFBCImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ibiz.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_WFBC]存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "wfbc", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_WFBCRepositoryImpl extends ServiceImpl<T_WFBCMapper, T_WFBCImpl> implements WFBCRepository {

    
    /**
     * mybatis条件构造器
     */
    @Autowired
    QueryBuilder queryBuilder;
    /**
     * [T_WFBC]持久层映射对象
     */
    @Autowired
	T_WFBCMapper t_WFBCMapper;

    /**
     * 创建持久层对象
     * @return
     */
    public WFBC createPO(){
        return new T_WFBCImpl();
    }

    /**
     * 获取数据
     * @param key 业务数据主键
     * @return
     */
    public WFBC get(String key){
        return this.getById(key);
    }

    /**
     * 新建数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean create(WFBC po){
        boolean bOk = this.save((T_WFBCImpl)po);
        return bOk;
    }

    /**
     * 更新数据
     * @param po 持久层数据对象
     * @return
     */
    public boolean update(WFBC po){
        boolean bOk = this.updateById((T_WFBCImpl)po);
        return bOk;
    }

    /**
     * 删除数据
     * @param key 业务数据主键
     * @return
     */
    public boolean remove(String key){
        return this.removeById(key);
    }

    /**
     * 查询集合[Default]
     * @param context 查询上下文对象
     * @return
     */
    public Page<WFBC> searchDefault(WFBCSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<WFBC> page_datas=t_WFBCMapper.searchDefault(page,context,qw);
        List<WFBC> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<WFBC>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    /**
     * 持久层对象转业务对象
     * @param po 持久层对象
     * @param domain 业务对象
     * @return
     */
    public com.ibiz.core.htwf.domain.WFBC convert2Domain( WFBC po ,com.ibiz.core.htwf.domain.WFBC domain){
        if(po == null)
            return domain ;
        if(domain == null){
            domain = new com.ibiz.core.htwf.domain.WFBC();
        }
        //if(po.getWfstateDirtyFlag())
        domain.setWfstate(po.getWfstate());
        //if(po.getUpdateDateDirtyFlag())
        domain.setUpdateDate(po.getUpdateDate());
        //if(po.getWfstepDirtyFlag())
        domain.setWfstep(po.getWfstep());
        //if(po.getStateDirtyFlag())
        domain.setState(po.getState());
        //if(po.getProxydataidDirtyFlag())
        domain.setProxydataid(po.getProxydataid());
        //if(po.getCreateDateDirtyFlag())
        domain.setCreateDate(po.getCreateDate());
        //if(po.getWFBCNameDirtyFlag())
        domain.setWFBCName(po.getWFBCName());
        //if(po.getProxymoduleidDirtyFlag())
        domain.setProxymoduleid(po.getProxymoduleid());
        //if(po.getCreateManDirtyFlag())
        domain.setCreateMan(po.getCreateMan());
        //if(po.getWFBCIdDirtyFlag())
        domain.setWFBCId(po.getWFBCId());
        //if(po.getUpdateManDirtyFlag())
        domain.setUpdateMan(po.getUpdateMan());
        //if(po.getWfinstanceidDirtyFlag())
        domain.setWfinstanceid(po.getWfinstanceid());
        return domain ;
    }

    /**
     * 业务对象转持久层对象
     * @param domain 业务对象
     * @param po 持久层对象
     * @return
     */
    public WFBC convert2PO(com.ibiz.core.htwf.domain.WFBC domain , WFBC po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getWfstateDirtyFlag())
            po.setWfstate(domain.getWfstate());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getWfstepDirtyFlag())
            po.setWfstep(domain.getWfstep());
        if(domain.getStateDirtyFlag())
            po.setState(domain.getState());
        if(domain.getProxydataidDirtyFlag())
            po.setProxydataid(domain.getProxydataid());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getWFBCNameDirtyFlag())
            po.setWFBCName(domain.getWFBCName());
        if(domain.getProxymoduleidDirtyFlag())
            po.setProxymoduleid(domain.getProxymoduleid());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getWFBCIdDirtyFlag())
            po.setWFBCId(domain.getWFBCId());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getWfinstanceidDirtyFlag())
            po.setWfinstanceid(domain.getWfinstanceid());

        return po ;
    }
}
