package com.ibiz.mybatis.ht.po;

import com.ibiz.core.repository.po.BC;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.ibiz.util.annotation.PreField;
import com.ibiz.util.enums.FillMode;
import com.ibiz.util.enums.PredefinedType;

/**
 * 关系型数据实体表[BC] 对象
 */
@TableName(value = "T_BC",resultMap = "T_BCResultMap")
public class T_BCImpl implements BC,Serializable {

    /**
     * [建立时间]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    private Timestamp createDate;
    /**
     * [建立时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createDateDirtyFlag;

    /**
     * [备注]
     */
    private String bz;
    /**
     * [备注]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bzDirtyFlag;

    /**
     * [更新时间]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    private Timestamp updateDate;
    /**
     * [更新时间]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateDateDirtyFlag;

    /**
     * [部门领导清单]
     */
    private String bmldids;
    /**
     * [部门领导清单]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bmldidsDirtyFlag;

    /**
     * [更新人]
     */
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    private String updateMan;
    /**
     * [更新人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean updateManDirtyFlag;

    /**
     * [建立人]
     */
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    private String createMan;
    /**
     * [建立人]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean createManDirtyFlag;

    /**
     * [WFINSTANCEID]
     */
    private String wfinstanceid;
    /**
     * [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfinstanceidDirtyFlag;

    /**
     * [工作流步骤]
     */
    private String wfstep;
    /**
     * [工作流步骤]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean wfstepDirtyFlag;

    /**
     * [业务协作名称]
     */
    private String bCName;
    /**
     * [业务协作名称]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bCNameDirtyFlag;

    /**
     * [流程状态]
     */
    private String bcwfstate;
    /**
     * [流程状态]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bcwfstateDirtyFlag;

    /**
     * [业务协作标识]
     */
    @TableId(value= "bcid",type=IdType.UUID)
    private String bCId;
    /**
     * [业务协作标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean bCIdDirtyFlag;

    /**
     * [部门名称]
     */
    private String orgDeptName;
    /**
     * [部门名称]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean orgDeptNameDirtyFlag;

    /**
     * [重要事项标识]
     */
    private String iMId;
    /**
     * [重要事项标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean iMIdDirtyFlag;

    /**
     * [部门标识]
     */
    private String orgDeptId;
    /**
     * [部门标识]脏标记
     */
    @JsonIgnore
    @TableField(exist = false)
    private boolean orgDeptIdDirtyFlag;

    /**
     * 获取 [建立时间]
     */
    public Timestamp getCreateDate(){
        return this.createDate ;
    }

    /**
     * 设置 [建立时间]
     */
    public void setCreateDate(Timestamp  createDate){
        this.createDate = createDate ;
        this.createDateDirtyFlag = true ;
    }

    /**
     * 获取 [建立时间]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return this.createDateDirtyFlag ;
    }
    /**
     * 获取 [备注]
     */
    public String getBz(){
        return this.bz ;
    }

    /**
     * 设置 [备注]
     */
    public void setBz(String  bz){
        this.bz = bz ;
        this.bzDirtyFlag = true ;
    }

    /**
     * 获取 [备注]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return this.bzDirtyFlag ;
    }
    /**
     * 获取 [更新时间]
     */
    public Timestamp getUpdateDate(){
        return this.updateDate ;
    }

    /**
     * 设置 [更新时间]
     */
    public void setUpdateDate(Timestamp  updateDate){
        this.updateDate = updateDate ;
        this.updateDateDirtyFlag = true ;
    }

    /**
     * 获取 [更新时间]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return this.updateDateDirtyFlag ;
    }
    /**
     * 获取 [部门领导清单]
     */
    public String getBmldids(){
        return this.bmldids ;
    }

    /**
     * 设置 [部门领导清单]
     */
    public void setBmldids(String  bmldids){
        this.bmldids = bmldids ;
        this.bmldidsDirtyFlag = true ;
    }

    /**
     * 获取 [部门领导清单]脏标记
     */
    @JsonIgnore
    public boolean getBmldidsDirtyFlag(){
        return this.bmldidsDirtyFlag ;
    }
    /**
     * 获取 [更新人]
     */
    public String getUpdateMan(){
        return this.updateMan ;
    }

    /**
     * 设置 [更新人]
     */
    public void setUpdateMan(String  updateMan){
        this.updateMan = updateMan ;
        this.updateManDirtyFlag = true ;
    }

    /**
     * 获取 [更新人]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return this.updateManDirtyFlag ;
    }
    /**
     * 获取 [建立人]
     */
    public String getCreateMan(){
        return this.createMan ;
    }

    /**
     * 设置 [建立人]
     */
    public void setCreateMan(String  createMan){
        this.createMan = createMan ;
        this.createManDirtyFlag = true ;
    }

    /**
     * 获取 [建立人]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return this.createManDirtyFlag ;
    }
    /**
     * 获取 [WFINSTANCEID]
     */
    public String getWfinstanceid(){
        return this.wfinstanceid ;
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.wfinstanceidDirtyFlag = true ;
    }

    /**
     * 获取 [WFINSTANCEID]脏标记
     */
    @JsonIgnore
    public boolean getWfinstanceidDirtyFlag(){
        return this.wfinstanceidDirtyFlag ;
    }
    /**
     * 获取 [工作流步骤]
     */
    public String getWfstep(){
        return this.wfstep ;
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.wfstepDirtyFlag = true ;
    }

    /**
     * 获取 [工作流步骤]脏标记
     */
    @JsonIgnore
    public boolean getWfstepDirtyFlag(){
        return this.wfstepDirtyFlag ;
    }
    /**
     * 获取 [业务协作名称]
     */
    public String getBCName(){
        return this.bCName ;
    }

    /**
     * 设置 [业务协作名称]
     */
    public void setBCName(String  bCName){
        this.bCName = bCName ;
        this.bCNameDirtyFlag = true ;
    }

    /**
     * 获取 [业务协作名称]脏标记
     */
    @JsonIgnore
    public boolean getBCNameDirtyFlag(){
        return this.bCNameDirtyFlag ;
    }
    /**
     * 获取 [流程状态]
     */
    public String getBcwfstate(){
        return this.bcwfstate ;
    }

    /**
     * 设置 [流程状态]
     */
    public void setBcwfstate(String  bcwfstate){
        this.bcwfstate = bcwfstate ;
        this.bcwfstateDirtyFlag = true ;
    }

    /**
     * 获取 [流程状态]脏标记
     */
    @JsonIgnore
    public boolean getBcwfstateDirtyFlag(){
        return this.bcwfstateDirtyFlag ;
    }
    /**
     * 获取 [业务协作标识]
     */
    public String getBCId(){
        return this.bCId ;
    }

    /**
     * 设置 [业务协作标识]
     */
    public void setBCId(String  bCId){
        this.bCId = bCId ;
        this.bCIdDirtyFlag = true ;
    }

    /**
     * 获取 [业务协作标识]脏标记
     */
    @JsonIgnore
    public boolean getBCIdDirtyFlag(){
        return this.bCIdDirtyFlag ;
    }
    /**
     * 获取 [部门名称]
     */
    public String getOrgDeptName(){
        return this.orgDeptName ;
    }

    /**
     * 设置 [部门名称]
     */
    public void setOrgDeptName(String  orgDeptName){
        this.orgDeptName = orgDeptName ;
        this.orgDeptNameDirtyFlag = true ;
    }

    /**
     * 获取 [部门名称]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptNameDirtyFlag(){
        return this.orgDeptNameDirtyFlag ;
    }
    /**
     * 获取 [重要事项标识]
     */
    public String getIMId(){
        return this.iMId ;
    }

    /**
     * 设置 [重要事项标识]
     */
    public void setIMId(String  iMId){
        this.iMId = iMId ;
        this.iMIdDirtyFlag = true ;
    }

    /**
     * 获取 [重要事项标识]脏标记
     */
    @JsonIgnore
    public boolean getIMIdDirtyFlag(){
        return this.iMIdDirtyFlag ;
    }
    /**
     * 获取 [部门标识]
     */
    public String getOrgDeptId(){
        return this.orgDeptId ;
    }

    /**
     * 设置 [部门标识]
     */
    public void setOrgDeptId(String  orgDeptId){
        this.orgDeptId = orgDeptId ;
        this.orgDeptIdDirtyFlag = true ;
    }

    /**
     * 获取 [部门标识]脏标记
     */
    @JsonIgnore
    public boolean getOrgDeptIdDirtyFlag(){
        return this.orgDeptIdDirtyFlag ;
    }
}